/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Call;
import com.nexmo.sdk.conversation.client.CallEvent;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.DeliveredReceipt;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.ImageRepresentation;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.SocketClient;
import com.nexmo.sdk.conversation.client.SocketEventNotifier;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.client.event.container.Invitation;
import com.nexmo.sdk.conversation.client.event.container.Receipt;
import com.nexmo.sdk.conversation.client.event.container.SynchronisingState;
import com.nexmo.sdk.conversation.client.event.misc.SessionError;
import com.nexmo.sdk.conversation.core.client.request.CreateConversationRequest;
import com.nexmo.sdk.conversation.core.client.request.DeleteEventRequest;
import com.nexmo.sdk.conversation.core.client.request.DeliveredReceiptRequest;
import com.nexmo.sdk.conversation.core.client.request.GetConversationRequest;
import com.nexmo.sdk.conversation.core.client.request.GetEventsRequest;
import com.nexmo.sdk.conversation.core.client.request.InviteRequest;
import com.nexmo.sdk.conversation.core.client.request.JoinRequest;
import com.nexmo.sdk.conversation.core.client.request.SendImageMessageRequest;
import com.nexmo.sdk.conversation.core.client.request.SendTextMessageRequest;
import com.nexmo.sdk.conversation.core.client.request.TypingIndicatorRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.RtcNewRequest;
import com.nexmo.sdk.conversation.core.networking.ImageDelete;
import com.nexmo.sdk.conversation.core.networking.ImageDownloader;
import com.nexmo.sdk.conversation.core.persistence.ImageStorage;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Callback;
import okhttp3.Response;

class SocketEventHandler {
    private static final String TAG = SocketEventHandler.class.getSimpleName();
    private final List<Conversation> conversationList = new ArrayList<Conversation>();
    private final List<Conversation> createdConversationList = new ArrayList<Conversation>();
    private final List<Call> callList = Collections.synchronizedList(new ArrayList());
    private SocketClient socketClient;
    private SocketEventNotifier socketEventNotifier;
    private final CacheDB cacheDb;

    SocketEventHandler(SocketClient socketClient) {
        this.socketClient = socketClient;
        this.socketEventNotifier = socketClient.getConversationClient().getEventNotifier();
        this.cacheDb = CacheDB.getCacheDBInstance();
    }

    private Member onMemberJoinedAddMember(Conversation conversation, String memberId, User user, Date joinedTimestamp) {
        Member newMember = new Member(user.getUserId(), user.getName(), memberId, joinedTimestamp, null, null, Member.STATE.JOINED);
        conversation.addMember(newMember);
        newMember.setConversation(conversation);
        this.updateCacheAddMember(newMember);
        return newMember;
    }

    private void onMemberJoinedUpdateMember(Member member, Date joinedTimestamp) {
        member.updateState(Member.STATE.JOINED, joinedTimestamp);
        this.updateCacheOnMemberEvent(member);
    }

    void onMemberJoined(String cid, String memberId, User user, Date joinedTimestamp) {
        Log.d(TAG, "onMemberJoined ");
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation != null) {
            Member member = pendingConversation.getMember(memberId);
            if (member != null) {
                this.onMemberJoinedUpdateMember(member, joinedTimestamp);
            } else {
                member = this.onMemberJoinedAddMember(pendingConversation, memberId, user, joinedTimestamp);
            }
            pendingConversation.memberJoinedEvent().notifySubscriptions(member);
            if (pendingConversation.getDisplayName().startsWith("CALL_") && pendingConversation.isAudioEnabled()) {
                CallEvent callEvent = new CallEvent(Call.MEMBER_CALL_STATE.ANSWERED, member);
                Log.d(TAG, "CALL event " + callEvent.toString());
                Call ongoingCall = this.findCall(pendingConversation.getConversationId());
                if (ongoingCall != null) {
                    ongoingCall.event().notifySubscriptions(callEvent);
                }
            }
        } else {
            this.getConversation(cid, new RequestHandler<Conversation>(){

                @Override
                public void onError(NexmoAPIError apiError) {
                    Log.e(TAG, apiError.getMessage());
                }

                @Override
                public void onSuccess(Conversation conversation) {
                    conversation.setConversationSignalingChannel(SocketEventHandler.this.socketClient.getConversationClient().getSignallingChannel());
                    conversation.setSocketEventNotifier(SocketEventHandler.this.socketEventNotifier);
                    SocketEventHandler.this.updateCacheWithNewConversation(conversation);
                    SocketEventHandler.this.socketClient.getConversationClient().joinedToNewConversationEvent().notifySubscriptions(conversation);
                }
            });
        }
    }

    void onSelfInvited(String cid, String cName, final Member selfAsMember, final String invitedByUsername, final boolean isAudioEnabled) {
        Log.d(TAG, "onSelfInvited to a new conversation");
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation == null) {
            Log.d(TAG, "User received an invitation to a new conversation");
            final Conversation invitedConversation = new Conversation(cName, cid, selfAsMember);
            selfAsMember.setConversation(invitedConversation);
            invitedConversation.setSelf(selfAsMember);
            Log.d(TAG, "User received an invitation to a new conversation, self: " + invitedConversation.getSelf());
            invitedConversation.setConversationSignalingChannel(this.socketClient.getConversationClient().getSignallingChannel());
            invitedConversation.setSocketEventNotifier(this.socketEventNotifier);
            this.conversationList.add(invitedConversation);
            this.updateCacheAddConversation(invitedConversation, new RequestHandler<Conversation>(){

                @Override
                public void onSuccess(Conversation conversation) {
                    invitedConversation.updateBasicDetails(conversation);
                    SocketEventHandler.this.cacheDb.getConversationRepository().update(conversation, conversation.getConversationId());
                    SocketEventHandler.this.cacheDb.getMemberRepository().insertAll(conversation.getConversationId(), conversation.getMembers());
                    if (conversation.getDisplayName().startsWith("CALL_") && isAudioEnabled) {
                        Call incomingCall = new Call(conversation, invitedByUsername);
                        SocketEventHandler.this.updateCallList(incomingCall);
                        SocketEventHandler.this.socketClient.getConversationClient().callEvent().notifySubscriptions(incomingCall);
                    } else {
                        Invitation invitation = new Invitation(invitedConversation, selfAsMember, invitedByUsername, isAudioEnabled);
                        SocketEventHandler.this.socketClient.getConversationClient().invitedEvent().notifySubscriptions(invitation);
                    }
                }

                @Override
                public void onError(NexmoAPIError error) {
                    Log.e(TAG, error.getMessage());
                }
            });
        }
    }

    void onMemberInvited(String cid, Member invitedMember, String invitedByUsername) {
        Log.d(TAG, "onMemberInvited");
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation != null) {
            invitedMember.setConversation(pendingConversation);
            pendingConversation.addMember(invitedMember);
            this.updateCacheAddMember(invitedMember);
            Invitation invitation = new Invitation(pendingConversation, invitedMember, invitedByUsername);
            pendingConversation.memberInvitedEvent().notifySubscriptions(invitation);
        } else {
            Log.e(TAG, "onMemberInvited internal error. Receiving events from an unknown conversation!");
        }
    }

    void onMemberLeft(String cid, String memberId, User user, Date invited, Date joined, Date left) {
        Log.d(TAG, "onMemberLeft");
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation == null) {
            return;
        }
        Member member = pendingConversation.getMember(user);
        if (member != null) {
            member.updateState(Member.STATE.LEFT, left);
            this.updateCacheOnMemberEvent(member);
            pendingConversation.memberLeftEvent().notifySubscriptions(member);
            if (pendingConversation.getDisplayName().startsWith("CALL_") && pendingConversation.isAudioEnabled()) {
                CallEvent callEvent = new CallEvent(member.getJoinedAt() == null ? Call.MEMBER_CALL_STATE.REJECTED : Call.MEMBER_CALL_STATE.HUNGUP, member);
                Log.d(TAG, "CALL event " + callEvent.toString());
                Call ongoingCall = this.findCall(pendingConversation.getConversationId());
                if (ongoingCall != null) {
                    ongoingCall.event().notifySubscriptions(callEvent);
                }
            }
        } else {
            Log.e(TAG, "onMemberLeft internal error. Receiving events from an out-of-sync member!");
        }
    }

    Text onTextSent(String textId, Date timestamp, SendTextMessageRequest request) {
        Conversation pendingConversation = this.findConversation(request.cid);
        if (pendingConversation != null && pendingConversation.findText(textId) == null) {
            Text incomingText = new Text(request.message, textId, null, pendingConversation.getSelf(), pendingConversation);
            return incomingText;
        }
        return null;
    }

    Image onImageSent(String imageId, Date timestamp, SendImageMessageRequest request) {
        Conversation pendingConversation = this.findConversation(request.cid);
        if (pendingConversation != null && pendingConversation.findImage(imageId) == null) {
            Image image = new Image(imageId, null, pendingConversation.getSelf(), pendingConversation, request.original, request.medium, request.thumbnail);
            return image;
        }
        return null;
    }

    void onMessageDeleted(String cid, String memberId, String eventId, String deleteEventId, Date timestamp) {
        Event deletedEvent;
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation != null && pendingConversation.getMember(memberId) != null && (deletedEvent = pendingConversation.getEvent(eventId)) != null) {
            if (deletedEvent.getType() == EventType.IMAGE) {
                Image deletedImage = (Image)deletedEvent;
                this.cacheDeleteImageRepresentations(this.socketClient.getConversationClient().getContext(), (Image)deletedEvent);
                deletedImage.setRepresentations(null, null, null);
            } else if (deletedEvent.getType() == EventType.TEXT) {
                ((Text)deletedEvent).setText(null);
            }
            deletedEvent.setDeletedTimestamp(timestamp);
            pendingConversation.updateLastEventId(deleteEventId);
            this.updateCacheUpdateMessage(deletedEvent);
            pendingConversation.messageEvent().notifySubscriptions(deletedEvent);
        }
    }

    void onEventSeen(String cid, String memberId, String eventId, Date timestamp) {
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation != null) {
            Event seenEvent = pendingConversation.findEvent(eventId);
            Member seenBy = pendingConversation.getMember(memberId);
            if (seenEvent != null && seenBy != null) {
                SeenReceipt seenReceipt = new SeenReceipt(seenEvent, seenBy, timestamp);
                seenEvent.addSeenReceipt(seenReceipt);
                pendingConversation.updateLastEventId(seenEvent.id);
                this.updateCacheUpdateMessage(seenEvent);
                Receipt<SeenReceipt> receipt = new Receipt<SeenReceipt>(seenEvent, pendingConversation.getMember(memberId), seenReceipt);
                pendingConversation.seenEvent().notifySubscriptions(receipt);
            }
        }
    }

    void onEventDelivered(String cid, String memberId, String eventId, Date timestamp) {
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation == null) {
            return;
        }
        Event deliveredEvent = pendingConversation.findEvent(eventId);
        Member deliveredTo = pendingConversation.getMember(memberId);
        if (deliveredEvent != null && deliveredTo != null) {
            DeliveredReceipt deliveredReceipt = new DeliveredReceipt(deliveredEvent, deliveredTo, timestamp);
            deliveredEvent.addDeliveredReceipt(deliveredReceipt);
            pendingConversation.updateLastEventId(deliveredEvent.id);
            this.updateCacheUpdateMessage(deliveredEvent);
            Receipt<DeliveredReceipt> receipt = new Receipt<DeliveredReceipt>(deliveredEvent, pendingConversation.getMember(memberId), deliveredReceipt);
            pendingConversation.deliveryEvent().notifySubscriptions(receipt);
        }
    }

    void onMessageReceived(String cid, final Event event) {
        Log.d(TAG, "onMessageReceived " + event.toString());
        final Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation != null) {
            if (event.isReadyForMarkedAsDelivered()) {
                this.issueDeliveryReceiptInBackground(event);
            }
            this.updateCacheNewMessage(event);
            switch (event.getType()) {
                case TEXT: 
                case MEMBER_MEDIA: {
                    pendingConversation.messageEvent().notifySubscriptions(event);
                    break;
                }
                case IMAGE: {
                    Image relayedImage = (Image)event;
                    this.downloadImageRepresentation(relayedImage, ImageRepresentation.TYPE.THUMBNAIL, new RequestHandler<Void>(){

                        @Override
                        public void onError(NexmoAPIError apiError) {
                            Log.d(TAG, "onMessageReceived cannot be downloaded. Try later. " + apiError.toString());
                            pendingConversation.messageEvent().notifySubscriptions(event);
                        }

                        @Override
                        public void onSuccess(Void result) {
                            Log.d(TAG, "onMessageReceived Image THUMBNAIL was downloaded.");
                            pendingConversation.messageEvent().notifySubscriptions(event);
                        }
                    });
                    break;
                }
                default: {
                    Log.d(TAG, "unknown event type");
                    break;
                }
            }
        } else {
            Log.d(TAG, "onMessageReceived for not-sync conversation");
        }
    }

    void onTypingOnReceived(String cid, String memberId) {
        this.dispatchMemberTypeEvent(cid, memberId, Member.TYPING_INDICATOR.ON);
    }

    void onTypingOffReceived(String cid, String memberId) {
        this.dispatchMemberTypeEvent(cid, memberId, Member.TYPING_INDICATOR.OFF);
    }

    private void onJoinUpdateConversation(Conversation conversation, Member member, JoinRequest request) {
        Log.d(TAG, " onJoinUpdateConversation ");
        if (conversation.isSelf(member)) {
            conversation.getSelf().updateState(Member.STATE.JOINED, member.getJoinedAt());
            this.updateCacheOnMemberEvent(conversation.getSelf());
        } else {
            Member joinedMember = conversation.getMember(member.getMemberId());
            if (joinedMember != null) {
                joinedMember.updateState(Member.STATE.JOINED, member.getJoinedAt());
                this.updateCacheOnMemberEvent(joinedMember);
            } else {
                member.setConversation(conversation);
                conversation.addMember(member);
                this.updateCacheAddMember(member);
            }
        }
    }

    private Conversation onJoinNewConversation(final Member member, JoinRequest request) {
        Log.d(TAG, " onJoinNewConversation ");
        final Conversation createdConversation = this.findCreatedConversation(request.cid);
        if (createdConversation != null) {
            if (request.userId.equals(this.socketClient.self.getUserId()) || request.userName.equals(this.socketClient.self.getName())) {
                createdConversation.setSelf(member);
                member.setConversation(createdConversation);
                this.updateCacheAddConversation(createdConversation, new RequestHandler<Conversation>(){

                    @Override
                    public void onSuccess(Conversation conversation) {
                        createdConversation.updateBasicDetails(conversation);
                        member.setConversation(createdConversation);
                        SocketEventHandler.this.cacheDb.getConversationRepository().update(conversation, conversation.getConversationId());
                        SocketEventHandler.this.cacheDb.getMemberRepository().insertAll(conversation.getConversationId(), conversation.getMembers());
                    }

                    @Override
                    public void onError(NexmoAPIError error) {
                        Log.e(TAG, error.getMessage());
                    }
                });
                this.addOrUpdateConversationList(createdConversation);
                return createdConversation;
            }
            Conversation newConversation = new Conversation(request.cName, request.cid);
            member.setConversation(newConversation);
            newConversation.setConversationSignalingChannel(this.socketClient.getConversationClient().getSignallingChannel());
            newConversation.setSocketEventNotifier(this.socketEventNotifier);
            return newConversation;
        }
        return null;
    }

    void onConversationCreated(Conversation conversation) {
        this.addOrUpdateCreatedConversationList(conversation);
    }

    void addNewConversationToMemory(Conversation conversation) {
        this.addOrUpdateCreatedConversationList(conversation);
    }

    void onNewConversationHelperSuccessCreated(final Conversation conversation, final CreateConversationRequest request, final Member member) {
        conversation.setSelf(member);
        member.setConversation(conversation);
        this.updateCacheAddConversation(conversation, new RequestHandler<Conversation>(){

            @Override
            public void onSuccess(Conversation updatedConversation) {
                conversation.updateBasicDetails(updatedConversation);
                member.setConversation(conversation);
                SocketEventHandler.this.cacheDb.getConversationRepository().update(conversation, conversation.getConversationId());
                SocketEventHandler.this.cacheDb.getMemberRepository().insertAll(conversation.getConversationId(), conversation.getMembers());
                request.getListener().onSuccess((Conversation)conversation);
            }

            @Override
            public void onError(NexmoAPIError error) {
                Log.e(TAG, error.getMessage());
            }
        });
        this.addOrUpdateCreatedConversationList(conversation);
        Log.d(TAG, "onJoin " + member.toString());
    }

    String onRtcNew(RtcNewRequest request, RtcNewRequest.RtcNewResponse response) {
        Log.d(TAG, "onRtcNew " + response.rtc_id);
        Conversation pendingConversation = this.findConversation(request.cid);
        pendingConversation.updateRtcId(response.rtc_id);
        return response.rtc_id;
    }

    void onJoin(Member member, JoinRequest request) {
        Log.d(TAG, "onJoin " + member.toString());
        Conversation pendingConversation = this.findConversation(request.cid);
        if (pendingConversation == null) {
            pendingConversation = this.onJoinNewConversation(member, request);
        } else {
            this.onJoinUpdateConversation(pendingConversation, member, request);
        }
        this.addOrUpdateConversationList(pendingConversation);
    }

    final List<Conversation> getConversationList() {
        return this.conversationList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onConversations(List<Conversation> conversations) {
        if ((long)conversations.size() > 150L) {
            this.socketClient.getConversationClient().synchronisationEvent().notifySubscriptions(SynchronisingState.STATE.OUT_OF_SYNC);
            this.socketClient.getConversationClient().getSignallingChannel().updateSyncState(SynchronisingState.STATE.OUT_OF_SYNC);
            return;
        }
        this.socketClient.getConversationClient().synchronisationEvent().notifySubscriptions(SynchronisingState.STATE.CONVERSATIONS);
        this.socketClient.getConversationClient().getSignallingChannel().updateSyncState(SynchronisingState.STATE.CONVERSATIONS);
        for (Conversation conversation : conversations) {
            conversation.setConversationSignalingChannel(this.socketClient.getConversationClient().getSignallingChannel());
            conversation.setSocketEventNotifier(this.socketEventNotifier);
        }
        List<Conversation> list = this.conversationList;
        synchronized (list) {
            this.conversationList.clear();
            this.conversationList.addAll(conversations);
        }
        this.updateCacheOnConversations();
    }

    Conversation onConversation(Conversation conversation, GetConversationRequest request) {
        this.addOrUpdateConversationList(conversation);
        return conversation;
    }

    Conversation onEventsHistory(List<Event> events, GetEventsRequest request) {
        Conversation pendingConversation = this.findConversation(request.cid);
        if (pendingConversation == null) {
            return null;
        }
        for (Event event : events) {
            event.setConversation(pendingConversation);
            String memberId = event.getMember().getMemberId();
            Member sender = pendingConversation.getMember(memberId);
            if (sender == null) continue;
            event.setMember(sender);
            for (SeenReceipt seenReceipt : event.getSeenReceipts()) {
                seenReceipt.setEvent(event);
                Member seenByMember = pendingConversation.getMember(seenReceipt.getMember().getMemberId());
                if (seenByMember == null) continue;
                seenReceipt.setMember(seenByMember);
            }
            for (DeliveredReceipt deliveredReceipt : event.getDeliveredReceipts()) {
                deliveredReceipt.setEvent(event);
                Member deliveredToMember = pendingConversation.getMember(deliveredReceipt.getMember().getMemberId());
                if (deliveredToMember == null) continue;
                deliveredReceipt.setMember(deliveredToMember);
            }
            if (event.isReadyForMarkedAsDelivered()) {
                this.issueDeliveryReceiptInBackground(event);
            }
            if (event.getType() != EventType.IMAGE || event.deletedTimestamp != null) continue;
            this.downloadImageRepresentation((Image)event, ImageRepresentation.TYPE.THUMBNAIL, null);
        }
        pendingConversation.setEvents(events);
        this.addOrUpdateConversationList(pendingConversation);
        if (pendingConversation.getSelf() != null) {
            this.updateCacheOfMessageEvents(pendingConversation);
        }
        return pendingConversation;
    }

    Member.TYPING_INDICATOR onTyping(Member.TYPING_INDICATOR indicator, TypingIndicatorRequest request) {
        Conversation pendingConversation = this.findConversation(request.cid);
        if (pendingConversation != null) {
            Member sender = pendingConversation.getMember(request.memberId);
            if (sender != null) {
                sender.setTypingIndicator(indicator);
            } else {
                request.listener.onError(NexmoAPIError.unexpectedResponse(request.getRequestId(), pendingConversation.getConversationId()));
            }
        }
        return indicator;
    }

    Member onInvitationSent(String userId, String memberId, Date timestampInvited, InviteRequest request) {
        Conversation pendingConversation = this.findConversation(request.cid);
        if (pendingConversation != null) {
            Member invitedMember = new Member(userId, request.user, memberId);
            invitedMember.updateState(Member.STATE.INVITED, timestampInvited);
            return invitedMember;
        }
        return null;
    }

    void onSessionError(SessionError sessionError) {
        this.socketClient.getConversationClient().sessionErrorEvent().notifySubscriptions(sessionError);
    }

    void downloadImageRepresentation(final Image image, final ImageRepresentation.TYPE type, final RequestHandler<Void> downloadListener) {
        Callback downloadCallback = new Callback(){

            public void onFailure(okhttp3.Call call, IOException e) {
                Log.d(TAG, "onFailure download " + e.toString());
                if (downloadListener != null) {
                    image.getConversation().getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                        @Override
                        public void run() {
                            downloadListener.onError(NexmoAPIError.downloadFailure(image.getConversation().getConversationId()));
                        }
                    });
                }
            }

            public void onResponse(okhttp3.Call call, Response response) throws IOException {
                Log.d(TAG, "onResponse download:" + (Object)((Object)type));
                if (!response.isSuccessful()) {
                    final NexmoAPIError downloadError = new NexmoAPIError("image:download-failure", image.conversation.getConversationId(), "Unexpected code " + response.code());
                    if (downloadListener != null) {
                        image.getConversation().getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                            @Override
                            public void run() {
                                downloadListener.onError(downloadError);
                            }
                        });
                    }
                    response.body().close();
                    return;
                }
                Bitmap bitmap = ImageDownloader.decodeImage(response);
                switch (type) {
                    case ORIGINAL: {
                        image.getOriginal().setBitmap(bitmap);
                        break;
                    }
                    case MEDIUM: {
                        image.getMedium().setBitmap(bitmap);
                        break;
                    }
                    case THUMBNAIL: {
                        image.getThumbnail().setBitmap(bitmap);
                    }
                }
                SocketEventHandler.this.cacheImageRepresentation(SocketEventHandler.this.socketClient.getConversationClient().getContext(), image, type, downloadListener);
                response.body().close();
            }
        };
        ImageDownloader.downloadImage(image.getImageRepresentationByType(type), downloadCallback, this.socketClient.getConversationClient().getToken());
    }

    void deleteImageRepresentations(Image image, RequestHandler listener) {
        long _ts = System.currentTimeMillis();
        Log.d(TAG, "Starting image delete.. ");
        if (image.getOriginal() != null) {
            this.deleteImageRepresentation(image, image.getOriginal(), listener);
        }
        if (image.getMedium() != null) {
            this.deleteImageRepresentation(image, image.getMedium(), listener);
        }
        if (image.getThumbnail() != null) {
            this.deleteImageRepresentation(image, image.getThumbnail(), listener);
        }
        Log.d(TAG, "Delete took " + (System.currentTimeMillis() - _ts) + "ms");
    }

    private void deleteImageRepresentation(final Image image, final ImageRepresentation imageRepresentation, final RequestHandler<Void> listener) {
        Callback deleteCallback = new Callback(){

            public void onFailure(okhttp3.Call call, IOException e) {
                Log.d(TAG, "onFailure " + e.getMessage());
                listener.onError(new NexmoAPIError("image:delete-failure", "Image delete rejected." + e.getMessage()));
            }

            public void onResponse(okhttp3.Call call, Response response) throws IOException {
                Log.d(TAG, "onResponse " + response.toString());
                if (!response.isSuccessful()) {
                    listener.onError(new NexmoAPIError("image:delete-failure", "Image delete rejected." + response.code()));
                    response.body().close();
                    return;
                }
                imageRepresentation.updateUrl(null);
                if (TextUtils.isEmpty((CharSequence)image.getOriginal().getUrl()) && TextUtils.isEmpty((CharSequence)image.getMedium().getUrl()) && TextUtils.isEmpty((CharSequence)image.getThumbnail().getUrl())) {
                    DeleteEventRequest deleteEventRequest = new DeleteEventRequest(image.getConversation().getConversationId(), image.getMember().getMemberId(), image.getId(), listener);
                    SocketEventHandler.this.socketClient.deleteEvent(deleteEventRequest);
                }
                response.body().close();
            }
        };
        ImageDelete.deleteImage(imageRepresentation.getUrl(), deleteCallback, this.socketClient.getConversationClient().getToken());
    }

    private void cacheImageRepresentation(Context context, final Image image, ImageRepresentation.TYPE type, final RequestHandler downloadListener) {
        Log.d(TAG, " cacheImageRepresentation " + (Object)((Object)type));
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            String representationPath = ImageStorage.saveFileToDisk(context, image, type);
            image.getImageRepresentationByType(type).updateLocalFilePath(representationPath);
            this.updateCacheUpdateMessage(image);
            if (downloadListener != null) {
                image.getConversation().getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                    @Override
                    public void run() {
                        downloadListener.onSuccess(null);
                    }
                });
            }
        } else if (downloadListener != null) {
            image.getConversation().getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                @Override
                public void run() {
                    downloadListener.onError(NexmoAPIError.permissionRequired(image.getConversation().getConversationId()));
                }
            });
        }
    }

    private void cacheDeleteImageRepresentations(Context context, Image image) {
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            ImageStorage.deleteFilesFromDisk(context, image);
            image.updateLocalFilePaths(null);
        }
        this.updateCacheUpdateMessage(image);
    }

    private void dispatchMemberTypeEvent(String cid, String memberId, Member.TYPING_INDICATOR typing_indicator) {
        Member typingMember;
        Conversation pendingConversation = this.findConversation(cid);
        if (pendingConversation != null && (typingMember = pendingConversation.getMember(memberId)) != null) {
            typingMember.setTypingIndicator(typing_indicator);
            pendingConversation.typingEvent().notifySubscriptions(typingMember);
        }
    }

    private void issueDeliveryReceiptInBackground(Event event) {
        DeliveredReceiptRequest deliveredReceiptRequest = new DeliveredReceiptRequest(event, new RequestHandler(){

            @Override
            public void onError(NexmoAPIError error) {
                Log.d(TAG, "issueDeliveryReceiptInBackground failed " + error.getMessage());
            }

            @Override
            public void onSuccess(Object result) {
                Log.d(TAG, "issueDeliveryReceiptInBackground done");
            }
        });
        this.socketClient.sendReceiptRecord(deliveredReceiptRequest);
    }

    Call findCall(String callId) {
        for (Call call : this.callList) {
            if (!call.getConversation().getConversationId().equals(callId)) continue;
            return call;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Conversation findConversation(String cid) {
        List<Conversation> list = this.conversationList;
        synchronized (list) {
            for (Conversation conversation : this.conversationList) {
                if (!conversation.getConversationId().equals(cid)) continue;
                return conversation;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Conversation findCreatedConversation(String cid) {
        List<Conversation> list = this.createdConversationList;
        synchronized (list) {
            for (Conversation conversation : this.createdConversationList) {
                if (!conversation.getConversationId().equals(cid)) continue;
                return conversation;
            }
        }
        return null;
    }

    private List<String> checkIfConversationsNeedSync(List<Conversation> fetchedConversations, User self) {
        Log.d(TAG, "checkIfConversationsNeedSync");
        ArrayList<String> cidsToUpdate = new ArrayList<String>();
        HashMap<String, Conversation> freshConversationMap = new HashMap<String, Conversation>();
        Map<String, Conversation> cachedConversationsMap = this.cacheDb.getConversationRepository().getConversationsListAsMap(self);
        for (Conversation freshConversation : fetchedConversations) {
            freshConversationMap.put(freshConversation.getConversationId(), freshConversation);
            Conversation cachedConversation = cachedConversationsMap.get(freshConversation.getConversationId());
            if (cachedConversation == null) {
                Log.d(TAG, "checkIfConversationsNeedSync: Yes, conversation not cached yet");
                this.cacheDb.getConversationRepository().insert(freshConversation, freshConversation.getConversationId());
                cidsToUpdate.add(freshConversation.getConversationId());
                continue;
            }
            if (TextUtils.equals((CharSequence)cachedConversation.getLastEventId(), (CharSequence)freshConversation.getLastEventId())) {
                freshConversation.setMembers(cachedConversation.getMembers());
                continue;
            }
            Log.d(TAG, "Cached conversation has to update members and messages");
            freshConversation.markAsDirty(true);
            cidsToUpdate.add(freshConversation.getConversationId());
        }
        ArrayList<String> idsToRemove = new ArrayList<String>();
        for (Conversation cachedConversation : cachedConversationsMap.values()) {
            if (freshConversationMap.containsKey(cachedConversation.getConversationId())) continue;
            idsToRemove.add(cachedConversation.getConversationId());
        }
        this.cacheDb.getConversationRepository().delete(idsToRemove);
        return cidsToUpdate;
    }

    private void syncMessagesIfNeeded(Conversation conversation) {
        String cid = conversation.getConversationId();
        List<Event> messagesFromCAPI = conversation.getEvents();
        List<String> cachedMessageIds = this.cacheDb.getEventRepository().getEventIds(conversation);
        Log.d(TAG, "syncMessagesIfNeeded - cachedMessageIds: " + cachedMessageIds.toString());
        for (Event freshEvent : messagesFromCAPI) {
            if (cachedMessageIds.contains(freshEvent.getId())) {
                cachedMessageIds.remove(freshEvent.getId());
                continue;
            }
            this.cacheDb.getEventRepository().insert(freshEvent, cid);
        }
        this.cacheDb.getEventRepository().delete(cachedMessageIds);
    }

    private void updateCacheOnConversations() {
        List<Object> cidsToUpdate = new ArrayList();
        if (this.cacheDb.tableContainsRows("conversation")) {
            cidsToUpdate = this.checkIfConversationsNeedSync(this.conversationList, this.socketClient.getConversationClient().getUser());
        } else {
            for (Conversation conversation : this.conversationList) {
                if (conversation.getSelf() == null) continue;
                cidsToUpdate.add(conversation.getConversationId());
            }
            this.cacheDb.getConversationRepository().insertAll(this.conversationList);
        }
        final int totalItems = cidsToUpdate.size();
        AtomicInteger iteration = new AtomicInteger();
        Log.d(TAG, "updateCacheOnConversations for total conversations: " + totalItems);
        if (totalItems == 0) {
            this.socketClient.getConversationClient().synchronisationEvent().notifySubscriptions(SynchronisingState.STATE.MEMBERS);
            this.socketEventNotifier.notifyConversationListListener(this.conversationList);
            this.socketClient.getConversationClient().getSignallingChannel().updateSyncState(SynchronisingState.STATE.MEMBERS);
            return;
        }
        for (final String string2 : cidsToUpdate) {
            final int counter = iteration.incrementAndGet();
            this.updateCacheOfMembersForConversation(string2, new RequestHandler<Conversation>(){

                @Override
                public void onSuccess(Conversation conversation) {
                    Conversation pendingConversation = SocketEventHandler.this.findConversation(string2);
                    if (pendingConversation != null) {
                        pendingConversation.updateBasicDetails(conversation);
                        if (pendingConversation.getSelf() != null) {
                            SocketEventHandler.this.cacheDb.getConversationRepository().update(conversation, conversation.getConversationId());
                            SocketEventHandler.this.cacheDb.getMemberRepository().insertAll(conversation.getConversationId(), conversation.getMembers());
                        }
                        if (counter == totalItems) {
                            SocketEventHandler.this.socketClient.getConversationClient().synchronisationEvent().notifySubscriptions(SynchronisingState.STATE.MEMBERS);
                            SocketEventHandler.this.socketEventNotifier.notifyConversationListListener(SocketEventHandler.this.conversationList);
                            SocketEventHandler.this.socketClient.getConversationClient().getSignallingChannel().updateSyncState(SynchronisingState.STATE.MEMBERS);
                        }
                    }
                }

                @Override
                public void onError(NexmoAPIError error) {
                }
            });
        }
    }

    private void updateCacheOfMessageEvents(Conversation conversation) {
        if (this.cacheDb.getEventRepository().isAny(conversation.getConversationId())) {
            this.syncMessagesIfNeeded(conversation);
        } else {
            this.cacheDb.getEventRepository().insertAll(conversation.getConversationId(), conversation.getEvents());
        }
    }

    private void updateCacheOfMembersForConversation(String cid, RequestHandler<Conversation> requestHandler) {
        this.socketClient.getConversation(new GetConversationRequest(cid, requestHandler));
    }

    private void updateCacheOnMemberEvent(Member member) {
        this.cacheDb.getMemberRepository().update(member, member.getConversation().getConversationId());
    }

    private void updateCacheAddMember(Member member) {
        this.cacheDb.getMemberRepository().insert(member, member.getConversation().getConversationId());
    }

    private void updateCacheAddConversation(Conversation conversationToUpdate, RequestHandler<Conversation> requestHandler) {
        if (requestHandler == null) {
            return;
        }
        this.cacheDb.getConversationRepository().insert(conversationToUpdate, conversationToUpdate.getConversationId());
        this.socketClient.getConversation(new GetConversationRequest(conversationToUpdate.getConversationId(), requestHandler));
    }

    private void getConversation(String cid, RequestHandler<Conversation> requestHandler) {
        if (requestHandler == null) {
            return;
        }
        this.socketClient.getConversation(new GetConversationRequest(cid, requestHandler));
    }

    private void updateCacheWithNewConversation(Conversation conversationToUpdate) {
        this.cacheDb.getConversationRepository().insert(conversationToUpdate, conversationToUpdate.getConversationId());
        this.cacheDb.getMemberRepository().insertAll(conversationToUpdate.getConversationId(), conversationToUpdate.getMembers());
    }

    private void updateCacheNewMessage(Event event) {
        Conversation updatedConversation = event.getConversation();
        this.cacheDb.getConversationRepository().update(updatedConversation, updatedConversation.getConversationId());
        this.cacheDb.getEventRepository().insert(event, updatedConversation.getConversationId());
    }

    private void updateCacheUpdateMessage(Event event) {
        Conversation updatedConversation = event.getConversation();
        this.cacheDb.getConversationRepository().update(updatedConversation, updatedConversation.getConversationId());
        this.cacheDb.getEventRepository().update(event, updatedConversation.getConversationId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateConversationList(Conversation joinedConversation) {
        List<Conversation> list = this.conversationList;
        synchronized (list) {
            for (int i = 0; i < this.conversationList.size(); ++i) {
                if (!this.conversationList.get(i).getConversationId().equals(joinedConversation.getConversationId())) continue;
                this.conversationList.set(i, joinedConversation);
                return;
            }
            this.conversationList.add(joinedConversation);
        }
    }

    public void updateCallList(Call outgoingCall) {
        this.callList.add(outgoingCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdateCreatedConversationList(Conversation createdConversation) {
        List<Conversation> list = this.createdConversationList;
        synchronized (list) {
            for (int i = 0; i < this.createdConversationList.size(); ++i) {
                if (!this.createdConversationList.get(i).getConversationId().equals(createdConversation.getConversationId())) continue;
                this.createdConversationList.set(i, createdConversation);
                return;
            }
            this.createdConversationList.add(createdConversation);
        }
    }
}

