/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.ConversationClient;
import com.nexmo.sdk.conversation.client.ConversationSignalingChannel;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.MemberMedia;
import com.nexmo.sdk.conversation.client.ReceiptRecordUtil;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.SocketEventHandler;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.audio.RtcEvents;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.client.event.ResultListener;
import com.nexmo.sdk.conversation.client.event.container.SynchronisingState;
import com.nexmo.sdk.conversation.client.event.misc.SessionError;
import com.nexmo.sdk.conversation.client.event.network.CAPIAwareListener;
import com.nexmo.sdk.conversation.client.event.network.CAPIInternalRequest;
import com.nexmo.sdk.conversation.client.event.network.NetworkState;
import com.nexmo.sdk.conversation.client.event.network.NetworkingStateListener;
import com.nexmo.sdk.conversation.client.event.network.SubscriptionListener;
import com.nexmo.sdk.conversation.core.client.Router;
import com.nexmo.sdk.conversation.core.client.request.CreateConversationRequest;
import com.nexmo.sdk.conversation.core.client.request.DeleteEventRequest;
import com.nexmo.sdk.conversation.core.client.request.DeliveredReceiptRequest;
import com.nexmo.sdk.conversation.core.client.request.GetConversationRequest;
import com.nexmo.sdk.conversation.core.client.request.GetConversationsRequest;
import com.nexmo.sdk.conversation.core.client.request.GetEventsRequest;
import com.nexmo.sdk.conversation.core.client.request.GetUserInfoRequest;
import com.nexmo.sdk.conversation.core.client.request.InviteRequest;
import com.nexmo.sdk.conversation.core.client.request.InviteWithAudioRequest;
import com.nexmo.sdk.conversation.core.client.request.JoinRequest;
import com.nexmo.sdk.conversation.core.client.request.LeaveRequest;
import com.nexmo.sdk.conversation.core.client.request.LoginRequest;
import com.nexmo.sdk.conversation.core.client.request.LogoutRequest;
import com.nexmo.sdk.conversation.core.client.request.PushRegisterRequest;
import com.nexmo.sdk.conversation.core.client.request.PushSubscriptionRequest;
import com.nexmo.sdk.conversation.core.client.request.PushUnregisterRequest;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.client.request.SeenReceiptRequest;
import com.nexmo.sdk.conversation.core.client.request.SendImageMessageRequest;
import com.nexmo.sdk.conversation.core.client.request.SendTextMessageRequest;
import com.nexmo.sdk.conversation.core.client.request.TypingIndicatorRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.AudioEarmuffRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.AudioMuteRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.AudioRingingRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.RtcNewRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.RtcTerminateRequest;
import com.nexmo.sdk.conversation.core.persistence.UserPreference;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import com.nexmo.sdk.conversation.device.DeviceProperties;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.SessionDescription;

class SocketClient
implements NetworkingStateListener {
    private static final String TAG = SocketClient.class.getSimpleName();
    private static final String RTC_MEMBER_MEDIA = "member:media";
    private static final String RTC_ANSWER = "rtc:answer";
    public static final String CONVERSATION_MEMBER_JOINED = "member:joined";
    public static final String MEMBER_INVITED = "member:invited";
    public static final String MEMBER_LEFT = "member:left";
    public static final String EVENT_ERROR = "event:error";
    static boolean DEBUG_INCOMING_DATA = true;
    private ConversationClient conversationClient;
    private SocketEventHandler socketEventHandler;
    private RequestHandler<User> loginListener;
    private Set<NetworkingStateListener> networkingStateListeners = Collections.synchronizedSet(new HashSet());
    public Router router;
    User self;
    private RtcEvents rtcEventsListener;
    private Emitter.Listener onMessageDeleted = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onDeleted " + data.toString());
            String from = data.getString("from");
            String cid = data.getString("cid");
            Date timestamp = null;
            try {
                timestamp = DateUtil.formatIso8601DateString(data.getString("timestamp"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            JSONObject body = data.getJSONObject("body");
            SocketClient.this.socketEventHandler.onMessageDeleted(cid, from, body.getString("event_id"), data.getString("id"), timestamp);
        }
    };
    private Emitter.Listener onMessageReceived = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onMessage " + data.toString());
            String cid = data.getString("cid");
            Conversation conversation = SocketClient.this.socketEventHandler.findConversation(cid);
            if (conversation != null) {
                SocketClient.this.socketEventHandler.onMessageReceived(cid, Event.fromJson(conversation, data));
            } else {
                Log.d(TAG, "onMessageReceived: outOfSync, unknown conversation");
            }
        }
    };
    private Emitter.Listener onTypeOn = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onTypeOn received " + data.toString());
            String cid = data.getString("cid");
            String memberId = data.getString("from");
            SocketClient.this.socketEventHandler.onTypingOnReceived(cid, memberId);
        }
    };
    private Emitter.Listener onTypeOff = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onTypeOn received " + data.toString());
            String cid = data.getString("cid");
            String memberId = data.getString("from");
            SocketClient.this.socketEventHandler.onTypingOffReceived(cid, memberId);
        }
    };
    private Emitter.Listener onImageSeen = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onImageSeen " + data.toString());
            ReceiptRecordUtil.parseSeenReceipt(data, SocketClient.this.socketEventHandler);
        }
    };
    private Emitter.Listener onTextDelivered = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onTextDelivered" + data.toString());
            ReceiptRecordUtil.parseDeliveredReceipt(data, SocketClient.this.socketEventHandler);
        }
    };
    private Emitter.Listener onImageDelivered = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onImageDelivered" + data.toString());
            ReceiptRecordUtil.parseDeliveredReceipt(data, SocketClient.this.socketEventHandler);
        }
    };
    private Emitter.Listener onTextSeen = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onTextSeen" + data.toString());
            ReceiptRecordUtil.parseSeenReceipt(data, SocketClient.this.socketEventHandler);
        }
    };
    private Emitter.Listener onMemberInvited = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "onInvitation received " + data.toString());
            String cid = data.getString("cid");
            JSONObject body = data.getJSONObject("body");
            String cName = body.getString("cname");
            String senderUsername = body.getString("invited_by");
            JSONObject time = body.getJSONObject("timestamp");
            Date timestampInvitedAt = null;
            try {
                timestampInvitedAt = DateUtil.formatIso8601DateString(time.getString("invited"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            JSONObject user = body.getJSONObject("user");
            Member invitedMember = new Member(user.getString("user_id"), user.getString("name"), user.getString("member_id"), null, timestampInvitedAt, null, Member.STATE.INVITED);
            boolean hasMediaEnabled = false;
            if (user.has("media")) {
                hasMediaEnabled = user.getJSONObject("media").has("audio");
            }
            if (SocketClient.this.isMemberSelf(invitedMember)) {
                SocketClient.this.socketEventHandler.onSelfInvited(cid, cName, invitedMember, senderUsername, hasMediaEnabled);
            } else {
                SocketClient.this.socketEventHandler.onMemberInvited(cid, invitedMember, senderUsername);
            }
        }
    };
    private Emitter.Listener onMemberLeft = new Listener(){

        @Override
        public void onData(JSONObject data, @Nullable String rid) throws Throwable {
            Log.d(TAG, "onMemberLeft " + data.toString());
            String cid = data.getString("cid");
            String memberId = data.getString("from");
            JSONObject body = data.getJSONObject("body");
            JSONObject timestamp = body.getJSONObject("timestamp");
            Date joinedTimestamp = null;
            Date leftTimestamp = null;
            Date invitedTimestamp = null;
            try {
                if (timestamp.has("joined")) {
                    joinedTimestamp = DateUtil.formatIso8601DateString(timestamp.getString("joined"));
                }
                if (timestamp.has("left")) {
                    leftTimestamp = DateUtil.formatIso8601DateString(timestamp.getString("left"));
                }
                if (timestamp.has("invited")) {
                    invitedTimestamp = DateUtil.formatIso8601DateString(timestamp.getString("invited"));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            User user = User.fromJson(body.getJSONObject("user"));
            SocketClient.this.socketEventHandler.onMemberLeft(cid, memberId, user, invitedTimestamp, joinedTimestamp, leftTimestamp);
        }
    };
    private Emitter.Listener onMemberJoined = new Listener(){

        @Override
        public void onData(JSONObject data, @Nullable String rid) throws Throwable {
            Log.d(TAG, "onMemberJoined " + data.toString());
            String from = data.getString("from");
            String cid = data.getString("cid");
            JSONObject body = data.getJSONObject("body");
            JSONObject userObject = body.getJSONObject("user");
            User user = User.fromJson(userObject);
            JSONObject timestamp = body.getJSONObject("timestamp");
            Date joinedTimestamp = null;
            try {
                joinedTimestamp = DateUtil.formatIso8601DateString(timestamp.getString("joined"));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            SocketClient.this.socketEventHandler.onMemberJoined(cid, from, user, joinedTimestamp);
        }
    };
    private SubscriptionListener sessionError = new SubscriptionListener(){

        @Override
        public void onData(String eventName, JSONObject jsonObject) throws JSONException {
            Log.d(TAG, "onSessionError (" + eventName + "): " + jsonObject);
            SocketClient.this.router.shutdown();
            SocketClient.this.socketEventHandler.onSessionError(SessionError.getByEventName(eventName));
        }
    };
    private Emitter.Listener onEventError = new Emitter.Listener(){

        public void call(Object ... args) {
            JSONObject data = (JSONObject)args[0];
            Log.d("onEventError ", data.toString());
        }
    };
    private Emitter.Listener onRtcAnswer = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG + " onRtcAnswer ", data.toString());
            try {
                JSONObject body = data.getJSONObject("body");
                if (SocketClient.this.rtcEventsListener != null) {
                    SocketClient.this.rtcEventsListener.onAnswer(new SessionDescription(SessionDescription.Type.PRANSWER, body.getString("answer")));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    };
    public Emitter.Listener onRtcMute = new Emitter.Listener(){

        public void call(Object ... args) {
            JSONObject data = (JSONObject)args[0];
            Log.d(TAG, "audio:mute:on : " + data.toString());
        }
    };
    public Emitter.Listener onMemberMedia = new Listener(){

        @Override
        public void onData(JSONObject data, String rid) throws Throwable {
            Log.d(TAG, "member:media : " + data.toString());
            String cid = data.getString("cid");
            Conversation conversation = SocketClient.this.socketEventHandler.findConversation(cid);
            if (conversation != null) {
                String memberId = data.getString("from");
                Member member = conversation.getMember(memberId);
                if (member == null) {
                    Log.d(TAG, "Event.fromJson out-of-sync members");
                }
                String eventId = data.getString("id");
                Date timestamp = DateUtil.parseDateFromJson(data, "timestamp");
                boolean audio = false;
                try {
                    JSONObject body = data.getJSONObject("body");
                    audio = body.optBoolean("audio");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                MemberMedia newEvent = new MemberMedia(eventId, member, conversation, audio, timestamp);
                conversation.addEvent(newEvent);
                SocketClient.this.socketEventHandler.onMessageReceived(cid, newEvent);
            } else {
                Log.d(TAG, "onMessageReceived: outOfSync, unknown conversation");
            }
        }
    };
    static JSONObject empty = new JSONObject();
    static JSONObject emptyJson = new JSONObject();

    SocketClient(ConversationClient conversationClient) {
        this.conversationClient = conversationClient;
        this.router = new Router(conversationClient.getContext(), this, conversationClient.getConfig().isFlushPending());
        this.socketEventHandler = new SocketEventHandler(this);
        this.addConnectionListener(new NetworkingStateListener(){

            @Override
            public void onNetworkingState(NetworkState networkingState) {
                if (networkingState == NetworkState.CONNECTED) {
                    SocketClient.this.login();
                }
            }
        });
        this.registerSubscriptions();
    }

    ConversationClient getConversationClient() {
        return this.conversationClient;
    }

    SocketEventHandler getSocketEventHandler() {
        return this.socketEventHandler;
    }

    public User getLoggedInUser() {
        return this.self;
    }

    private void registerSubscriptions() {
        this.router.on(CONVERSATION_MEMBER_JOINED, this.onMemberJoined);
        this.router.on(MEMBER_LEFT, this.onMemberLeft);
        this.router.on(MEMBER_INVITED, this.onMemberInvited);
        this.router.on("event:delete", this.onMessageDeleted);
        this.router.on("text", this.onMessageReceived);
        this.router.on("text:seen", this.onTextSeen);
        this.router.on("text:delivered", this.onTextDelivered);
        this.router.on("image", this.onMessageReceived);
        this.router.on("image:seen", this.onImageSeen);
        this.router.on("image:delivered", this.onImageDelivered);
        this.router.on("text:typing:on", this.onTypeOn);
        this.router.on("text:typing:off", this.onTypeOff);
        this.router.on(RTC_ANSWER, this.onRtcAnswer);
        this.router.on(RTC_MEMBER_MEDIA, this.onMemberMedia);
        this.router.on("audio:mute:on", this.onRtcMute);
        this.router.on("audio:mute:off", this.onRtcMute);
        this.router.on(EVENT_ERROR, this.onEventError);
        for (SessionError error : SessionError.values()) {
            this.router.on(error.getEventName(), this.sessionError);
        }
    }

    NetworkState getConnectionStatus() {
        return this.router.getConnectionStatus();
    }

    void connect(RequestHandler<User> loginListener) throws URISyntaxException {
        this.loginListener = loginListener;
        ConversationClient.ConversationClientConfig clientConfig = this.conversationClient.getConfig();
        String connectionUrl = clientConfig.getEnvironmentHost();
        String path = clientConfig.getEndpointPath();
        Log.d(TAG, "Connect to " + connectionUrl);
        this.router.connect(connectionUrl, path, clientConfig.autoReconnect);
    }

    private void login() {
        String deviceId = DeviceProperties.getUserid(this.conversationClient.getConfig().getContext());
        LoginRequest loginRequest = new LoginRequest(this.conversationClient.getToken(), deviceId, null);
        this.sendRequest(new InternalResponseHelper<User, User>((Request)loginRequest){

            @Override
            User processParsedResponse(User me) {
                SocketClient.this.self = me;
                Log.d(TAG, "onLogin user " + SocketClient.this.self.toString());
                if (SocketClient.this.loginListener != null) {
                    SocketClient.this.loginListener.onSuccess(SocketClient.this.self);
                    SocketClient.this.loginListener = null;
                }
                SocketClient.this.flushPendingOperations();
                if (!UserPreference.containsUser(SocketClient.this.conversationClient.getContext())) {
                    Log.d(TAG, "Cache: no user found. saving user.");
                    CacheDB.getCacheDBInstance().clearDb();
                    UserPreference.saveUser(SocketClient.this.self, SocketClient.this.conversationClient.getContext());
                } else if (!UserPreference.isLastLoggedInUser(SocketClient.this.self, SocketClient.this.conversationClient.getContext())) {
                    Log.d(TAG, "Cache: other user found. overriding all cache.");
                    CacheDB.getCacheDBInstance().clearDb();
                    UserPreference.saveUser(SocketClient.this.self, SocketClient.this.conversationClient.getContext());
                } else {
                    Log.d(TAG, "Cache: user found");
                }
                SocketClient.this.updateConversationList();
                if (SocketClient.this.loginListener != null) {
                    SocketClient.this.loginListener.onSuccess(SocketClient.this.self);
                    SocketClient.this.loginListener = null;
                }
                return SocketClient.this.self;
            }

            @Override
            public void onError(String errorEventName, JSONObject data, String rid, String cid) {
                Log.e(TAG, "errorEventName: [" + errorEventName + "] data: [" + data + "] rid: [" + rid + "] cid: [" + cid + "]");
                SocketClient.this.loginListener.onError(new NexmoAPIError(rid, errorEventName, cid, data.toString()));
                SocketClient.this.router.shutdown();
            }
        });
    }

    void pushRegister(RequestHandler<Void> pushEnableListener) {
        PushRegisterRequest request = new PushRegisterRequest(this.conversationClient.getPushDeviceToken(), pushEnableListener);
        this.sendRequest(new InternalResponseHelper<Void, Void>((Request)request){

            @Override
            Void processParsedResponse(Void data) {
                return null;
            }
        });
    }

    void pushUnregister(RequestHandler<Void> listener) {
        String deviceId = DeviceProperties.getUserid(this.conversationClient.getContext());
        PushUnregisterRequest request = new PushUnregisterRequest(deviceId, listener);
        this.sendRequest(new InternalResponseHelper<Void, Void>((Request)request){

            @Override
            Void processParsedResponse(Void data) {
                Log.d(TAG, "onPushUnregistered ");
                DeviceProperties.resetUserId(SocketClient.this.conversationClient.getContext());
                return null;
            }
        });
    }

    void pushSubscribeToConversation(PushSubscriptionRequest subscriptionRequest) {
        this.sendRequest(new InternalResponseHelper<Void, Void>((Request)subscriptionRequest){

            @Override
            Void processParsedResponse(Void data) {
                return null;
            }
        });
    }

    void disconnectCleanup() {
        ConversationSignalingChannel signalingChannel;
        this.self = null;
        UserPreference.clearUser(this.conversationClient.getContext());
        CacheDB cacheDB = CacheDB.getCacheDBInstance();
        if (cacheDB != null) {
            cacheDB.clearDb();
            cacheDB.closeDatabase();
        }
        if ((signalingChannel = this.getConversationClient().getSignallingChannel()).isAudioEnabled()) {
            signalingChannel.disableAudio();
        }
        signalingChannel.updateSyncState(SynchronisingState.STATE.OUT_OF_SYNC);
        for (Conversation conversation : this.socketEventHandler.getConversationList()) {
            conversation.recycleEventBitmaps();
        }
        this.socketEventHandler.getConversationList().clear();
    }

    void logout(final RequestHandler logoutListener) {
        this.conversationClient.getEventNotifier().removeAllListeners();
        this.getConversationClient().getSignallingChannel().disableAudio();
        this.pushUnregister(new RequestHandler<Void>(){

            @Override
            public void onError(NexmoAPIError apiError) {
                SocketClient.this.sendLogoutRequest(logoutListener);
            }

            @Override
            public void onSuccess(Void result) {
                SocketClient.this.sendLogoutRequest(logoutListener);
            }
        });
    }

    private void sendLogoutRequest(final RequestHandler logoutListener) {
        this.sendRequest(new AsyncInternalResponseHelper<Void, User>((Request)new LogoutRequest()){
            NetworkingStateListener disconnectedStateListener;
            {
                super(requestParser);
                this.disconnectedStateListener = new NetworkingStateListener(){

                    @Override
                    public void onNetworkingState(NetworkState networkingState) {
                        User logedOutUser = new User(SocketClient.this.self);
                        SocketClient.this.disconnectCleanup();
                        logoutListener.onSuccess(logedOutUser);
                    }
                };
            }

            @Override
            void processParsedResponseAsync(Void data, ResultListener<User> callback) {
                Log.d(TAG, "Logout success");
                SocketClient.this.addOnceConnectionListener(NetworkState.DISCONNECTED, this.disconnectedStateListener);
                SocketClient.this.router.shutdown();
            }
        });
    }

    void newConversation(final CreateConversationRequest request) {
        this.sendRequest(new InternalResponseHelper<String, Conversation>((Request)request){

            @Override
            Conversation processParsedResponse(String conversationId) {
                Conversation conversation = new Conversation(request.displayName, conversationId);
                conversation.setConversationSignalingChannel(SocketClient.this.conversationClient.getSignallingChannel());
                conversation.setSocketEventNotifier(SocketClient.this.conversationClient.getEventNotifier());
                SocketClient.this.socketEventHandler.onConversationCreated(conversation);
                return conversation;
            }
        });
    }

    void newConversationHelper(final CreateConversationRequest request) {
        this.sendRequest(new AsyncInternalResponseHelper<String, Conversation>((Request)request){

            @Override
            void processParsedResponseAsync(String conversationId, ResultListener<Conversation> callback) {
                Conversation conversation = new Conversation(request.displayName, conversationId);
                conversation.setConversationSignalingChannel(SocketClient.this.conversationClient.getSignallingChannel());
                conversation.setSocketEventNotifier(SocketClient.this.conversationClient.getEventNotifier());
                SocketClient.this.socketEventHandler.addNewConversationToMemory(conversation);
                JoinRequest joinRequestNoHandler = JoinRequest.createJoinRequestWithUsername(conversationId, request.displayName, null, SocketClient.this.self.getName());
                SocketClient.this.joinNewConversationHelper(joinRequestNoHandler, conversation, request);
            }
        });
    }

    void joinNewConversationHelper(JoinRequest joinRequest, final Conversation conversation, final CreateConversationRequest newConversationRequest) {
        this.sendRequest(new AsyncInternalResponseHelper<Member, Member>((Request)joinRequest){

            @Override
            void processParsedResponseAsync(Member member, ResultListener<Member> callback) {
                if (SocketClient.this.isMemberSelf(member)) {
                    member.setName(SocketClient.this.getConversationClient().getUser().getName());
                }
                SocketClient.this.socketEventHandler.onNewConversationHelperSuccessCreated(conversation, newConversationRequest, member);
            }
        });
    }

    void createCall(final InviteWithAudioRequest request) {
        this.sendRequest(new InternalResponseHelper<InviteRequest.InviteContainer, Member>((Request)request){

            @Override
            Member processParsedResponse(InviteRequest.InviteContainer result) {
                Log.d(TAG, "conversation:invite with audio success " + result.toString());
                return SocketClient.this.socketEventHandler.onInvitationSent(result.userId, result.memberId, result.timestampInvited, request);
            }
        });
    }

    void rtcNew(final RtcNewRequest request) {
        this.sendRequest(new InternalResponseHelper<RtcNewRequest.RtcNewResponse, String>((Request)request){

            @Override
            String processParsedResponse(RtcNewRequest.RtcNewResponse result) {
                System.out.println(TAG + " rtc:new:success " + result);
                return SocketClient.this.socketEventHandler.onRtcNew(request, result);
            }
        });
    }

    void rtcTerminate(RtcTerminateRequest rtcTerminateRequest) {
        this.sendRequest(new InternalResponseHelper<Void, String>((Request)rtcTerminateRequest){

            @Override
            String processParsedResponse(Void result) {
                System.out.println(TAG + " rtc:terminate:success " + result);
                return null;
            }
        });
    }

    void rtcMute(AudioMuteRequest muteRequest) {
        this.sendRequest(new InternalResponseHelper<Void, String>((Request)muteRequest){

            @Override
            String processParsedResponse(Void result) {
                System.out.println(TAG + " audio:mute: " + result);
                return null;
            }
        });
    }

    void rtcEarmuff(AudioEarmuffRequest earmuffRequest) {
        this.sendRequest(new InternalResponseHelper<Void, String>((Request)earmuffRequest){

            @Override
            String processParsedResponse(Void result) {
                System.out.println(TAG + " audio:earmuff: " + result);
                return null;
            }
        });
    }

    void audioRinging(AudioRingingRequest audioRingingRequest) {
        this.sendRequest(new InternalResponseHelper<Void, String>((Request)audioRingingRequest){

            @Override
            String processParsedResponse(Void result) {
                return null;
            }
        });
    }

    void joinConversation(final JoinRequest joinRequest) {
        this.sendRequest(new InternalResponseHelper<Member, Member>((Request)joinRequest){

            @Override
            Member processParsedResponse(Member member) {
                if (SocketClient.this.isMemberSelf(member)) {
                    member.setName(SocketClient.this.getConversationClient().getUser().getName());
                }
                SocketClient.this.socketEventHandler.onJoin(member, joinRequest);
                return member;
            }
        });
    }

    void leaveConversation(final LeaveRequest leaveRequest) {
        this.sendRequest(new InternalResponseHelper<LeaveRequest.TimestampsContainer, Void>((Request)leaveRequest){

            @Override
            Void processParsedResponse(LeaveRequest.TimestampsContainer data) {
                Conversation pendingConversation = SocketClient.this.conversationClient.getConversation(leaveRequest.cid);
                Member member = pendingConversation.getMember(leaveRequest.member.getMemberId());
                if (member != null) {
                    member.updateState(Member.STATE.LEFT, data.leftTimestamp);
                }
                pendingConversation.recycleEventBitmaps();
                return null;
            }
        });
    }

    void invite(final InviteRequest inviteRequest) {
        this.sendRequest(new InternalResponseHelper<InviteRequest.InviteContainer, Member>((Request)inviteRequest){

            @Override
            Member processParsedResponse(InviteRequest.InviteContainer result) {
                Log.d(TAG, "onInviteSent " + result.toString());
                return SocketClient.this.socketEventHandler.onInvitationSent(result.userId, result.memberId, result.timestampInvited, inviteRequest);
            }
        });
    }

    void getConversation(final GetConversationRequest getRequest) {
        this.sendRequest(new InternalResponseHelper<GetConversationRequest.Container, Conversation>((Request)getRequest){

            @Override
            Conversation processParsedResponse(GetConversationRequest.Container result) {
                Log.d(TAG, "onConversationUpdated ");
                Conversation conversation = result.conversation;
                for (Member member : result.members) {
                    member.setConversation(conversation);
                    if (member.getUserId().equals(SocketClient.this.self.getUserId())) {
                        conversation.setSelf(member);
                        continue;
                    }
                    conversation.addMember(member);
                }
                Log.d(TAG, "onGet get members size: " + conversation.getMembers().size() + " :" + conversation.getMembers().toString());
                conversation.setConversationSignalingChannel(SocketClient.this.conversationClient.getSignallingChannel());
                conversation.setSocketEventNotifier(SocketClient.this.conversationClient.getEventNotifier());
                return SocketClient.this.socketEventHandler.onConversation(conversation, getRequest);
            }
        });
    }

    void updateConversationList() {
        GetConversationsRequest request = new GetConversationsRequest(this.conversationClient.getUser());
        this.sendRequest(new InternalResponseHelper<List<GetConversationsRequest.Container>, List<Conversation>>((Request)request){

            @Override
            List<Conversation> processParsedResponse(List<GetConversationsRequest.Container> result) {
                ArrayList<Conversation> conversations = new ArrayList<Conversation>(result.size());
                for (GetConversationsRequest.Container container : result) {
                    container.conversation.setSelf(container.member);
                    conversations.add(container.conversation);
                }
                SocketClient.this.socketEventHandler.onConversations(conversations);
                return conversations;
            }
        });
    }

    void flushPendingOperations() {
        Router.FlushFinishedListener readyToCallUserCallback = new Router.FlushFinishedListener(){

            @Override
            public void onFlushFinished() {
                SocketClient.this.retryPendingOperations();
            }
        };
        if (this.conversationClient.getConfig().isFlushPending()) {
            Log.d(TAG, "Login succeed and flushPending is enabled - trying to flush");
            this.router.loadAndRemoveAndFlush(this.router, readyToCallUserCallback);
        } else {
            readyToCallUserCallback.onFlushFinished();
        }
    }

    void sendReceiptRecord(final SeenReceiptRequest receiptRequest) {
        this.sendRequest(new InternalResponseHelper<SeenReceiptRequest.Container, SeenReceipt>((Request)receiptRequest){

            @Override
            SeenReceipt processParsedResponse(SeenReceiptRequest.Container result) {
                Log.d(TAG, "SeenReceiptRequest success");
                return new SeenReceipt(receiptRequest.event, receiptRequest.member, result.timestamp);
            }
        });
    }

    void sendReceiptRecord(DeliveredReceiptRequest receiptRequest) {
        this.sendRequest(new InternalResponseHelper<Void, Void>((Request)receiptRequest){

            @Override
            Void processParsedResponse(Void data) {
                return null;
            }
        });
    }

    void sendTypingIndicator(final TypingIndicatorRequest request) {
        this.sendRequest(new InternalResponseHelper<Void, Member.TYPING_INDICATOR>((Request)request){

            @Override
            Member.TYPING_INDICATOR processParsedResponse(Void data) {
                Log.d(TAG, "onTypeSuccess ");
                return SocketClient.this.socketEventHandler.onTyping(request.typingIndicator, request);
            }
        });
    }

    void deleteEvent(final DeleteEventRequest request) {
        this.sendRequest(new InternalResponseHelper<Void, Void>((Request)request){

            @Override
            Void processParsedResponse(Void data) {
                Log.d(TAG, "onEventDeletedSuccess eventId: " + request.messageId);
                return null;
            }
        });
    }

    void sendText(final SendTextMessageRequest sendMessageRequest) {
        this.sendRequest(new InternalResponseHelper<SendTextMessageRequest.Container, Text>((Request)sendMessageRequest){

            @Override
            Text processParsedResponse(SendTextMessageRequest.Container container) {
                Log.d(TAG, "onTextSent ");
                return SocketClient.this.socketEventHandler.onTextSent(container.messageId, container.timestamp, sendMessageRequest);
            }
        });
    }

    void sendImage(final SendImageMessageRequest sendImageRequest) {
        this.sendRequest(new InternalResponseHelper<SendTextMessageRequest.Container, Image>((Request)sendImageRequest){

            @Override
            Image processParsedResponse(SendTextMessageRequest.Container container) {
                return SocketClient.this.socketEventHandler.onImageSent(container.messageId, container.timestamp, sendImageRequest);
            }
        });
    }

    void getUser(GetUserInfoRequest userRequest) {
        this.sendRequest(new InternalResponseHelper<User, User>((Request)userRequest){

            @Override
            User processParsedResponse(User user) {
                Log.d(TAG, "onUserInfo: " + user);
                return user;
            }
        });
    }

    void getEvents(final GetEventsRequest getRequest) {
        this.sendRequest(new InternalResponseHelper<List<Event>, Conversation>((Request)getRequest){

            @Override
            Conversation processParsedResponse(List<Event> events) {
                Log.d(TAG, "onConversationEvents " + events);
                return SocketClient.this.socketEventHandler.onEventsHistory(events, getRequest);
            }
        });
    }

    private boolean isMemberSelf(Member member) {
        return TextUtils.equals((CharSequence)this.getConversationClient().getUser().getUserId(), (CharSequence)member.getUserId());
    }

    public void setRtcEventsListener(RtcEvents rtcEventsListener) {
        this.rtcEventsListener = rtcEventsListener;
    }

    public void addOnceConnectionListener(final NetworkState expectedState, final NetworkingStateListener listener) {
        this.networkingStateListeners.add(new NetworkingStateListener(){

            @Override
            public void onNetworkingState(NetworkState newState) {
                if (expectedState != newState) {
                    return;
                }
                SocketClient.this.removeConnectionListener(this);
                listener.onNetworkingState(newState);
            }
        });
    }

    public void addConnectionListener(NetworkingStateListener listener) {
        this.networkingStateListeners.add(listener);
    }

    public void removeConnectionListener(NetworkingStateListener listener) {
        this.networkingStateListeners.remove(listener);
    }

    public void removeAllConnectionListeners() {
        this.networkingStateListeners.clear();
    }

    void explicitDisconnect() {
        this.getConversationClient().getSignallingChannel().disableAudio();
        this.router.updateConnectionStatus(NetworkState.DISCONNECTED);
        this.onNetworkingState(NetworkState.DISCONNECTED);
        this.router.shutdown();
        this.disconnectCleanup();
        Log.d(TAG, "Explicitly Disconnected: Connection state: " + this.router.getConnectionStatus().toString());
    }

    @Override
    public void onNetworkingState(final NetworkState networkingState) {
        for (final NetworkingStateListener networkingStateListener : new ArrayList<NetworkingStateListener>(this.networkingStateListeners)) {
            this.conversationClient.callUserCallback(new Runnable(){

                @Override
                public void run() {
                    networkingStateListener.onNetworkingState(networkingState);
                }
            });
        }
    }

    private <R, U> void sendRequest(CAPIRequest<R, U> requestProcessor) {
        this.router.sendRequest(requestProcessor.requestResponseHandler, requestProcessor);
    }

    private void retryPendingOperations() {
        Map<String, CAPIInternalRequest> ongoingRequests = this.router.getPendingRequests();
        Log.d(TAG, "retryPendingOperations. of size: " + ongoingRequests.size());
        for (Map.Entry<String, CAPIInternalRequest> entry : ongoingRequests.entrySet()) {
            Request request = entry.getValue().getRequest();
            switch (request.type) {
                case CREATE: {
                    this.newConversation((CreateConversationRequest)request);
                    break;
                }
                case JOIN: {
                    this.joinConversation((JoinRequest)request);
                    break;
                }
                case INVITE: {
                    this.invite((InviteRequest)request);
                    break;
                }
                case LEAVE: {
                    this.leaveConversation((LeaveRequest)request);
                    break;
                }
                case SEND_TEXT: {
                    this.sendText((SendTextMessageRequest)request);
                    break;
                }
                case SEND_IMAGE: {
                    this.sendImage((SendImageMessageRequest)request);
                    break;
                }
                case DELETE_EVENT: {
                    this.deleteEvent((DeleteEventRequest)request);
                }
            }
        }
    }

    private abstract class CAPIRequest<R, U>
    implements CAPIAwareListener {
        protected Request<RequestHandler<U>, R> requestResponseHandler;

        CAPIRequest(Request<RequestHandler<U>, R> requestParser) {
            this.requestResponseHandler = requestParser;
        }

        @Override
        public final void onRawUnprocessResponseData(JSONObject data, String rid, String cid) throws JSONException {
            JSONObject body = data.optJSONObject("body");
            this.onParsedResponseData(this.requestResponseHandler.parse(data, body != null ? body : empty));
        }

        @Override
        public void onError(String errorEventName, JSONObject data, String rid, String cid) {
            Log.w(TAG, String.format("Caught error %s for request %s: %s", errorEventName, this.requestResponseHandler.getRequestName(), data));
            Object listener = this.requestResponseHandler.listener;
            if (listener == null) {
                return;
            }
            this.errorOnRightThread(new NexmoAPIError(rid, errorEventName, cid, data.toString()));
        }

        abstract void onParsedResponseData(R var1);

        protected void applyOnRightThread(final U data) {
            if (this.requestResponseHandler.getListener() == null) {
                return;
            }
            if (((SocketClient)SocketClient.this).conversationClient.handlerForCallbacks == null) {
                this.requestResponseHandler.getListener().onSuccess(data);
                return;
            }
            ((SocketClient)SocketClient.this).conversationClient.handlerForCallbacks.post(new Runnable(){

                @Override
                public void run() {
                    CAPIRequest.this.requestResponseHandler.getListener().onSuccess(data);
                }
            });
        }

        protected void errorOnRightThread(final NexmoAPIError errorDetails) {
            if (this.requestResponseHandler.getListener() == null) {
                return;
            }
            if (((SocketClient)SocketClient.this).conversationClient.handlerForCallbacks == null) {
                NexmoAPIError.forward(this.requestResponseHandler.getListener(), errorDetails);
                return;
            }
            ((SocketClient)SocketClient.this).conversationClient.handlerForCallbacks.post(new Runnable(){

                @Override
                public void run() {
                    NexmoAPIError.forward(CAPIRequest.this.requestResponseHandler.getListener(), errorDetails);
                }
            });
        }
    }

    private abstract class AsyncInternalResponseHelper<R, U>
    extends CAPIRequest<R, U> {
        AsyncInternalResponseHelper(Request<RequestHandler<U>, R> requestParser) {
            super(requestParser);
        }

        @Override
        final void onParsedResponseData(R result) {
            this.processParsedResponseAsync(result, new ResultListener<U>(){

                @Override
                public void onSuccess(U result) {
                    if (AsyncInternalResponseHelper.this.requestResponseHandler.getListener() == null) {
                        return;
                    }
                    AsyncInternalResponseHelper.this.applyOnRightThread(result);
                }
            });
        }

        abstract void processParsedResponseAsync(R var1, ResultListener<U> var2);
    }

    private abstract class InternalResponseHelper<R, U>
    extends CAPIRequest<R, U> {
        InternalResponseHelper(Request<RequestHandler<U>, R> requestParser) {
            super(requestParser);
        }

        @Override
        final void onParsedResponseData(R result) {
            U data = this.processParsedResponse(result);
            if (this.requestResponseHandler.getListener() == null) {
                return;
            }
            this.applyOnRightThread(data);
        }

        abstract U processParsedResponse(R var1);
    }

    abstract class Listener
    implements Emitter.Listener {
        Listener() {
        }

        public abstract void onData(JSONObject var1, String var2) throws Throwable;

        public void onError(Throwable throwable) {
        }

        public final void call(Object ... args) {
            String rid = "";
            String cid = "";
            try {
                JSONObject jsonObject = (JSONObject)args[0];
                rid = jsonObject.optString("rid", "");
                cid = jsonObject.optString("cid", "");
                this.onData(jsonObject, rid);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

