/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.support.annotation.Nullable;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.DeliveredReceipt;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.SocketEventHandler;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiptRecordUtil {
    private static final String TAG = ReceiptRecordUtil.class.getSimpleName();

    public static JSONObject seenReceiptsToJson(Event event) throws JSONException {
        JSONObject stateObject = new JSONObject();
        JSONObject seenObject = new JSONObject();
        for (SeenReceipt receipt : event.getSeenReceipts()) {
            seenObject.put(receipt.getMember().getMemberId(), (Object)DateUtil.formatIso8601DateString(receipt.getTimestamp()));
        }
        stateObject.put("seen_by", (Object)seenObject);
        return stateObject;
    }

    public static JSONObject deliveredReceiptsToJson(Event event) throws JSONException {
        JSONObject stateObject = new JSONObject();
        JSONObject deliveredObject = new JSONObject();
        for (DeliveredReceipt receipt : event.getDeliveredReceipts()) {
            deliveredObject.put(receipt.getMember().getMemberId(), (Object)DateUtil.formatIso8601DateString(receipt.getTimestamp()));
        }
        stateObject.put("delivered_to", (Object)deliveredObject);
        return stateObject;
    }

    static List<DeliveredReceipt> parseDeliveryReceiptHistory(Conversation conversation, String eventId, JSONObject stateJson) {
        ArrayList<DeliveredReceipt> deliveredReceiptList = new ArrayList<DeliveredReceipt>();
        try {
            if (stateJson.has("delivered_to") && stateJson.get("delivered_to") instanceof JSONObject) {
                JSONObject deliveredTo = stateJson.getJSONObject("delivered_to");
                Iterator keys = deliveredTo.keys();
                while (keys.hasNext()) {
                    String keyValue = (String)keys.next();
                    String valueString = deliveredTo.getString(keyValue);
                    Date timestamp = DateUtil.formatIso8601DateString(valueString);
                    Event event = conversation.findEvent(eventId);
                    Member deliveredToMember = conversation.getMember(keyValue);
                    if (event == null || deliveredToMember == null) continue;
                    deliveredReceiptList.add(new DeliveredReceipt(event, deliveredToMember, timestamp));
                }
            }
        }
        catch (ParseException | JSONException e) {
            e.printStackTrace();
        }
        return deliveredReceiptList;
    }

    static List<SeenReceipt> parseSeenReceiptHistory(Conversation conversation, String eventId, JSONObject stateJson) {
        ArrayList<SeenReceipt> seenReceiptList = new ArrayList<SeenReceipt>();
        try {
            if (stateJson.has("seen_by") && stateJson.get("seen_by") instanceof JSONObject) {
                JSONObject seenBy = stateJson.getJSONObject("seen_by");
                Iterator keys = seenBy.keys();
                while (keys.hasNext()) {
                    String keyValue = (String)keys.next();
                    String valueString = seenBy.getString(keyValue);
                    Date timestamp = DateUtil.formatIso8601DateString(valueString);
                    Event event = conversation.findEvent(eventId);
                    Member seenByMember = conversation.getMember(keyValue);
                    if (event == null || seenByMember == null) continue;
                    seenReceiptList.add(new SeenReceipt(event, seenByMember, timestamp));
                }
            }
        }
        catch (ParseException | JSONException e) {
            e.printStackTrace();
        }
        return seenReceiptList;
    }

    static void parseSeenReceipt(JSONObject data, SocketEventHandler socketEventHandler) throws JSONException {
        String cid = data.getString("cid");
        String memberId = data.getString("from");
        Date timestamp = null;
        try {
            timestamp = DateUtil.formatIso8601DateString(data.getString("timestamp"));
        }
        catch (ParseException e) {
            Log.d(TAG, "parseSeenReceipt: wrong date format");
        }
        socketEventHandler.onEventSeen(cid, memberId, ReceiptRecordUtil.getEventId(data), timestamp);
    }

    static void parseDeliveredReceipt(JSONObject data, SocketEventHandler socketEventHandler) throws JSONException {
        String cid = data.getString("cid");
        String memberId = data.getString("from");
        Date timestamp = null;
        try {
            timestamp = DateUtil.formatIso8601DateString(data.getString("timestamp"));
        }
        catch (ParseException e) {
            Log.d(TAG, "parseDeliveredReceipt: wrong date format");
        }
        socketEventHandler.onEventDelivered(cid, memberId, ReceiptRecordUtil.getEventId(data), timestamp);
    }

    @Nullable
    private static String getEventId(JSONObject rootObject) throws JSONException {
        JSONObject body = rootObject.getJSONObject("body");
        String eventId = body.optString("event_id", null);
        if (eventId == null) {
            eventId = body.optString("message_id", null);
        }
        return eventId;
    }
}

