/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.os.Parcel;
import android.os.Parcelable;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.client.event.EventType;
import java.io.Serializable;
import java.util.Date;

public class ReceiptRecord
implements Parcelable {
    private static final String TAG = ReceiptRecord.class.getSimpleName();
    private Date timestamp;
    private Event event;
    private Member member;
    public static final Parcelable.Creator<ReceiptRecord> CREATOR = new Parcelable.Creator<ReceiptRecord>(){

        public ReceiptRecord createFromParcel(Parcel in) {
            return new ReceiptRecord(in);
        }

        public ReceiptRecord[] newArray(int size) {
            return new ReceiptRecord[size];
        }
    };

    protected ReceiptRecord(Event event, Member member, Date timestamp) {
        this.event = event;
        this.member = member;
        this.timestamp = timestamp;
    }

    public Member getMember() {
        return this.member;
    }

    public Event getEvent() {
        return this.event;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    protected void setMember(Member member) {
        this.member = member;
    }

    protected void setEvent(Event event) {
        this.event = event;
    }

    protected ReceiptRecord(Parcel in) {
        this.member = new Member(in.readString());
        String eventId = in.readString();
        EventType eventType = EventType.values()[in.readInt()];
        this.event = eventType == EventType.TEXT ? new Text(eventId) : new Image(eventId);
        this.timestamp = (Date)in.readSerializable();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getMember().getMemberId());
        dest.writeString(this.getEvent().getId());
        dest.writeInt(this.getEvent().getType().ordinal());
        dest.writeSerializable((Serializable)this.timestamp);
    }

    public String toString() {
        return TAG + ".event : " + (this.event != null ? this.event.toString() : "") + ".member: " + (this.member != null ? this.member.toString() : "") + ".timestamp: " + (this.timestamp != null ? this.timestamp : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiptRecord that = (ReceiptRecord)o;
        if ((this.timestamp != null ? !this.timestamp.equals(that.timestamp) : that.timestamp != null) && (this.getEvent() != null ? !this.getEvent().equals(that.getEvent()) : that.getEvent() != null)) {
            return false;
        }
        return !(this.getMember() != null ? !this.getMember().equals(that.getMember()) : that.getMember() != null);
    }

    public int hashCode() {
        int result = this.timestamp != null ? this.timestamp.hashCode() : 0;
        result = 31 * result + (this.event.getId() != null ? this.event.getId().hashCode() : 0);
        result = 31 * result + (this.member != null ? this.member.getMemberId().hashCode() : 0);
        return result;
    }
}

