/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.event.EventType;
import java.util.Date;

public class MemberMedia
extends Event {
    private static final String TAG = MemberMedia.class.getSimpleName();
    private boolean audioEnabled = false;
    public static final Parcelable.Creator<MemberMedia> CREATOR = new Parcelable.Creator<MemberMedia>(){

        public MemberMedia createFromParcel(Parcel in) {
            return new MemberMedia(in);
        }

        public MemberMedia[] newArray(int size) {
            return new MemberMedia[size];
        }
    };

    @VisibleForTesting(otherwise=4)
    protected MemberMedia(Member member, boolean audioEnabled, Date timestamp) {
        this.member = member;
        this.audioEnabled = audioEnabled;
        this.timestamp = timestamp;
    }

    @VisibleForTesting(otherwise=4)
    protected MemberMedia(String eventId, Member member, Conversation conversation, boolean audioEnabled, Date timestamp) {
        this(member, audioEnabled, timestamp);
        this.conversation = conversation;
        this.id = eventId;
    }

    @VisibleForTesting(otherwise=4)
    protected MemberMedia(Parcel in) {
        super(in);
        this.audioEnabled = in.readInt() != 0;
    }

    public boolean isAudioEnabled() {
        return this.audioEnabled;
    }

    @Override
    public EventType getType() {
        return EventType.MEMBER_MEDIA;
    }

    public String toString() {
        return TAG + " member: " + (this.member != null ? this.member.toString() : "") + " .id: " + (this.id != null ? this.id : "") + " .timestamp: " + (this.timestamp != null ? this.timestamp.toString() : "") + " .audioEnabled:" + this.audioEnabled;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.audioEnabled ? 1 : 0);
    }
}

