/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Member
implements Parcelable {
    private static final String TAG = Member.class.getSimpleName();
    private String memberId;
    private String userId;
    private String name;
    private STATE state = STATE.UNKNOWN;
    private TYPING_INDICATOR typingIndicator = TYPING_INDICATOR.OFF;
    private Date joinedAt;
    private Date invitedAt;
    private Date leftAt;
    private Conversation conversation;
    public static final Parcelable.Creator<Member> CREATOR = new Parcelable.Creator<Member>(){

        public Member createFromParcel(Parcel in) {
            return new Member(in);
        }

        public Member[] newArray(int size) {
            return new Member[size];
        }
    };

    @VisibleForTesting(otherwise=4)
    protected Member(String memberId) {
        this.memberId = memberId;
    }

    @VisibleForTesting(otherwise=4)
    protected Member(String memberId, Conversation conversation) {
        this(memberId);
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Member(String userId, String name, String memberId) {
        this(memberId);
        this.userId = userId;
        this.name = name;
    }

    @VisibleForTesting(otherwise=4)
    protected Member(String userId, String name, String memberId, STATE state) {
        this(userId, name, memberId);
        this.state = state;
    }

    @VisibleForTesting(otherwise=4)
    protected Member(String userId, String name, String memberId, Date joinedAt, Date invitedAt, Date leftAt, STATE state) {
        this(userId, name, memberId, state);
        this.invitedAt = invitedAt;
        this.joinedAt = joinedAt;
        this.leftAt = leftAt;
    }

    protected Member(User user) {
        this.userId = user.getUserId();
        this.name = user.getName();
    }

    protected Member(Member member) {
        this(member.getUserId(), member.getName(), member.getMemberId(), member.getJoinedAt(), member.getInvitedAt(), member.getLeftAt(), member.getState());
        this.typingIndicator = member.getTypingIndicator();
    }

    protected Member(Parcel in) {
        this.userId = in.readString();
        this.name = in.readString();
        this.memberId = in.readString();
        this.state = STATE.values()[in.readInt()];
        this.joinedAt = (Date)in.readSerializable();
        this.leftAt = (Date)in.readSerializable();
        this.invitedAt = (Date)in.readSerializable();
        this.typingIndicator = in.readInt() == 1 ? TYPING_INDICATOR.ON : TYPING_INDICATOR.OFF;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public STATE getState() {
        return this.state;
    }

    public TYPING_INDICATOR getTypingIndicator() {
        return this.typingIndicator;
    }

    public Date getJoinedAt() {
        return this.joinedAt;
    }

    public Date getInvitedAt() {
        return this.invitedAt;
    }

    public Date getLeftAt() {
        return this.leftAt;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public void kick(RequestHandler<Void> leaveListener) {
        if (leaveListener == null) {
            Log.e(TAG, "Leave Listener is mandatory in order to kick a member from a conversation");
        } else if (this.conversation == null) {
            leaveListener.onError(new NexmoAPIError("missing-params", "The conversation cannot be NULL"));
        } else if (this.conversation.getSignallingChannel().getLoggedInUser() == null) {
            leaveListener.onError(NexmoAPIError.noUserLoggedIn());
        } else {
            this.conversation.getSignallingChannel().leaveConversation(this.conversation, this, leaveListener);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.userId);
        dest.writeString(this.name);
        dest.writeString(this.memberId);
        dest.writeInt(this.state.ordinal());
        dest.writeSerializable((Serializable)this.joinedAt);
        dest.writeSerializable((Serializable)this.leftAt);
        dest.writeSerializable((Serializable)this.invitedAt);
        dest.writeInt(this.typingIndicator == TYPING_INDICATOR.ON ? 1 : 0);
    }

    public String toString() {
        return TAG + " name: " + (this.name != null ? this.name : "") + " .userId: " + (this.userId != null ? this.userId : "") + " .memberId: " + (this.memberId != null ? this.memberId : "") + " .state: " + this.state.getId() + " .typing: " + (this.typingIndicator != null ? this.typingIndicator.toString() : "") + " .invitedAt: " + (this.invitedAt != null ? this.invitedAt.toString() : "") + " .joinedAt: " + (this.joinedAt != null ? this.joinedAt.toString() : "") + " .leftAt: " + (this.leftAt != null ? this.leftAt.toString() : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Member)) {
            return false;
        }
        Member member = (Member)o;
        if (this.memberId != null ? !this.memberId.equals(member.memberId) : member.memberId != null) {
            return false;
        }
        if (this.userId != null ? !this.userId.equals(member.userId) : member.userId != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(member.name) : member.name != null) {
            return false;
        }
        if (this.state != member.state) {
            return false;
        }
        if (this.joinedAt != null ? !this.joinedAt.equals(member.joinedAt) : member.joinedAt != null) {
            return false;
        }
        if (this.invitedAt != null ? !this.invitedAt.equals(member.invitedAt) : member.invitedAt != null) {
            return false;
        }
        return this.leftAt != null ? this.leftAt.equals(member.leftAt) : member.leftAt == null;
    }

    public int hashCode() {
        int result = this.memberId != null ? this.memberId.hashCode() : 0;
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + (this.joinedAt != null ? this.joinedAt.hashCode() : 0);
        result = 31 * result + (this.invitedAt != null ? this.invitedAt.hashCode() : 0);
        result = 31 * result + (this.leftAt != null ? this.leftAt.hashCode() : 0);
        return result;
    }

    public static Member fromCursor(Cursor cursor) {
        if (cursor == null) {
            return null;
        }
        Date dateInvited = null;
        Date dateLeft = null;
        Date dateJoined = null;
        try {
            dateInvited = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("invited_at")));
            dateLeft = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("left_at")));
            dateJoined = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("joined_at")));
        }
        catch (ParseException e) {
            Log.d(TAG, "Member: wrong date format");
        }
        return new Member(cursor.getString(cursor.getColumnIndex("user_id")), cursor.getString(cursor.getColumnIndex("username")), cursor.getString(cursor.getColumnIndex("id")), dateJoined, dateInvited, dateLeft, STATE.valueOf(cursor.getString(cursor.getColumnIndex("state"))));
    }

    public static Member fromJson(JSONObject memberJSON) throws JSONException {
        Date joinedTimestamp = null;
        Date leftTimestamp = null;
        Date invitedTimestamp = null;
        JSONObject timestampJson = memberJSON.optJSONObject("timestamp");
        if (timestampJson != null) {
            if (timestampJson.has("joined")) {
                joinedTimestamp = DateUtil.parseDateFromJson(timestampJson, "joined");
            }
            if (timestampJson.has("left")) {
                leftTimestamp = DateUtil.parseDateFromJson(timestampJson, "left");
            }
            if (timestampJson.has("invited")) {
                invitedTimestamp = DateUtil.parseDateFromJson(timestampJson, "invited");
            }
        }
        Member member = new Member(memberJSON.getString("user_id"), memberJSON.optString("name"), memberJSON.getString("member_id"), joinedTimestamp, invitedTimestamp, leftTimestamp, STATE.fromId(memberJSON.getString("state")));
        return member;
    }

    void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    synchronized void setTypingIndicator(TYPING_INDICATOR typingIndicator) {
        this.typingIndicator = typingIndicator;
    }

    synchronized void updateState(STATE state, Date date) {
        switch (state) {
            case INVITED: {
                this.setState(STATE.INVITED);
                this.invitedAt = date;
                break;
            }
            case JOINED: {
                this.setState(STATE.JOINED);
                this.joinedAt = date;
                break;
            }
            case LEFT: {
                this.setState(STATE.LEFT);
                this.leftAt = date;
            }
        }
    }

    private void setState(STATE state) {
        this.state = state;
    }

    public static enum STATE {
        JOINED("JOINED"),
        INVITED("INVITED"),
        LEFT("LEFT"),
        UNKNOWN("");

        private String id;

        private STATE(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static STATE fromId(String id) {
            for (STATE state : STATE.values()) {
                if (!id.equals(state.getId())) continue;
                return state;
            }
            return UNKNOWN;
        }
    }

    public static enum TYPING_INDICATOR {
        ON,
        OFF;

    }
}

