/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

public class ImageRepresentation
implements Parcelable {
    private static final String TAG = ImageRepresentation.class.getSimpleName();
    public TYPE type;
    private String id;
    private String url;
    private long size;
    private Bitmap bitmap;
    private String localFilePath;
    public static final Parcelable.Creator<ImageRepresentation> CREATOR = new Parcelable.Creator<ImageRepresentation>(){

        public ImageRepresentation createFromParcel(Parcel in) {
            return new ImageRepresentation(in);
        }

        public ImageRepresentation[] newArray(int size) {
            return new ImageRepresentation[size];
        }
    };

    @VisibleForTesting(otherwise=4)
    protected ImageRepresentation(TYPE type, String id, String url, long size, String localFilePath) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.size = size;
        this.localFilePath = localFilePath;
    }

    protected ImageRepresentation(Parcel in) {
        this.type = TYPE.valueOf(in.readString());
        this.id = in.readString();
        this.url = in.readString();
        this.size = in.readLong();
        this.localFilePath = in.readString();
    }

    public String getUrl() {
        return this.url;
    }

    public long getSize() {
        return this.size;
    }

    public String getId() {
        return this.id;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    boolean localFileExists() {
        if (TextUtils.isEmpty((CharSequence)this.localFilePath)) {
            return false;
        }
        File file = new File(this.localFilePath);
        return file.exists();
    }

    void updateLocalFilePath(String localFilePath) {
        this.localFilePath = localFilePath;
    }

    void updateUrl(String url) {
        this.url = url;
    }

    void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type.toString());
        dest.writeString(this.id);
        dest.writeString(this.url);
        dest.writeLong(this.size);
        dest.writeString(this.localFilePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageRepresentation)) {
            return false;
        }
        ImageRepresentation that = (ImageRepresentation)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return this.localFilePath != null ? this.localFilePath.equals(that.localFilePath) : that.localFilePath == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.localFilePath != null ? this.localFilePath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return TAG + " type: " + this.type.toString() + ". id: " + (this.id != null ? this.id : "") + ".url: " + (this.url != null ? this.url : "") + ".size: " + this.size + ".localFilePath: " + (this.localFilePath != null ? this.localFilePath : "");
    }

    static ImageRepresentation fromJson(TYPE type, JSONObject body) throws JSONException {
        return new ImageRepresentation(type, body.getString("id"), body.getString("url"), body.getLong("size"), body.optString("localFilePath"));
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject representationJson = new JSONObject();
        representationJson.put("id", (Object)this.id);
        representationJson.put("size", this.size);
        representationJson.put("url", (Object)this.url);
        representationJson.put("localFilePath", (Object)this.localFilePath);
        return representationJson;
    }

    void recycleBitmap() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
    }

    public static enum TYPE {
        ORIGINAL,
        MEDIUM,
        THUMBNAIL;

    }
}

