/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.DeliveredReceipt;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.ImageRepresentation;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.SocketEventHandler;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import java.util.Collection;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Image
extends Event
implements Parcelable {
    private static final String TAG = Image.class.getSimpleName();
    private String localPath;
    private ImageRepresentation original;
    private ImageRepresentation medium;
    private ImageRepresentation thumbnail;
    public static final Parcelable.Creator<Image> CREATOR = new Parcelable.Creator<Image>(){

        public Image createFromParcel(Parcel in) {
            return new Image(in);
        }

        public Image[] newArray(int size) {
            return new Image[size];
        }
    };

    @VisibleForTesting(otherwise=4)
    protected Image(String localPath) {
        this.localPath = localPath;
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp) {
        this.id = id;
        this.timestamp = timestamp;
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member) {
        this(id, timestamp);
        this.member = member;
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Conversation conversation) {
        this(id, timestamp, member);
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Conversation conversation, ImageRepresentation original, ImageRepresentation medium, ImageRepresentation thumbnail) {
        this(id, timestamp, member, conversation);
        this.setRepresentations(original, medium, thumbnail);
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Date deletedTimestamp) {
        this(id, timestamp, member);
        this.deletedTimestamp = deletedTimestamp;
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Date deletedTimestamp, Conversation conversation) {
        this(id, timestamp, member, deletedTimestamp);
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Date deletedTimestamp, Collection<SeenReceipt> seenReceipts) {
        this(id, timestamp, member, deletedTimestamp);
        this.setSeenReceipts(seenReceipts);
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Date deletedTimestamp, Conversation conversation, Collection<SeenReceipt> seenReceipts) {
        this(id, timestamp, member, deletedTimestamp, conversation);
        this.setSeenReceipts(seenReceipts);
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Date deletedTimestamp, Conversation conversation, ImageRepresentation original, ImageRepresentation medium, ImageRepresentation thumbnail, Collection<SeenReceipt> seenReceipts, Collection<DeliveredReceipt> deliveredReceipts) {
        this(id, timestamp, member, conversation, original, medium, thumbnail);
        this.setSeenReceipts(seenReceipts);
        this.setDeliveryReceipts(deliveredReceipts);
    }

    @VisibleForTesting(otherwise=4)
    protected Image(String id, Date timestamp, Member member, Date deletedTimestamp, Conversation conversation, Collection<SeenReceipt> seenReceipts, Collection<DeliveredReceipt> deliveredReceipts) {
        this(id, timestamp, member, deletedTimestamp, conversation, seenReceipts);
        this.setDeliveryReceipts(deliveredReceipts);
    }

    @VisibleForTesting(otherwise=4)
    protected Image(Image message) {
        this(message.getId(), message.getTimestamp(), message.getMember(), message.getDeletedTimestamp(), message.getSeenReceipts());
    }

    @VisibleForTesting(otherwise=4)
    protected Image(Parcel in) {
        super(in);
        this.original = (ImageRepresentation)in.readParcelable(ImageRepresentation.class.getClassLoader());
        this.medium = (ImageRepresentation)in.readParcelable(ImageRepresentation.class.getClassLoader());
        this.thumbnail = (ImageRepresentation)in.readParcelable(ImageRepresentation.class.getClassLoader());
    }

    public ImageRepresentation getOriginal() {
        return this.original;
    }

    public ImageRepresentation getMedium() {
        return this.medium;
    }

    public ImageRepresentation getThumbnail() {
        return this.thumbnail;
    }

    public ImageRepresentation getImageRepresentationByType(ImageRepresentation.TYPE type) {
        switch (type) {
            case ORIGINAL: {
                return this.getOriginal();
            }
            case MEDIUM: {
                return this.getMedium();
            }
            case THUMBNAIL: {
                return this.getThumbnail();
            }
        }
        return null;
    }

    void updateLocalFilePaths(String localPath) {
        this.original.updateLocalFilePath(localPath);
        this.medium.updateLocalFilePath(localPath);
        this.thumbnail.updateLocalFilePath(localPath);
    }

    public boolean isDownloaded() {
        return this.thumbnail != null && !TextUtils.isEmpty((CharSequence)this.thumbnail.getLocalFilePath());
    }

    public void download(ImageRepresentation.TYPE type, final RequestHandler downloadListener) {
        SocketEventHandler socketEventHandler = this.conversation.getSignallingChannel().socketClient.getSocketEventHandler();
        if (this.deletedTimestamp != null) {
            this.conversation.getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                @Override
                public void run() {
                    downloadListener.onError(NexmoAPIError.invalidAction(Image.this.conversation.getConversationId(), "Image was deleted"));
                }
            });
            return;
        }
        if (this.getImageRepresentationByType(type).localFileExists()) {
            this.conversation.getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                @Override
                public void run() {
                    downloadListener.onSuccess(null);
                }
            });
        } else if (this.conversation.getSignallingChannel().getLoggedInUser() != null) {
            socketEventHandler.downloadImageRepresentation(this, type, downloadListener);
        } else {
            this.conversation.getSignallingChannel().getConversationClient().callUserCallback(new Runnable(){

                @Override
                public void run() {
                    downloadListener.onError(NexmoAPIError.noUserLoggedInForConversation(Image.this.conversation.getConversationId()));
                }
            });
        }
    }

    @Override
    public EventType getType() {
        return EventType.IMAGE;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.original, flags);
        dest.writeParcelable((Parcelable)this.medium, flags);
        dest.writeParcelable((Parcelable)this.thumbnail, flags);
    }

    public String toString() {
        return TAG + " .id: " + (this.id != null ? this.id : "") + " .Member: " + (this.getMember() != null ? this.getMember().toString() : "") + " .Timestamp: " + (this.getTimestamp() != null ? this.getTimestamp() : "") + " .Original representation: " + (this.original != null ? this.original.toString() : "") + " .Medium representation: " + (this.medium != null ? this.medium.toString() : "") + " .Thumbnail representation: " + (this.thumbnail != null ? this.thumbnail.toString() : "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Image image = (Image)o;
        if (this.original != null ? !this.original.equals(image.original) : image.original != null) {
            return false;
        }
        if (this.medium != null ? !this.medium.equals(image.medium) : image.medium != null) {
            return false;
        }
        return this.thumbnail != null ? this.thumbnail.equals(image.thumbnail) : image.thumbnail == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.original != null ? this.original.hashCode() : 0);
        result = 31 * result + (this.medium != null ? this.medium.hashCode() : 0);
        result = 31 * result + (this.thumbnail != null ? this.thumbnail.hashCode() : 0);
        return result;
    }

    public static Image fromPush(String senderId, String eventId, JSONObject messageObject) throws JSONException {
        Date timestamp = DateUtil.parseDateFromJson(messageObject, "timestamp");
        JSONObject representations = messageObject.getJSONObject("body").getJSONObject("representations");
        JSONObject originalJson = representations.getJSONObject("original");
        JSONObject mediumJson = representations.getJSONObject("medium");
        JSONObject thumbnailJson = representations.getJSONObject("thumbnail");
        ImageRepresentation original = ImageRepresentation.fromJson(ImageRepresentation.TYPE.ORIGINAL, originalJson);
        ImageRepresentation medium = ImageRepresentation.fromJson(ImageRepresentation.TYPE.MEDIUM, mediumJson);
        ImageRepresentation thumbnail = ImageRepresentation.fromJson(ImageRepresentation.TYPE.THUMBNAIL, thumbnailJson);
        return new Image(eventId, timestamp, new Member(senderId), null, original, medium, thumbnail);
    }

    void setRepresentations(ImageRepresentation original, ImageRepresentation medium, ImageRepresentation thumbnail) {
        this.original = original;
        this.medium = medium;
        this.thumbnail = thumbnail;
    }

    void recycleBitmaps() {
        if (this.original != null) {
            this.original.recycleBitmap();
        }
        if (this.medium != null) {
            this.medium.recycleBitmap();
        }
        if (this.thumbnail != null) {
            this.thumbnail.recycleBitmap();
        }
    }
}

