/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.os.Handler;
import android.support.annotation.NonNull;
import com.nexmo.sdk.conversation.client.Subscription;
import com.nexmo.sdk.conversation.client.event.ResultListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventSource<T> {
    private List<ResultListener<T>> subscriptions = Collections.synchronizedList(new ArrayList());
    private Handler handler;

    public EventSource(Handler handler) {
        this.handler = handler;
    }

    public Subscription<T> add(@NonNull ResultListener<T> listener) {
        this.subscriptions.add(listener);
        return new Subscription<T>(listener, this);
    }

    public void remove(@NonNull Subscription<T> subscription) {
        this.subscriptions.remove(subscription.getListener());
    }

    public void remove(@NonNull ResultListener<T> listener) {
        this.subscriptions.remove(listener);
    }

    void notifySubscriptions(final T value) {
        for (final ResultListener<T> subscription : this.subscriptions) {
            if (this.handler == null) {
                subscription.onSuccess(value);
                continue;
            }
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    subscription.onSuccess(value);
                }
            });
        }
    }
}

