/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.DeliveredReceipt;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.ImageRepresentation;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.MemberMedia;
import com.nexmo.sdk.conversation.client.ReceiptRecordUtil;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Event
implements Parcelable {
    private static final String TAG = Event.class.getSimpleName();
    protected String id;
    protected Date timestamp;
    protected Date deletedTimestamp;
    protected Member member;
    protected Set<SeenReceipt> seenReceiptList = Collections.synchronizedSet(new HashSet());
    protected Set<DeliveredReceipt> deliveredReceipts = Collections.synchronizedSet(new HashSet());
    protected Conversation conversation;

    @VisibleForTesting(otherwise=4)
    protected Event() {
    }

    @VisibleForTesting(otherwise=4)
    protected Event(String id, Date timestamp, Date deletedTimestamp) {
        this.id = id;
        this.timestamp = timestamp;
        this.deletedTimestamp = deletedTimestamp;
    }

    @VisibleForTesting(otherwise=4)
    protected Event(Parcel parcel) {
        this.id = parcel.readString();
        this.timestamp = (Date)parcel.readSerializable();
        this.deletedTimestamp = (Date)parcel.readSerializable();
        this.member = (Member)parcel.readParcelable(Member.class.getClassLoader());
        this.setDeliveryReceipts(Arrays.asList(parcel.createTypedArray(DeliveredReceipt.CREATOR)));
        this.setSeenReceipts(Arrays.asList(parcel.createTypedArray(SeenReceipt.CREATOR)));
    }

    public abstract EventType getType();

    public String getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getDeletedTimestamp() {
        return this.deletedTimestamp;
    }

    public Collection<SeenReceipt> getSeenReceipts() {
        return this.seenReceiptList;
    }

    public Collection<DeliveredReceipt> getDeliveredReceipts() {
        return this.deliveredReceipts;
    }

    public Member getMember() {
        return this.member;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public void markAsSeen(RequestHandler<SeenReceipt> listener) {
        if (listener != null) {
            if (this.deletedTimestamp != null || this.isMarkedAsSeen()) {
                listener.onError(new NexmoAPIError("invalid-action", this.getConversation().getConversationId(), "User cannot mark as seen this event anymore."));
            } else if (this.conversation.getSignallingChannel().getLoggedInUser() == null) {
                listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.getConversation().getConversationId()));
            } else {
                this.conversation.getSignallingChannel().sendSeenEvent(this, listener);
            }
        }
    }

    public void delete(RequestHandler<Void> eventDeleteListener) {
        if (eventDeleteListener == null) {
            Log.d(TAG, "Listener is mandatory");
        } else if (this.conversation.getSelf() == null) {
            eventDeleteListener.onError(NexmoAPIError.noUserLoggedInForConversation(this.getConversation().getConversationId()));
        } else if (this.deletedTimestamp != null) {
            eventDeleteListener.onError(new NexmoAPIError("invalid-action", this.getConversation().getConversationId(), "This message was already deleted"));
        } else {
            this.conversation.getSignallingChannel().deleteEvent(this.conversation, this, eventDeleteListener);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getId());
        dest.writeSerializable((Serializable)this.getTimestamp());
        dest.writeSerializable((Serializable)this.getDeletedTimestamp());
        dest.writeParcelable((Parcelable)this.getMember(), 0);
        dest.writeTypedArray((Parcelable[])this.getDeliveredReceipts().toArray(new DeliveredReceipt[0]), 0);
        dest.writeTypedArray((Parcelable[])this.getSeenReceipts().toArray(new SeenReceipt[0]), 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event Event2 = (Event)o;
        if (!this.id.equals(Event2.id)) {
            return false;
        }
        if (this.timestamp != null && Event2.timestamp != null && !this.timestamp.equals(Event2.timestamp)) {
            return false;
        }
        if (this.deletedTimestamp != null ? !this.deletedTimestamp.equals(Event2.deletedTimestamp) : Event2.deletedTimestamp != null) {
            return false;
        }
        if (!this.member.equals(Event2.member)) {
            return false;
        }
        return this.conversation.equals(Event2.conversation);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.deletedTimestamp != null ? this.deletedTimestamp.hashCode() : 0);
        if (this.member != null) {
            result = 31 * result + this.member.hashCode();
        }
        if (this.conversation != null) {
            result = 31 * result + this.conversation.hashCode();
        }
        return result;
    }

    public static Event fromCursor(Cursor cursor, Conversation conversation) {
        if (cursor == null) {
            return null;
        }
        Date timestamp = null;
        Date deletedTimestamp = null;
        Date joinedAt = null;
        Date invitedAt = null;
        Date leftAt = null;
        try {
            timestamp = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("timestamp")));
        }
        catch (ParseException e) {
            Log.d(TAG, "Event fromCursor: wrong date format - created timestamp");
        }
        try {
            deletedTimestamp = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("deleted_timestamp")));
        }
        catch (ParseException e) {
            Log.d(TAG, "Event fromCursor: wrong date format - deleted timestamp");
        }
        try {
            joinedAt = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("joined_at")));
        }
        catch (ParseException e) {
            Log.d(TAG, "Event fromCursor: wrong date format - joined timestamp");
        }
        try {
            invitedAt = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("invited_at")));
        }
        catch (ParseException e) {
            Log.d(TAG, "Event fromCursor: wrong date format - invited timestamp");
        }
        try {
            leftAt = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("left_at")));
        }
        catch (ParseException e) {
            Log.d(TAG, "Event fromCursor: wrong date format - left timestamp");
        }
        Member.STATE state = Member.STATE.fromId(cursor.getString(cursor.getColumnIndex("state")));
        Member self = new Member(cursor.getString(cursor.getColumnIndex("user_id")), cursor.getString(cursor.getColumnIndex("username")), cursor.getString(cursor.getColumnIndex("id")), joinedAt, invitedAt, leftAt, state);
        String text = cursor.getString(cursor.getColumnIndex("text"));
        String eventId = cursor.getString(cursor.getColumnIndex("event_id"));
        String typeString = cursor.getString(cursor.getColumnIndex("message_type"));
        String deliveredReceiptsJson = cursor.getString(cursor.getColumnIndex("delivered_receipts"));
        String seenReceiptsJson = cursor.getString(cursor.getColumnIndex("seen_receipts"));
        ArrayList<SeenReceipt> seenReceipts = new ArrayList();
        ArrayList<DeliveredReceipt> deliveredReceipts = new ArrayList();
        if (!TextUtils.isEmpty((CharSequence)deliveredReceiptsJson)) {
            try {
                deliveredReceipts = ReceiptRecordUtil.parseDeliveryReceiptHistory(conversation, eventId, new JSONObject(deliveredReceiptsJson));
            }
            catch (JSONException e) {
                e.printStackTrace();
                Log.d(TAG, "cannot parse delivery receipt records for this event");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)seenReceiptsJson)) {
            try {
                seenReceipts = ReceiptRecordUtil.parseSeenReceiptHistory(conversation, eventId, new JSONObject(seenReceiptsJson));
            }
            catch (JSONException e) {
                e.printStackTrace();
                Log.d(TAG, "cannot parse seen receipt records for this event");
            }
        }
        switch (EventType.valueOf(typeString)) {
            case TEXT: {
                return new Text(text, eventId, timestamp, self, conversation, deletedTimestamp, seenReceipts, deliveredReceipts);
            }
            case IMAGE: {
                if (deletedTimestamp != null) {
                    return new Image(eventId, timestamp, self, deletedTimestamp, conversation, seenReceipts, deliveredReceipts);
                }
                try {
                    JSONObject representationsJson = new JSONObject(cursor.getString(cursor.getColumnIndex("image_representations")));
                    JSONObject representations = representationsJson.getJSONObject("representations");
                    JSONObject originalJson = representations.getJSONObject("original");
                    JSONObject mediumJson = representations.getJSONObject("medium");
                    JSONObject thumbnailJson = representations.getJSONObject("thumbnail");
                    ImageRepresentation original = ImageRepresentation.fromJson(ImageRepresentation.TYPE.ORIGINAL, originalJson);
                    ImageRepresentation medium = ImageRepresentation.fromJson(ImageRepresentation.TYPE.MEDIUM, mediumJson);
                    ImageRepresentation thumbnail = ImageRepresentation.fromJson(ImageRepresentation.TYPE.THUMBNAIL, thumbnailJson);
                    return new Image(eventId, timestamp, self, null, conversation, original, medium, thumbnail, seenReceipts, deliveredReceipts);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return new Image(eventId, timestamp, self, null, conversation, seenReceipts, deliveredReceipts);
                }
            }
            case MEMBER_MEDIA: {
                boolean isAudioEnabled = cursor.getInt(cursor.getColumnIndex("audio_enabled")) == 1;
                return new MemberMedia(eventId, self, conversation, isAudioEnabled, timestamp);
            }
        }
        return null;
    }

    public static Event fromJson(Conversation conversation, JSONObject messageObject) throws JSONException {
        Event newEvent;
        String eventType;
        JSONObject body = messageObject.getJSONObject("body");
        String eventId = messageObject.getString("id");
        String memberId = messageObject.getString("from");
        Member member = conversation.getMember(memberId);
        if (member == null) {
            Log.d(TAG, "Event.fromJson out-of-sync members");
            return null;
        }
        Date timestamp = DateUtil.parseDateFromJson(messageObject, "timestamp");
        List<SeenReceipt> seenReceiptList = new ArrayList<SeenReceipt>();
        List<DeliveredReceipt> deliveredReceiptList = new ArrayList<DeliveredReceipt>();
        Date deletedTimestamp = null;
        if (body.has("timestamp") && body.get("timestamp") instanceof JSONObject && ((JSONObject)body.get("timestamp")).has("deleted")) {
            JSONObject timestampJson = body.getJSONObject("timestamp");
            deletedTimestamp = DateUtil.parseDateFromJson(timestampJson, "deleted");
        }
        if (TextUtils.isEmpty((CharSequence)(eventType = messageObject.optString("type")))) {
            eventType = body.has("text") ? "text" : "image";
        }
        switch (eventType) {
            case "text": {
                String payload = body.optString("text");
                newEvent = new Text(payload, eventId, timestamp, member, conversation, deletedTimestamp, seenReceiptList, deliveredReceiptList);
                break;
            }
            case "image": {
                if (deletedTimestamp != null) {
                    newEvent = new Image(eventId, timestamp, member, deletedTimestamp, conversation, seenReceiptList, deliveredReceiptList);
                    break;
                }
                JSONObject representations = body.getJSONObject("representations");
                JSONObject originalJson = representations.getJSONObject("original");
                JSONObject mediumJson = representations.getJSONObject("medium");
                JSONObject thumbnailJson = representations.getJSONObject("thumbnail");
                ImageRepresentation original = ImageRepresentation.fromJson(ImageRepresentation.TYPE.ORIGINAL, originalJson);
                ImageRepresentation medium = ImageRepresentation.fromJson(ImageRepresentation.TYPE.MEDIUM, mediumJson);
                ImageRepresentation thumbnail = ImageRepresentation.fromJson(ImageRepresentation.TYPE.THUMBNAIL, thumbnailJson);
                newEvent = new Image(eventId, timestamp, member, null, conversation, original, medium, thumbnail, seenReceiptList, deliveredReceiptList);
                break;
            }
            case "member:media": {
                boolean isAudioEnabled = body.optBoolean("audio");
                newEvent = new MemberMedia(eventId, member, conversation, isAudioEnabled, timestamp);
                break;
            }
            default: {
                Log.d(TAG, "Invalid message type: " + eventType);
                return null;
            }
        }
        conversation.addEvent(newEvent);
        if (messageObject.has("state") && messageObject.get("state") instanceof JSONObject) {
            JSONObject stateJson = messageObject.getJSONObject("state");
            seenReceiptList = ReceiptRecordUtil.parseSeenReceiptHistory(conversation, eventId, stateJson);
            deliveredReceiptList = ReceiptRecordUtil.parseDeliveryReceiptHistory(conversation, eventId, stateJson);
            newEvent.setSeenReceipts(seenReceiptList);
            newEvent.setDeliveryReceipts(deliveredReceiptList);
        } else {
            Log.d(TAG, "no receipt records for this event");
        }
        return newEvent;
    }

    @VisibleForTesting(otherwise=3)
    synchronized void setMember(Member member) {
        this.member = member;
    }

    void setId(String id) {
        this.id = id;
    }

    void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    synchronized void setDeletedTimestamp(Date deletedTimestamp) {
        this.deletedTimestamp = deletedTimestamp;
    }

    void addSeenReceipt(SeenReceipt seenReceipt) {
        this.seenReceiptList.add(seenReceipt);
    }

    void addDeliveredReceipt(DeliveredReceipt deliveredReceipt) {
        this.deliveredReceipts.add(deliveredReceipt);
    }

    void setDeliveryReceipts(Collection<DeliveredReceipt> deliveryReceipts) {
        if (deliveryReceipts != null) {
            this.deliveredReceipts = new HashSet<DeliveredReceipt>(deliveryReceipts);
        }
    }

    void setSeenReceipts(Collection<SeenReceipt> seenReceipts) {
        if (seenReceipts != null) {
            this.seenReceiptList = new HashSet<SeenReceipt>(seenReceipts);
        }
    }

    void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    boolean isReadyForMarkedAsDelivered() {
        return !this.isEventMarkedAsDeliveredByUser() && !this.isOwnMessage() && (this.getType() == EventType.TEXT || this.getType() == EventType.IMAGE);
    }

    private boolean isEventMarkedAsDeliveredByUser() {
        if (this.deliveredReceipts != null) {
            for (DeliveredReceipt receipt : this.deliveredReceipts) {
                Member self = this.getConversation().getSelf();
                if (self == null || !TextUtils.equals((CharSequence)receipt.getMember().getMemberId(), (CharSequence)self.getMemberId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOwnMessage() {
        User self = this.conversation.getSignallingChannel().getLoggedInUser();
        if (self != null && this.getMember() != null) {
            return this.getMember().getUserId().equals(self.getUserId());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMarkedAsSeen() {
        Set<SeenReceipt> set = this.seenReceiptList;
        synchronized (set) {
            for (SeenReceipt seenReceipt : this.seenReceiptList) {
                if (!TextUtils.equals((CharSequence)seenReceipt.getMember().getMemberId(), (CharSequence)this.conversation.getMemberId())) continue;
                return true;
            }
        }
        return false;
    }
}

