/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Call;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.ConversationClient;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.ImageRepresentation;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.SocketClient;
import com.nexmo.sdk.conversation.client.SocketEventHandler;
import com.nexmo.sdk.conversation.client.SocketEventNotifier;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.audio.AppRTCAudioManager;
import com.nexmo.sdk.conversation.client.audio.AudioCallEventListener;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.client.event.container.SynchronisingState;
import com.nexmo.sdk.conversation.client.event.network.NetworkState;
import com.nexmo.sdk.conversation.core.client.request.CreateConversationRequest;
import com.nexmo.sdk.conversation.core.client.request.DeleteEventRequest;
import com.nexmo.sdk.conversation.core.client.request.GetConversationRequest;
import com.nexmo.sdk.conversation.core.client.request.GetEventsRequest;
import com.nexmo.sdk.conversation.core.client.request.GetUserInfoRequest;
import com.nexmo.sdk.conversation.core.client.request.InviteRequest;
import com.nexmo.sdk.conversation.core.client.request.InviteWithAudioRequest;
import com.nexmo.sdk.conversation.core.client.request.JoinRequest;
import com.nexmo.sdk.conversation.core.client.request.LeaveRequest;
import com.nexmo.sdk.conversation.core.client.request.PushSubscribeRequest;
import com.nexmo.sdk.conversation.core.client.request.PushSubscriptionRequest;
import com.nexmo.sdk.conversation.core.client.request.PushUnsubscribeRequest;
import com.nexmo.sdk.conversation.core.client.request.Request;
import com.nexmo.sdk.conversation.core.client.request.SeenReceiptRequest;
import com.nexmo.sdk.conversation.core.client.request.SendImageMessageRequest;
import com.nexmo.sdk.conversation.core.client.request.SendTextMessageRequest;
import com.nexmo.sdk.conversation.core.client.request.TypingIndicatorRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.AudioEarmuffRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.AudioMuteRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.AudioRingingRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.RtcNewRequest;
import com.nexmo.sdk.conversation.core.client.request.audio.RtcTerminateRequest;
import com.nexmo.sdk.conversation.core.networking.ImageUploader;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationSignalingChannel {
    private static final String TAG = ConversationSignalingChannel.class.getSimpleName();
    SocketClient socketClient;
    private ConversationClient conversationClient;
    private SynchronisingState.STATE syncState = SynchronisingState.STATE.OUT_OF_SYNC;

    ConversationSignalingChannel(ConversationClient conversationClient, SocketClient socketClient) {
        this.conversationClient = conversationClient;
        this.socketClient = socketClient;
    }

    void connect(RequestHandler<User> loginListener) {
        try {
            this.socketClient.connect(loginListener);
        }
        catch (IllegalStateException e) {
            loginListener.onError(NexmoAPIError.alreadyConnecting());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    boolean isConnecting() {
        return this.socketClient.getConnectionStatus() == NetworkState.CONNECTED;
    }

    NetworkState getConnectionStatus() {
        return this.socketClient.getConnectionStatus();
    }

    SynchronisingState.STATE getSyncState() {
        return this.syncState;
    }

    synchronized void updateSyncState(SynchronisingState.STATE syncState) {
        this.syncState = syncState;
    }

    public User getLoggedInUser() {
        return this.socketClient.getLoggedInUser();
    }

    void enableAllPushNotifications(boolean enable, RequestHandler pushEnableListener) {
        if (enable) {
            this.socketClient.pushRegister(pushEnableListener);
        } else {
            this.socketClient.pushUnregister(pushEnableListener);
        }
    }

    void enablePushNotifications(boolean enable, String cid, RequestHandler<Void> pushEnableListener) {
        PushSubscriptionRequest pushSubscribeRequest = enable ? new PushSubscribeRequest(cid, pushEnableListener) : new PushUnsubscribeRequest(cid, pushEnableListener);
        this.socketClient.pushSubscribeToConversation(pushSubscribeRequest);
    }

    public void logout(RequestHandler logoutListener) {
        this.socketClient.logout(logoutListener);
    }

    public void newConversation(String name, RequestHandler listener) {
        CreateConversationRequest createConversationRequest = new CreateConversationRequest(name, listener);
        this.socketClient.newConversation(createConversationRequest);
    }

    public void newConversationWithJoin(String name, RequestHandler listener) {
        CreateConversationRequest createConversationRequest = new CreateConversationRequest(name, listener);
        this.socketClient.newConversationHelper(createConversationRequest);
    }

    public void createCall(final List<String> users, final RequestHandler<Call> listener) {
        if (users == null || users.isEmpty()) {
            listener.onError(NexmoAPIError.missingParams());
        } else {
            StringBuilder callName = new StringBuilder("CALL_" + this.getLoggedInUser().getName());
            for (String username : users) {
                callName.append("_");
                callName.append(username);
            }
            this.newConversationWithJoin(callName.toString(), new RequestHandler<Conversation>(){

                @Override
                public void onError(NexmoAPIError apiError) {
                    listener.onError(apiError);
                }

                @Override
                public void onSuccess(Conversation result) {
                    Log.d(TAG, "Call conversation created and joined: " + result.getDisplayName());
                    ConversationSignalingChannel.this.inviteUsersToCall(result, users, listener);
                }
            });
        }
    }

    private void inviteUsersToCall(final Conversation conversation, List<String> users, final RequestHandler<Call> listener) {
        final AtomicInteger invitationsSent = new AtomicInteger(0);
        for (String user : users) {
            this.inviteWithAudio(conversation, null, user, false, false, new RequestHandler<Member>(){

                @Override
                public void onError(NexmoAPIError apiError) {
                    listener.onError(apiError);
                }

                @Override
                public void onSuccess(Member result) {
                    if (invitationsSent.incrementAndGet() == 1) {
                        ConversationSignalingChannel.this.socketClient.getSocketEventHandler().addOrUpdateConversationList(conversation);
                        conversation.media(Conversation.MEDIA_TYPE.AUDIO).enable(new AudioCallEventListener(){

                            @Override
                            public void onRinging() {
                                Call outgoingCall = new Call(conversation, ConversationSignalingChannel.this.getLoggedInUser().getName());
                                ConversationSignalingChannel.this.socketClient.getSocketEventHandler().updateCallList(outgoingCall);
                                listener.onSuccess(outgoingCall);
                            }

                            @Override
                            public void onCallConnected() {
                            }

                            @Override
                            public void onCallEnded() {
                            }

                            @Override
                            public void onGeneralCallError(NexmoAPIError apiError) {
                                listener.onError(apiError);
                            }

                            @Override
                            public void onAudioRouteChange(AppRTCAudioManager.AudioDevice device) {
                            }
                        });
                    }
                }
            });
        }
    }

    public boolean isAudioEnabled() {
        for (Conversation conversation : this.conversationClient.getConversationList()) {
            if (!conversation.isAudioEnabled()) continue;
            return true;
        }
        return false;
    }

    public void disableAudio() {
        for (Conversation conversation : this.conversationClient.getConversationList()) {
            if (!conversation.isAudioEnabled()) continue;
            conversation.media(Conversation.MEDIA_TYPE.AUDIO).disable(new RequestHandler<Void>(){

                @Override
                public void onError(NexmoAPIError apiError) {
                    Log.d(TAG, "Cannot disable audio. Logout initiated");
                }

                @Override
                public void onSuccess(Void result) {
                }
            });
            return;
        }
    }

    public void rtcNew(String cid, String memberId, String SDP, RequestHandler listener) {
        RtcNewRequest rtcNewRequest = new RtcNewRequest(cid, memberId, SDP, listener);
        this.socketClient.rtcNew(rtcNewRequest);
    }

    public void rtcTerminate(String cid, String memberId, String rtcId, final RequestHandler listener) {
        RtcTerminateRequest rtcTerminateRequest = new RtcTerminateRequest(cid, memberId, rtcId, new RequestHandler<String>(){

            @Override
            public void onError(NexmoAPIError apiError) {
                listener.onError(apiError);
            }

            @Override
            public void onSuccess(String result) {
                Log.d(TAG, "rtcTerminate onSuccess " + result);
                listener.onSuccess(result);
            }
        });
        this.socketClient.rtcTerminate(rtcTerminateRequest);
    }

    public void rtcMute(String cid, String memberId, boolean isMute, RequestHandler listener) {
        AudioMuteRequest muteRequest = new AudioMuteRequest(cid, memberId, isMute, listener);
        this.socketClient.rtcMute(muteRequest);
    }

    public void rtcEarmuff(String cid, String memberId, boolean isEarmuffed, RequestHandler listener) {
        AudioEarmuffRequest earmuffRequest = new AudioEarmuffRequest(cid, memberId, isEarmuffed, listener);
        this.socketClient.rtcEarmuff(earmuffRequest);
    }

    public void mediaRinging(String cid, String memberId, boolean isRinging, RequestHandler listener) {
        AudioRingingRequest ringingRequest = new AudioRingingRequest(cid, memberId, isRinging, listener);
        this.socketClient.audioRinging(ringingRequest);
    }

    void joinConversation(String conversationId, String conversationName, String memberId, RequestHandler<Member> requestHandler) {
        if (this.getLoggedInUser() != null) {
            JoinRequest joinRequest = JoinRequest.createJoinRequestWithMemberId(conversationId, conversationName, memberId, requestHandler, this.getLoggedInUser().getUserId(), this.getLoggedInUser().getName());
            this.socketClient.joinConversation(joinRequest);
        } else {
            requestHandler.onError(NexmoAPIError.noUserLoggedInForConversation(conversationId));
        }
    }

    void joinUserToConversation(String conversationId, String conversationName, String username, RequestHandler<Member> requestHandler) {
        JoinRequest joinRequest = JoinRequest.createJoinRequestWithUsername(conversationId, conversationName, requestHandler, username);
        this.socketClient.joinConversation(joinRequest);
    }

    void joinUserToConversationWithId(String conversationId, String conversationName, String userId, RequestHandler<Member> requestHandler) {
        JoinRequest joinRequest = JoinRequest.createJoinRequestWithUserId(conversationId, conversationName, requestHandler, userId);
        this.socketClient.joinConversation(joinRequest);
    }

    void leaveConversation(Conversation conversation, Member member, RequestHandler<Void> leaveListener) {
        LeaveRequest leaveRequest = new LeaveRequest(Request.TYPE.LEAVE, conversation.getConversationId(), member, leaveListener);
        this.socketClient.leaveConversation(leaveRequest);
    }

    public void invite(String conversationId, String username, RequestHandler<Member> inviteSendListener) {
        InviteRequest inviteRequest = new InviteRequest(conversationId, username, inviteSendListener);
        this.socketClient.invite(inviteRequest);
    }

    void inviteWithAudio(Conversation conversation, String userId, String username, boolean isMuted, boolean isEarmuffed, RequestHandler<Member> listener) {
        InviteWithAudioRequest inviteWithAudioRequest = new InviteWithAudioRequest(conversation.getConversationId(), userId, username, isMuted, isEarmuffed, listener);
        this.socketClient.createCall(inviteWithAudioRequest);
    }

    @VisibleForTesting(otherwise=3)
    void updateConversationList() {
        this.socketClient.updateConversationList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConversationListFromCache() {
        List<Conversation> conversations = CacheDB.getCacheDBInstance().getConversationRepository().read(this.socketClient.getConversationClient().getUser());
        SocketEventNotifier socketEventNotifier = this.socketClient.getConversationClient().getEventNotifier();
        SocketEventHandler socketEventHandler = this.socketClient.getSocketEventHandler();
        for (Conversation conversation : conversations) {
            conversation.setConversationSignalingChannel(this.socketClient.getConversationClient().getSignallingChannel());
            conversation.setSocketEventNotifier(socketEventNotifier);
        }
        List<Conversation> list = socketEventHandler.getConversationList();
        synchronized (list) {
            socketEventHandler.getConversationList().clear();
            socketEventHandler.getConversationList().addAll(conversations);
        }
        this.socketClient.getConversationClient().synchronisationEvent().notifySubscriptions(SynchronisingState.STATE.MEMBERS);
        socketEventNotifier.notifyConversationListListener(socketEventHandler.getConversationList());
        this.updateSyncState(SynchronisingState.STATE.MEMBERS);
    }

    public void getConversation(Conversation conversation, RequestHandler<Conversation> requestHandler) {
        String cid = conversation.getConversationId();
        if (this.isConnecting()) {
            GetConversationRequest getConversationRequest = new GetConversationRequest(cid, requestHandler);
            this.socketClient.getConversation(getConversationRequest);
        } else if (this.conversationClient.getUser() != null) {
            Conversation cachedConversation = CacheDB.getCacheDBInstance().getConversationRepository().read(cid);
            if (cachedConversation == null) {
                requestHandler.onSuccess(null);
                return;
            }
            SocketEventNotifier socketEventNotifier = this.socketClient.getConversationClient().getEventNotifier();
            conversation.setConversationSignalingChannel(this.socketClient.getConversationClient().getSignallingChannel());
            conversation.setSocketEventNotifier(socketEventNotifier);
            conversation.updateBasicDetails(cachedConversation);
            conversation.setSelf(cachedConversation.getSelf());
            List<Member> members = CacheDB.getCacheDBInstance().getMemberRepository().read(cid);
            for (Member member : members) {
                conversation.addMember(member);
            }
            requestHandler.onSuccess(conversation);
        } else {
            requestHandler.onError(NexmoAPIError.noUserLoggedInForConversation(cid));
        }
    }

    void getMembersBeforeGetEvents(Conversation conversation, final String startId, final String endId, final RequestHandler<Conversation> requestHandler) {
        Log.d(TAG, "getMembersBeforeGetEvents");
        this.getConversation(conversation, new RequestHandler<Conversation>(){

            @Override
            public void onSuccess(Conversation conversation) {
                ConversationSignalingChannel.this.getEvents(conversation, startId, endId, requestHandler);
            }

            @Override
            public void onError(NexmoAPIError error) {
                Log.e(TAG, "getMembersBeforeGetEvents: " + error.getMessage());
            }
        });
    }

    void getEvents(Conversation conversation, String startId, String endId, RequestHandler<Conversation> requestHandler) {
        String lastCachedEventId = CacheDB.getCacheDBInstance().getEventRepository().getLastEventId(conversation.getConversationId());
        String lastEventIdFromCAPI = conversation.getLastMessageEventId() != null ? conversation.getLastMessageEventId() : conversation.getLastEventId();
        Log.d(TAG, "Conversation: LastCachedEventId: " + lastCachedEventId + " AND lastEventIdFromCAPI: " + lastEventIdFromCAPI);
        if (this.isConnecting() && !TextUtils.equals((CharSequence)lastEventIdFromCAPI, (CharSequence)lastCachedEventId)) {
            Log.d(TAG, "getEvents from CAPI");
            GetEventsRequest request = new GetEventsRequest(conversation, startId, endId, requestHandler);
            this.socketClient.getEvents(request);
        } else {
            CacheDB.getCacheDBInstance().getEventRepository().read(conversation.getConversationId(), conversation);
            requestHandler.onSuccess(conversation);
        }
    }

    public void sendText(Conversation conversation, String message, RequestHandler listener) {
        SendTextMessageRequest sendMessageRequest = new SendTextMessageRequest(conversation.getConversationId(), conversation.getMemberId(), message, listener);
        this.socketClient.sendText(sendMessageRequest);
    }

    public ImageUploader.CancelableCall sendImage(final Conversation conversation, final String imagePath, final RequestHandler listener) {
        Callback uploadCallback = new Callback(){

            public void onFailure(okhttp3.Call call, IOException e) {
                Log.d(TAG, "onFailure upload " + e.toString());
                listener.onError(new NexmoAPIError("image:upload-failure", conversation.getConversationId(), e.toString()));
            }

            public void onResponse(okhttp3.Call call, Response response) throws IOException {
                Log.d(TAG, "onResponse upload" + response.toString());
                if (!response.isSuccessful()) {
                    listener.onError(new NexmoAPIError("image:upload-failure", conversation.getConversationId(), "Unexpected code: " + response.code()));
                    response.body().close();
                    return;
                }
                try {
                    JSONObject body = new JSONObject(response.body().string());
                    this.handleResponse(body);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    NexmoAPIError.forward(listener, NexmoAPIError.unexpectedResponse(null, conversation.getConversationId()));
                }
                response.body().close();
            }

            void handleResponse(JSONObject body) throws JSONException {
                ImageRepresentation original = ImageRepresentation.fromJson(ImageRepresentation.TYPE.ORIGINAL, body.getJSONObject("original"));
                ImageRepresentation medium = ImageRepresentation.fromJson(ImageRepresentation.TYPE.MEDIUM, body.getJSONObject("medium"));
                ImageRepresentation thumbnail = ImageRepresentation.fromJson(ImageRepresentation.TYPE.THUMBNAIL, body.getJSONObject("thumbnail"));
                Log.d(TAG, "upload response: " + body.toString());
                SendImageMessageRequest sendMessageRequest = new SendImageMessageRequest(conversation.getConversationId(), conversation.getMemberId(), imagePath, listener);
                sendMessageRequest.updateImages(original, medium, thumbnail, body);
                ConversationSignalingChannel.this.socketClient.sendImage(sendMessageRequest);
            }
        };
        return ImageUploader.uploadImage(imagePath, uploadCallback, this.conversationClient.getConfig().getImageProcessingServiceUrl(), this.conversationClient.getToken());
    }

    void getUserInfo(String userId, RequestHandler<User> userInfoListener) {
        GetUserInfoRequest request = new GetUserInfoRequest(userId, userInfoListener);
        this.socketClient.getUser(request);
    }

    void sendSeenEvent(Event event, RequestHandler<SeenReceipt> listener) {
        SeenReceiptRequest seenReceiptRequest = new SeenReceiptRequest(event, event.getConversation().getSelf(), listener);
        this.socketClient.sendReceiptRecord(seenReceiptRequest);
    }

    void sendTypingIndicator(Conversation conversation, Member.TYPING_INDICATOR typingIndicator, RequestHandler listener) {
        TypingIndicatorRequest request = TypingIndicatorRequest.forType(typingIndicator, conversation.getConversationId(), conversation.getMemberId(), listener);
        this.socketClient.sendTypingIndicator(request);
    }

    void deleteEvent(Conversation conversation, Event event, RequestHandler<Void> listener) {
        if (event.getType() == EventType.TEXT) {
            DeleteEventRequest deleteEventRequest = new DeleteEventRequest(conversation.getConversationId(), conversation.getMemberId(), event.getId(), listener);
            this.socketClient.deleteEvent(deleteEventRequest);
        } else if (event.getType() == EventType.IMAGE) {
            this.socketClient.getSocketEventHandler().deleteImageRepresentations((Image)event, listener);
        }
    }

    ConversationClient getConversationClient() {
        return this.conversationClient;
    }

    boolean isValidInput(RequestHandler listener, String conversationId) {
        boolean isValid = false;
        if (listener != null) {
            if (this.getLoggedInUser() != null) {
                isValid = true;
            } else {
                this.noUserLoggedInError(conversationId, listener);
            }
        } else {
            Log.d(TAG, "Listener is mandatory");
        }
        return isValid;
    }

    private void noUserLoggedInError(String conversationId, RequestHandler listener) {
        if (conversationId == null) {
            listener.onError(NexmoAPIError.noUserLoggedIn());
        } else {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(conversationId));
        }
    }

    SocketClient getSocketClient() {
        return this.socketClient;
    }
}

