/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.bugsnag.android.Bugsnag;
import com.nexmo.sdk.conversation.client.CacheDB;
import com.nexmo.sdk.conversation.client.Call;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.ConversationSignalingChannel;
import com.nexmo.sdk.conversation.client.EventSource;
import com.nexmo.sdk.conversation.client.SocketClient;
import com.nexmo.sdk.conversation.client.SocketEventNotifier;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.event.ConversationClientException;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.client.event.container.Invitation;
import com.nexmo.sdk.conversation.client.event.container.SynchronisingState;
import com.nexmo.sdk.conversation.client.event.misc.SessionError;
import com.nexmo.sdk.conversation.client.event.network.NetworkState;
import com.nexmo.sdk.conversation.client.event.network.NetworkingStateListener;
import com.nexmo.sdk.conversation.core.client.Router;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConversationClient {
    private static final String TAG = ConversationClient.class.getSimpleName();
    private ConversationClientConfig config;
    private String authToken;
    private ConversationSignalingChannel signalingChannel;
    private SocketEventNotifier socketEventNotifier;
    private boolean pushEnabledForAllConversations;
    private String pushDeviceToken;
    private RequestHandler<Void> pushEnableListener;
    private ConcurrentMap<String, EventSource<?>> eventSourceMap = new ConcurrentHashMap();
    Handler handlerForCallbacks = null;

    private ConversationClient(ConversationClientConfig config) {
        this.config = config;
        if (this.config.enableCrashReporting) {
            Bugsnag.init((Context)config.getContext());
            Bugsnag.setAppVersion((String)"0.22.0");
        }
        CacheDB.initializeCacheDBInstance(config.getContext());
        this.socketEventNotifier = new SocketEventNotifier();
        this.signalingChannel = new ConversationSignalingChannel(this, new SocketClient(this));
        this.handlerForCallbacks = config.isOnMainThread() ? new Handler(config.getContext().getMainLooper()) : null;
    }

    public void login(String token, RequestHandler<User> loginListener) {
        if (loginListener != null) {
            if (TextUtils.isEmpty((CharSequence)token)) {
                loginListener.onError(NexmoAPIError.missingParams());
            } else if (this.getSignallingChannel().getLoggedInUser() != null) {
                loginListener.onError(NexmoAPIError.onUserAlreadyLoggedIn());
            } else if (this.signalingChannel.isConnecting()) {
                loginListener.onError(new NexmoAPIError("login:already-connecting", "Already connecting"));
            } else {
                this.authToken = token;
                this.signalingChannel.connect(loginListener);
            }
        } else {
            Log.d(TAG, "LoginListener is mandatory!");
        }
    }

    public void logout(RequestHandler logoutListener) {
        if (logoutListener != null) {
            if (this.getSignallingChannel().getLoggedInUser() != null) {
                this.signalingChannel.logout(logoutListener);
                this.authToken = null;
            } else {
                logoutListener.onError(NexmoAPIError.noUserLoggedIn());
            }
        } else {
            Log.d(TAG, "LogoutListener is mandatory!");
        }
    }

    public void setPushDeviceToken(String pushDeviceToken) {
        this.pushDeviceToken = pushDeviceToken;
    }

    public void enableAllPushNotifications(boolean enable, RequestHandler<Void> pushEnableListener) {
        if (pushEnableListener != null) {
            this.pushEnableListener = pushEnableListener;
            if (this.getSignallingChannel().getLoggedInUser() != null) {
                this.pushEnabledForAllConversations = enable;
                this.signalingChannel.enableAllPushNotifications(enable, pushEnableListener);
            } else {
                this.pushEnableListener.onError(NexmoAPIError.noUserLoggedIn());
            }
        } else {
            Log.d(TAG, "PushEnableListener is mandatory!");
        }
    }

    public void enablePushNotificationsForConversation(boolean enable, String conversationId, RequestHandler<Void> pushEnableListener) {
        if (pushEnableListener != null) {
            this.pushEnableListener = pushEnableListener;
            this.pushEnabledForAllConversations = enable && this.pushEnabledForAllConversations;
            this.signalingChannel.enablePushNotifications(enable, conversationId, pushEnableListener);
        } else {
            Log.d(TAG, "PushEnableListener is mandatory!");
        }
    }

    public void newConversation(String conversationName, RequestHandler<Conversation> conversationCreateListener) {
        if (this.getSignallingChannel().isValidInput(conversationCreateListener, null)) {
            this.createConversationWithJoin(false, conversationName, conversationCreateListener);
        }
    }

    public void newConversation(boolean withJoin, String conversationName, RequestHandler<Conversation> conversationCreateListener) {
        if (this.getSignallingChannel().isValidInput(conversationCreateListener, null)) {
            this.createConversationWithJoin(withJoin, conversationName, conversationCreateListener);
        }
    }

    public void call(List<String> users, RequestHandler<Call> callCreateListener) {
        if (this.getSignallingChannel().isValidInput(callCreateListener, null)) {
            this.signalingChannel.createCall(users, callCreateListener);
        }
    }

    public void getConversations(RequestHandler<List<Conversation>> conversationListListener) {
        if (conversationListListener != null) {
            if (this.getSignallingChannel().socketClient.getConnectionStatus() == NetworkState.CONNECTED) {
                this.socketEventNotifier.setConversationListListener(conversationListListener);
                this.signalingChannel.updateConversationList();
            } else if (this.getSignallingChannel().getLoggedInUser() != null) {
                this.socketEventNotifier.setConversationListListener(conversationListListener);
                this.signalingChannel.updateConversationListFromCache();
            } else {
                conversationListListener.onError(NexmoAPIError.noUserLoggedIn());
            }
        } else {
            Log.d(TAG, "ConversationListListener is mandatory");
        }
    }

    public List<Conversation> getConversationList() {
        return this.signalingChannel.socketClient.getSocketEventHandler().getConversationList();
    }

    public Conversation getConversation(String cid) {
        return this.signalingChannel.socketClient.getSocketEventHandler().findConversation(cid);
    }

    public final User getUser() {
        return this.signalingChannel.getLoggedInUser();
    }

    public boolean isLoggedIn() {
        return this.getSignallingChannel().getLoggedInUser() != null;
    }

    public void getUser(String userId, RequestHandler<User> userInfoListener) {
        if (userInfoListener == null) {
            Log.d(TAG, "ConversationListListener is mandatory");
            return;
        }
        if (this.getSignallingChannel().getLoggedInUser() == null) {
            userInfoListener.onError(NexmoAPIError.noUserLoggedIn());
        } else {
            this.signalingChannel.getUserInfo(userId, userInfoListener);
        }
    }

    public NetworkState getNetworkingState() {
        return this.signalingChannel.getConnectionStatus();
    }

    public Context getContext() {
        return this.config.getContext();
    }

    public String getToken() {
        return this.authToken;
    }

    public String getPushDeviceToken() {
        return this.pushDeviceToken;
    }

    public RequestHandler<Void> getPushEnableListener() {
        return this.pushEnableListener;
    }

    public ConversationClientConfig getConfig() {
        return this.config;
    }

    public List<IPSHeader> ipsHeaders() {
        return Arrays.asList(new IPSHeader("Authorization", "Bearer " + this.getToken()));
    }

    <T> EventSource<T> getEventSource(String id) {
        if (!this.eventSourceMap.containsKey(id)) {
            this.eventSourceMap.putIfAbsent(id, new EventSource(this.handlerForCallbacks));
        }
        return (EventSource)this.eventSourceMap.get(id);
    }

    public EventSource<Invitation> invitedEvent() {
        return this.getEventSource("invitedEvent");
    }

    public EventSource<SessionError> sessionErrorEvent() {
        return this.getEventSource("sessionErrorEvent");
    }

    public EventSource<Conversation> joinedToNewConversationEvent() {
        return this.getEventSource("joinedToNewConversationEvent");
    }

    public EventSource<Call> callEvent() {
        return this.getEventSource("callEvent");
    }

    public void listenToConnectionEvents(NetworkingStateListener listener) {
        this.signalingChannel.socketClient.addConnectionListener(listener);
    }

    public void removeConnectionListener(NetworkingStateListener listener) {
        this.signalingChannel.socketClient.removeConnectionListener(listener);
    }

    public SynchronisingState.STATE getSynchronisingState() {
        return this.signalingChannel.getSyncState();
    }

    public EventSource<SynchronisingState.STATE> synchronisationEvent() {
        return this.getEventSource("synchronisationEvent");
    }

    public String toString() {
        return TAG + " Token: " + (this.authToken != null ? this.authToken : "");
    }

    public static String getSDKversion() {
        return "0.22.0";
    }

    @VisibleForTesting(otherwise=3)
    ConversationSignalingChannel getSignallingChannel() {
        return this.signalingChannel;
    }

    @VisibleForTesting(otherwise=3)
    SocketEventNotifier getEventNotifier() {
        return this.socketEventNotifier;
    }

    @VisibleForTesting(otherwise=2)
    Router getRouter() {
        return this.signalingChannel.socketClient.router;
    }

    public void disconnect() {
        if (this.getSignallingChannel().socketClient.getConnectionStatus() != NetworkState.DISCONNECTED) {
            this.getSignallingChannel().socketClient.explicitDisconnect();
        } else {
            Log.w(TAG, "Cannot disconnect socket connection, there is no connection in use.");
        }
    }

    void callUserCallback(Runnable subject) {
        if (this.handlerForCallbacks == null) {
            subject.run();
            return;
        }
        this.handlerForCallbacks.post(subject);
    }

    private void createConversationWithJoin(boolean withJoin, String conversationName, RequestHandler<Conversation> conversationCreateListener) {
        if (withJoin) {
            this.signalingChannel.newConversationWithJoin(conversationName, conversationCreateListener);
        } else {
            this.signalingChannel.newConversation(conversationName, conversationCreateListener);
        }
    }

    public static class ConversationClientBuilder
    extends ConversationClientConfig {
        public ConversationClient build() {
            StringBuilder builder = new StringBuilder();
            if (this.context == null) {
                ConversationClientException.appendExceptionCause(builder, "Context");
                throw new ConversationClientException("Building a ConversationClient instance has failed due to missing parameters: " + builder.toString());
            }
            if (this.environmentHost == null) {
                throw new ConversationClientException("environmentHost can't be null");
            }
            if (this.imageProcessingServiceUrl == null) {
                throw new ConversationClientException("imageProcessingServiceUrl can't be null");
            }
            if (this.endpointPath == null) {
                throw new ConversationClientException("endpointPath can't be null");
            }
            if (this.logLevel > 7) {
                throw new ConversationClientException("Maximum log level is ASSERT");
            }
            if (this.logLevel < 2) {
                throw new ConversationClientException("Minimum log level is VERBOSE");
            }
            Log.setLevel(this.logLevel);
            return new ConversationClient(this);
        }

        public ConversationClientBuilder context(@NonNull Context context) {
            this.context = context;
            return this;
        }

        public ConversationClientBuilder environmentHost(@NonNull String environmentHost) {
            this.environmentHost = environmentHost;
            return this;
        }

        public ConversationClientBuilder enableCrashReporting(boolean enableCrashReporting) {
            this.enableCrashReporting = enableCrashReporting;
            return this;
        }

        public ConversationClientBuilder imageProcessingServiceUrl(@NonNull String ipsUrl) {
            this.imageProcessingServiceUrl = ipsUrl;
            return this;
        }

        public ConversationClientBuilder endpointPath(@NonNull String path) {
            this.endpointPath = path;
            return this;
        }

        public ConversationClientBuilder flushPending(boolean flushPending) {
            this.flushPending = flushPending;
            return this;
        }

        public ConversationClientBuilder logLevel(int logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public ConversationClientBuilder autoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public ConversationClientBuilder onMainThread(boolean useMainThread) {
            this.onMainThread = useMainThread;
            return this;
        }
    }

    public static class ConversationClientConfig {
        protected Context context;
        protected String environmentHost = "https://ws.nexmo.com";
        protected String endpointPath = "/rtc/";
        protected boolean enableCrashReporting = false;
        protected String imageProcessingServiceUrl = "https://api.nexmo.com/v1/image";
        protected boolean flushPending;
        protected int logLevel = 7;
        protected boolean autoReconnect = true;
        protected boolean onMainThread = true;

        ConversationClientConfig() {
        }

        public Context getContext() {
            return this.context;
        }

        public String getEnvironmentHost() {
            return this.environmentHost;
        }

        public boolean isEnableCrashReporting() {
            return this.enableCrashReporting;
        }

        public String getImageProcessingServiceUrl() {
            return this.imageProcessingServiceUrl;
        }

        public String getEndpointPath() {
            return this.endpointPath;
        }

        public boolean isFlushPending() {
            return this.flushPending;
        }

        public boolean isAutoReconnect() {
            return this.autoReconnect;
        }

        public boolean isOnMainThread() {
            return this.onMainThread;
        }
    }

    public static class IPSHeader {
        private String key;
        private String value;

        public IPSHeader(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

