/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.content.Context;
import android.database.Cursor;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.nexmo.sdk.conversation.client.ConversationSignalingChannel;
import com.nexmo.sdk.conversation.client.DeliveredReceipt;
import com.nexmo.sdk.conversation.client.Event;
import com.nexmo.sdk.conversation.client.EventSource;
import com.nexmo.sdk.conversation.client.Image;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.SeenReceipt;
import com.nexmo.sdk.conversation.client.SocketEventNotifier;
import com.nexmo.sdk.conversation.client.Text;
import com.nexmo.sdk.conversation.client.User;
import com.nexmo.sdk.conversation.client.audio.AppRTCAudioManager;
import com.nexmo.sdk.conversation.client.audio.AudioCallEventListener;
import com.nexmo.sdk.conversation.client.audio.AudioCallManager;
import com.nexmo.sdk.conversation.client.event.EventType;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.client.event.container.Invitation;
import com.nexmo.sdk.conversation.client.event.container.Receipt;
import com.nexmo.sdk.conversation.core.networking.ImageUploader;
import com.nexmo.sdk.conversation.core.util.DateUtil;
import com.nexmo.sdk.conversation.core.util.Log;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Conversation {
    private static final String TAG = Conversation.class.getSimpleName();
    private long typingTimeOutLength = 1000L;
    private List<Member> members = Collections.synchronizedList(new ArrayList());
    private List<Event> events = Collections.synchronizedList(new ArrayList());
    private Member self;
    private String displayName;
    private Date creationDate;
    private String conversationId;
    private String lastEventId;
    private ConversationSignalingChannel conversationSignalingChannel;
    private SocketEventNotifier socketEventNotifier;
    private boolean isDirty = false;
    private AudioCallManager audioCallManager;
    private boolean isTypingOn = false;
    private boolean isTypingOff = false;
    @NonNull
    private Handler typingHandler;
    private Runnable onTypingOnTimeout = new Runnable(){

        @Override
        public void run() {
            if (!Conversation.this.isTypingOn) {
                return;
            }
            Conversation.this.isTypingOn = false;
        }
    };
    private Runnable onTypingOffTimeout = new Runnable(){

        @Override
        public void run() {
            if (!Conversation.this.isTypingOff) {
                return;
            }
            Conversation.this.isTypingOff = false;
        }
    };

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName) {
        this.displayName = displayName;
        this.createTypingThreads();
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid) {
        this(displayName);
        this.conversationId = cid;
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid, String lastEventId) {
        this(displayName, cid);
        this.lastEventId = lastEventId;
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid, Member member) {
        this(displayName, cid);
        if (member != null) {
            this.setSelf(member);
        }
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid, Member member, Date creationDate) {
        this(displayName, cid, member);
        this.creationDate = creationDate;
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String name, String cid, String lastEventId, Member member) {
        this(name, cid, lastEventId);
        if (member != null) {
            this.setSelf(member);
        }
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid, String lastEventId, Member member, Date creationDate, List<Member> members) {
        this(displayName, cid, lastEventId, member, creationDate);
        this.members = members;
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String name, String cid, String lastEventId, Date creationDate) {
        this(name, cid, lastEventId);
        this.creationDate = creationDate;
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid, String lastEventId, Member member, Date creationDate) {
        this(displayName, cid, lastEventId, member);
        this.creationDate = creationDate;
    }

    @VisibleForTesting(otherwise=4)
    protected Conversation(String displayName, String cid, String lastEventId, Member member, Date creationDate, List<Member> members, List<Event> events) {
        this(displayName, cid, lastEventId, member, creationDate, members);
        this.events = events;
    }

    @VisibleForTesting(otherwise=4)
    protected void setTypingTimeOutLength(long typingTimeOutLength) {
        this.typingTimeOutLength = typingTimeOutLength;
    }

    protected Conversation(Conversation conversation) {
        this(conversation.getDisplayName(), conversation.getConversationId(), conversation.getLastEventId(), conversation.getSelf(), conversation.getCreationDate());
    }

    public void update(RequestHandler<Conversation> requestHandler) {
        if (!this.conversationSignalingChannel.isValidInput(requestHandler, this.conversationId)) {
            return;
        }
        this.conversationSignalingChannel.getConversation(this, requestHandler);
    }

    public void updateEvents(String startId, String endId, RequestHandler<Conversation> requestHandler) {
        if (!this.conversationSignalingChannel.isValidInput(requestHandler, this.conversationId)) {
            return;
        }
        if (this.members.size() != 0) {
            Log.d(TAG, this.members.toString());
        }
        if (this.members.size() == 0) {
            this.conversationSignalingChannel.getMembersBeforeGetEvents(this, startId, endId, requestHandler);
        } else {
            this.conversationSignalingChannel.getEvents(this, startId, endId, requestHandler);
        }
    }

    public void join(RequestHandler<Member> requestHandler) {
        if (!this.conversationSignalingChannel.isValidInput(requestHandler, this.conversationId)) {
            return;
        }
        this.conversationSignalingChannel.joinConversation(this.conversationId, this.displayName, this.self != null ? this.self.getMemberId() : null, requestHandler);
    }

    private void joinWithAudio(final RequestHandler<Member> requestHandler) {
        if (!this.conversationSignalingChannel.isValidInput(requestHandler, this.conversationId)) {
            return;
        }
        this.join(new RequestHandler<Member>(){

            @Override
            public void onError(NexmoAPIError apiError) {
            }

            @Override
            public void onSuccess(Member result) {
                final AudioCallEventListener audioCallEventListener = new AudioCallEventListener(){

                    @Override
                    public void onRinging() {
                    }

                    @Override
                    public void onCallConnected() {
                    }

                    @Override
                    public void onCallEnded() {
                    }

                    @Override
                    public void onGeneralCallError(NexmoAPIError apiError) {
                    }

                    @Override
                    public void onAudioRouteChange(AppRTCAudioManager.AudioDevice device) {
                    }
                };
                requestHandler.onSuccess(result);
                Context context = Conversation.this.getSignallingChannel().socketClient.getConversationClient().getContext();
                Handler handler = new Handler(context.getMainLooper());
                Runnable runAudioCall = new Runnable(){

                    @Override
                    public void run() {
                        Conversation.this.audio().enable(audioCallEventListener);
                    }
                };
                handler.post(runAudioCall);
            }
        });
    }

    public void join(String username, RequestHandler<Member> requestHandler) {
        if (!this.conversationSignalingChannel.isValidInput(requestHandler, this.conversationId)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)username)) {
            String memberId = this.containsMember(username);
            if (!TextUtils.isEmpty((CharSequence)memberId)) {
                this.conversationSignalingChannel.joinConversation(this.conversationId, this.displayName, memberId, requestHandler);
            } else {
                this.conversationSignalingChannel.joinUserToConversation(this.conversationId, this.displayName, username, requestHandler);
            }
        } else {
            requestHandler.onError(new NexmoAPIError("missing-params", this.conversationId, "User name cannot be empty when joining a conversation."));
        }
    }

    public void invite(String username, RequestHandler<Member> inviteSendListener) {
        if (!this.conversationSignalingChannel.isValidInput(inviteSendListener, this.conversationId)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)username)) {
            inviteSendListener.onError(new NexmoAPIError("missing-params", this.conversationId, "This invite cannot be sent to empty username"));
        } else {
            this.conversationSignalingChannel.invite(this.conversationId, username, inviteSendListener);
        }
    }

    public void inviteWithAudio(String userId, String username, boolean muted, boolean isEarmuff, RequestHandler<Member> requestHandler) {
        if (!this.conversationSignalingChannel.isValidInput(requestHandler, this.conversationId)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)username) && TextUtils.isEmpty((CharSequence)userId)) {
            requestHandler.onError(new NexmoAPIError("missing-params", this.conversationId, "This invite cannot be sent with an empty user"));
        } else {
            this.conversationSignalingChannel.inviteWithAudio(this, userId, username, muted, isEarmuff, requestHandler);
        }
    }

    public void leave(RequestHandler<Void> leaveListener) {
        if (!this.conversationSignalingChannel.isValidInput(leaveListener, this.conversationId)) {
            return;
        }
        this.conversationSignalingChannel.leaveConversation(this, this.self, leaveListener);
    }

    public void startTyping(RequestHandler<Member.TYPING_INDICATOR> listener) {
        if (!this.isTypingOn) {
            this.isTypingOn = true;
            this.isTypingOff = false;
            this.sendTyping(Member.TYPING_INDICATOR.ON, listener);
        }
        this.postRunnables(true);
    }

    public void stopTyping(RequestHandler<Member.TYPING_INDICATOR> listener) {
        if (!this.isTypingOff) {
            this.isTypingOff = true;
            this.isTypingOn = false;
            this.sendTyping(Member.TYPING_INDICATOR.OFF, listener);
        }
        this.postRunnables(false);
    }

    public void sendText(String message, RequestHandler<Event> listener) {
        if (listener == null) {
            Log.d(TAG, "Listener is mandatory");
        } else if (this.getSelf() == null) {
            listener.onError(NexmoAPIError.noUserLoggedInForConversation(this.getConversationId()));
        } else {
            this.conversationSignalingChannel.sendText(this, message, listener);
        }
    }

    public void setAudioRoute(AppRTCAudioManager.AudioDevice audioRoute) {
        this.audioCallManager.setAudioRoute(audioRoute);
    }

    public ImageUploader.CancelableCall sendImage(String imagePath, RequestHandler<Event> imageSendListener) {
        boolean isPermissionGranted;
        if (!this.conversationSignalingChannel.isValidInput(imageSendListener, this.conversationId)) {
            return null;
        }
        Context context = this.conversationSignalingChannel.getConversationClient().getContext();
        boolean bl = isPermissionGranted = context == null || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        if (TextUtils.isEmpty((CharSequence)imagePath)) {
            imageSendListener.onError(new NexmoAPIError("missing-params", this.conversationId, "No imagePath was provided"));
        } else if (!isPermissionGranted) {
            imageSendListener.onError(NexmoAPIError.permissionRequired(this.conversationId));
        } else {
            File file = new File(imagePath);
            if (!file.exists()) {
                imageSendListener.onError(new NexmoAPIError("invalid-params", this.conversationId, "Image file doesn't exist"));
            } else if (file.length() > 0xF00000L) {
                imageSendListener.onError(new NexmoAPIError("image:upload-failure", this.conversationId, "Image is too big, it should be 15mb max"));
            } else {
                return this.conversationSignalingChannel.sendImage(this, imagePath, imageSendListener);
            }
        }
        return null;
    }

    public void deleteEvent(Event event, RequestHandler<Void> eventDeleteListener) {
        if (!this.conversationSignalingChannel.isValidInput(eventDeleteListener, this.conversationId)) {
            return;
        }
        if (event.getDeletedTimestamp() != null) {
            eventDeleteListener.onError(new NexmoAPIError("invalid-action", this.conversationId, "This message was already deleted"));
        } else {
            this.conversationSignalingChannel.deleteEvent(this, event, eventDeleteListener);
        }
    }

    private <T> EventSource<T> getEventSource(String eventType) {
        return this.conversationSignalingChannel.getConversationClient().getEventSource(eventType + "-" + this.conversationId);
    }

    public EventSource<Member> memberJoinedEvent() {
        return this.getEventSource("memberJoinedEvent");
    }

    public EventSource<Invitation> memberInvitedEvent() {
        return this.getEventSource("memberInvitedEvent");
    }

    public EventSource<Member> memberLeftEvent() {
        return this.getEventSource("memberLeftEvent");
    }

    public EventSource<Member> typingEvent() {
        return this.getEventSource("typingEvent");
    }

    public EventSource<Event> messageEvent() {
        return this.getEventSource("messageEvent");
    }

    public EventSource<Receipt<SeenReceipt>> seenEvent() {
        return this.getEventSource("seenEvent");
    }

    public EventSource<Receipt<DeliveredReceipt>> deliveryEvent() {
        return this.getEventSource("deliveryEvent");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getMemberId() {
        return this.self != null ? this.self.getMemberId() : null;
    }

    public Member getMember(String member_id) {
        for (Member member : this.members) {
            if (!TextUtils.equals((CharSequence)member.getMemberId(), (CharSequence)member_id)) continue;
            return member;
        }
        return null;
    }

    public Member getMember(User user) {
        for (Member member : this.members) {
            if (!TextUtils.equals((CharSequence)member.getUserId(), (CharSequence)user.getUserId())) continue;
            return member;
        }
        return null;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(Member member) {
        List<Member> list = this.members;
        synchronized (list) {
            for (int i = 0; i < this.members.size(); ++i) {
                if (!TextUtils.equals((CharSequence)this.members.get(i).getMemberId(), (CharSequence)member.getMemberId())) continue;
                this.members.set(i, member);
                return;
            }
            this.members.add(member);
        }
    }

    public Member getSelf() {
        return this.self;
    }

    boolean isSelf(Member member) {
        return this.getSelf() != null && this.getSelf().getMemberId().equals(member.getMemberId());
    }

    public Event getEvent(String event_id) {
        for (Event event : this.events) {
            if (!TextUtils.equals((CharSequence)event.getId(), (CharSequence)event_id)) continue;
            return event;
        }
        return null;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public Text findText(String id) {
        return (Text)this.findEvent(id);
    }

    public Image findImage(String id) {
        return (Image)this.findEvent(id);
    }

    public List<Image> getImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        for (Event event : this.events) {
            if (event.getType() != EventType.IMAGE) continue;
            images.add((Image)event);
        }
        return images;
    }

    public List<Text> getTexts() {
        ArrayList<Text> texts = new ArrayList<Text>();
        for (Event event : this.events) {
            if (event.getType() != EventType.TEXT) continue;
            texts.add((Text)event);
        }
        return texts;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getLastEventId() {
        return this.lastEventId;
    }

    public AudioCallManager media(MEDIA_TYPE mediaType) {
        switch (mediaType) {
            case AUDIO: {
                return this.audio();
            }
        }
        return this.audio();
    }

    private AudioCallManager audio() {
        if (this.audioCallManager == null) {
            Context context = this.conversationSignalingChannel.getConversationClient().getContext();
            this.audioCallManager = new AudioCallManager(context, this.getConversationId(), this.getMemberId(), this.conversationSignalingChannel);
            this.getSignallingChannel().socketClient.setRtcEventsListener(this.audioCallManager);
        }
        return this.audioCallManager;
    }

    boolean isAudioEnabled() {
        return this.audioCallManager != null && this.audio().getState() != AudioCallManager.AudioCallState.ReadyForCall;
    }

    public static Conversation fromJson(JSONObject body) throws JSONException {
        String cname = body.has("display_name") ? body.getString("display_name") : body.getString("name");
        String cid = body.getString("id");
        String lastEventId = body.getString("sequence_number");
        String memberId = body.optString("member_id");
        String userId = body.optString("user_id");
        String userName = body.optString("user_name");
        String memberState = body.optString("state");
        JSONObject dateBody = body.optJSONObject("timestamp");
        Date timestamp = null;
        if (dateBody != null) {
            timestamp = DateUtil.parseDateFromJson(dateBody, "created");
        }
        if (TextUtils.isEmpty((CharSequence)memberId)) {
            return new Conversation(cname, cid, lastEventId, timestamp);
        }
        Member member = new Member(userId, userName, memberId, Member.STATE.fromId(memberState));
        Conversation conversation = new Conversation(cname, cid, lastEventId, member, timestamp);
        member.setConversation(conversation);
        return conversation;
    }

    public static Conversation fromCursor(Cursor cursor) {
        Date dateCreated;
        if (cursor == null) {
            return null;
        }
        Member self = Member.fromCursor(cursor);
        try {
            dateCreated = DateUtil.formatIso8601DateString(cursor.getString(cursor.getColumnIndex("created")));
        }
        catch (ParseException e) {
            dateCreated = null;
            Log.d(TAG, "getConversationsList: wrong date format");
        }
        String cid = cursor.getString(cursor.getColumnIndex("cid"));
        return new Conversation(cursor.getString(cursor.getColumnIndex("name")), cid, cursor.getString(cursor.getColumnIndex("lastEventId")), self, dateCreated);
    }

    public String toString() {
        return TAG + " cid: " + (this.conversationId != null ? this.conversationId : "") + " .display_name: " + (this.displayName != null ? this.displayName : "") + " .lastEventId: " + (this.lastEventId != null ? this.lastEventId : "") + " .member: " + (this.getSelf() != null ? this.getSelf() : "") + " .creation_time: " + (this.creationDate != null ? this.creationDate : "") + " .members:" + (this.members != null ? this.members.toString() : "") + " .events:" + (this.events != null ? this.events.toString() : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Conversation)) {
            return false;
        }
        Conversation that = (Conversation)o;
        if (this.members != null ? !this.members.equals(that.members) : that.members != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        if (this.self != null ? !this.self.equals(that.self) : that.self != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) {
            return false;
        }
        if (this.conversationId != null ? !this.conversationId.equals(that.conversationId) : that.conversationId != null) {
            return false;
        }
        return this.lastEventId != null ? this.lastEventId.equals(that.lastEventId) : that.lastEventId == null;
    }

    public int hashCode() {
        int result = this.members != null ? this.members.hashCode() : 0;
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.self != null ? this.self.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + this.conversationId.hashCode();
        result = 31 * result + (this.lastEventId != null ? this.lastEventId.hashCode() : 0);
        return result;
    }

    @VisibleForTesting(otherwise=3)
    void setConversationSignalingChannel(ConversationSignalingChannel csc) {
        this.conversationSignalingChannel = csc;
    }

    @VisibleForTesting(otherwise=3)
    void setSocketEventNotifier(SocketEventNotifier sen) {
        this.socketEventNotifier = sen;
    }

    @VisibleForTesting(otherwise=3)
    void setMembers(List<Member> members) {
        this.members = members;
    }

    @VisibleForTesting(otherwise=3)
    void setEvents(List<Event> events) {
        this.events = events;
        if (!events.isEmpty()) {
            this.updateLastEventId(events.get(events.size() - 1).getId());
        }
    }

    void addEvent(Event event) {
        this.events.add(event);
        this.lastEventId = event.getId();
    }

    void setSelf(Member self) {
        this.self = self;
        if (self != null) {
            this.addMember(self);
        }
    }

    void updateLastEventId(String lastEventId) {
        this.lastEventId = lastEventId;
    }

    void updateBasicDetails(Conversation conversation) {
        this.lastEventId = conversation.getLastEventId();
        this.creationDate = conversation.getCreationDate();
        this.displayName = conversation.getDisplayName();
        this.members = conversation.getMembers();
    }

    boolean containsEvent(Event event) {
        for (Event message : this.events) {
            if (!TextUtils.equals((CharSequence)event.getId(), (CharSequence)message.getId())) continue;
            return true;
        }
        return false;
    }

    String containsMember(String username) {
        for (Member member : this.members) {
            if (!TextUtils.equals((CharSequence)member.getName(), (CharSequence)username)) continue;
            return member.getMemberId();
        }
        return null;
    }

    Event findEvent(String eventId) {
        for (Event event : this.events) {
            if (!TextUtils.equals((CharSequence)event.getId(), (CharSequence)eventId)) continue;
            return event;
        }
        return null;
    }

    ConversationSignalingChannel getSignallingChannel() {
        return this.conversationSignalingChannel;
    }

    SocketEventNotifier getSocketEventNotifier() {
        return this.socketEventNotifier;
    }

    String getLastMessageEventId() {
        if (this.events.size() == 0) {
            return null;
        }
        int maxId = 0;
        for (Event event : this.events) {
            maxId = Math.max(maxId, Integer.valueOf(event.getId()));
        }
        return String.valueOf(maxId);
    }

    void markAsDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    private void sendTyping(Member.TYPING_INDICATOR indicator, RequestHandler<Member.TYPING_INDICATOR> listener) {
        if (this.conversationSignalingChannel.isValidInput(listener, this.conversationId)) {
            this.conversationSignalingChannel.sendTypingIndicator(this, indicator, listener);
        }
    }

    void updateRtcId(String rtcId) {
        this.audio().updateRtcId(rtcId);
    }

    void recycleEventBitmaps() {
        for (Event event : this.events) {
            if (event.getType() != EventType.IMAGE) continue;
            ((Image)event).recycleBitmaps();
        }
    }

    private void createTypingThreads() {
        HandlerThread handlerThread = new HandlerThread("typingHandler");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        this.typingHandler = new Handler(looper);
    }

    private void postRunnables(boolean isStart) {
        if (isStart) {
            if (this.typingHandler != null) {
                this.typingHandler.removeCallbacks(this.onTypingOnTimeout);
                this.typingHandler.postDelayed(this.onTypingOnTimeout, this.typingTimeOutLength);
            }
        } else if (this.typingHandler != null) {
            this.typingHandler.removeCallbacks(this.onTypingOffTimeout);
            this.typingHandler.postDelayed(this.onTypingOffTimeout, this.typingTimeOutLength);
        }
    }

    public static enum MEDIA_TYPE {
        AUDIO;

    }
}

