/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.support.annotation.VisibleForTesting;
import com.nexmo.sdk.conversation.client.CallEvent;
import com.nexmo.sdk.conversation.client.Conversation;
import com.nexmo.sdk.conversation.client.EventSource;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.client.audio.AppRTCAudioManager;
import com.nexmo.sdk.conversation.client.audio.AudioCallEventListener;
import com.nexmo.sdk.conversation.client.audio.AudioCallManager;
import com.nexmo.sdk.conversation.client.event.NexmoAPIError;
import com.nexmo.sdk.conversation.client.event.RequestHandler;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.List;

public class Call {
    private static final String TAG = Call.class.getSimpleName();
    private Conversation conversation;
    private String from;

    @VisibleForTesting(otherwise=4)
    protected Call(Conversation conversation) {
        this.conversation = conversation;
    }

    @VisibleForTesting(otherwise=4)
    protected Call(Conversation conversation, String from) {
        this.conversation = conversation;
        this.from = from;
    }

    public String getName() {
        return this.conversation.getDisplayName();
    }

    public final Conversation getConversation() {
        return this.conversation;
    }

    public final List<Member> to() {
        return this.conversation.getMembers();
    }

    public String from() {
        return this.from;
    }

    public void answer(final RequestHandler<Void> listener) {
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.conversation.isAudioEnabled()) {
            listener.onError(NexmoAPIError.audioAlreadyInProgress());
        } else {
            this.conversation.join(new RequestHandler<Member>(){

                @Override
                public void onError(NexmoAPIError apiError) {
                    listener.onError(apiError);
                }

                @Override
                public void onSuccess(Member result) {
                    Call.this.conversation.media(Conversation.MEDIA_TYPE.AUDIO).enable(new AudioCallEventListener(){

                        @Override
                        public void onRinging() {
                        }

                        @Override
                        public void onCallConnected() {
                            listener.onSuccess(null);
                        }

                        @Override
                        public void onCallEnded() {
                        }

                        @Override
                        public void onGeneralCallError(NexmoAPIError apiError) {
                            listener.onError(apiError);
                        }

                        @Override
                        public void onAudioRouteChange(AppRTCAudioManager.AudioDevice device) {
                        }
                    });
                }
            });
        }
    }

    public void hangup(final RequestHandler<Void> listener) {
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        this.conversation.media(Conversation.MEDIA_TYPE.AUDIO).disable(new RequestHandler<Void>(){

            @Override
            public void onError(NexmoAPIError apiError) {
                listener.onError(apiError);
            }

            @Override
            public void onSuccess(Void result) {
                if (Call.this.conversation.getMembers().size() == 1) {
                    Call.this.conversation.getMembers().get(0).kick(listener);
                } else {
                    listener.onSuccess(null);
                }
            }
        });
    }

    public void reject(RequestHandler<Void> listener) {
        if (listener == null) {
            Log.e(TAG, "Listener must be provided");
            return;
        }
        if (this.conversation.media(Conversation.MEDIA_TYPE.AUDIO).getState() != AudioCallManager.AudioCallState.ReadyForCall) {
            listener.onError(NexmoAPIError.audioAlreadyInProgress());
            return;
        }
        this.conversation.leave(listener);
    }

    public EventSource<CallEvent> event() {
        return this.conversation.getSignallingChannel().getConversationClient().getEventSource("callEvent-" + this.conversation.getConversationId());
    }

    public String toString() {
        return TAG + " display_name: " + this.conversation.getDisplayName() + " .from: " + this.from() + " .to: " + this.to().toString();
    }

    public static enum MEMBER_CALL_STATE {
        HUNGUP,
        ANSWERED,
        REJECTED;

    }
}

