/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.sdk.conversation.client;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import com.nexmo.sdk.conversation.client.Member;
import com.nexmo.sdk.conversation.core.persistence.repository.ConversationRepository;
import com.nexmo.sdk.conversation.core.persistence.repository.EventRepository;
import com.nexmo.sdk.conversation.core.persistence.repository.MemberRepository;
import com.nexmo.sdk.conversation.core.util.Log;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheDB
extends SQLiteOpenHelper {
    public static final String TAG = CacheDB.class.getSimpleName();
    private static CacheDB instance;
    private static SQLiteDatabase sDatabase;
    private AtomicInteger mOpenCounter = new AtomicInteger();
    private static final int DATABASE_VERSION = 3;
    private static final String DATABASE_NAME = "ConversationCache.db";
    private static final String TEXT_TYPE = " TEXT";
    private static final String DATE_TYPE = " TIMESTAMP";
    private static final String COMMA_SEP = ",";
    private static ConversationRepository conversationRepository;
    private static MemberRepository memberRepository;
    private static EventRepository eventRepository;
    private static final String SQL_CREATE_CONVERSATION_ENTRIES = "CREATE TABLE conversation (cid TEXT PRIMARY KEY,name TEXT,created TIMESTAMP,lastEventId TEXT,selfMemberId TEXT )";
    private static final String SQL_CREATE_MEMBER_ENTRIES = "CREATE TABLE member (id TEXT,username TEXT,user_id TEXT,state TEXT,invited_at TIMESTAMP,joined_at TIMESTAMP,left_at TIMESTAMP,cid TEXT, PRIMARY KEY (id,cid), FOREIGN KEY(cid) REFERENCES conversation(cid) ON DELETE CASCADE );CREATE INDEX idx_member_cid ON member(cid)";
    private static final String SQL_CREATE_MESSAGE_ENTRIES = "CREATE TABLE message (event_id TEXT,conversation_id TEXT,message_type TEXT,text TEXT,member_id TEXT,timestamp TIMESTAMP,deleted_timestamp TIMESTAMP,image_representations TEXT,delivered_receipts TEXT,seen_receipts TEXT,audio_enabled INT ,  PRIMARY KEY (event_id,conversation_id), FOREIGN KEY(member_id,conversation_id) REFERENCES member(id,cid) ON DELETE CASCADE );CREATE INDEX idx_message_cid ON message(conversation_id)";
    private static final String SQL_DELETE_CONVERSATION_ENTRIES = "DROP TABLE IF EXISTS conversation";
    private static final String SQL_DELETE_MEMBER_ENTRIES = "DROP TABLE IF EXISTS member";
    private static final String SQL_DELETE_MESSAGE_ENTRIES = "DROP TABLE IF EXISTS message";

    static synchronized void initializeCacheDBInstance(Context context) {
        if (instance == null) {
            instance = new CacheDB(context);
            CacheDB.initializeRepositories();
        }
    }

    static synchronized CacheDB getCacheDBInstance() {
        return instance;
    }

    public synchronized SQLiteDatabase openDatabase() {
        if (this.mOpenCounter.incrementAndGet() == 1 || sDatabase == null) {
            sDatabase = instance.getWritableDatabase();
        }
        return sDatabase;
    }

    synchronized void closeDatabase() {
        if (this.mOpenCounter.decrementAndGet() >= 0) {
            this.mOpenCounter.set(0);
            sDatabase.close();
            sDatabase = null;
        }
    }

    private CacheDB(Context context) {
        super(context, DATABASE_NAME, null, 3);
    }

    private static void initializeRepositories() {
        conversationRepository = new ConversationRepository(CacheDB.getCacheDBInstance());
        memberRepository = new MemberRepository(CacheDB.getCacheDBInstance());
        eventRepository = new EventRepository(CacheDB.getCacheDBInstance());
    }

    public void onCreate(SQLiteDatabase db) {
        Log.d(TAG, "ConversationCache.db onCreate");
        db.execSQL(SQL_CREATE_CONVERSATION_ENTRIES);
        db.execSQL(SQL_CREATE_MEMBER_ENTRIES);
        db.execSQL(SQL_CREATE_MESSAGE_ENTRIES);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.d(TAG, "ConversationCache.db onUpgrade Old version: " + oldVersion + " to new version: " + newVersion);
        switch (oldVersion) {
            default: 
        }
        db.execSQL(SQL_DELETE_CONVERSATION_ENTRIES);
        db.execSQL(SQL_DELETE_MEMBER_ENTRIES);
        db.execSQL(SQL_DELETE_MESSAGE_ENTRIES);
        this.onCreate(db);
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (!db.isReadOnly()) {
            this.setForeignKeyConstraintsEnabled(db);
        }
    }

    void setForeignKeyConstraintsEnabled(SQLiteDatabase db) {
        if (Build.VERSION.SDK_INT < 16) {
            db.execSQL("PRAGMA foreign_keys=ON;");
        } else {
            this.setForeignKeyConstraintsEnabledPostJellyBean(db);
        }
    }

    @TargetApi(value=16)
    private void setForeignKeyConstraintsEnabledPostJellyBean(SQLiteDatabase db) {
        db.setForeignKeyConstraintsEnabled(true);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
        Log.d(TAG, "ConversationCache.db onDowngrade from new version: " + newVersion + " to Old version: " + oldVersion);
    }

    boolean tableContainsRows(String tableName) {
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)CacheDB.getCacheDBInstance().openDatabase(), (String)tableName);
        Log.d(TAG, "tableContainsRows. tableName: " + tableName + " .count: " + count);
        return count > 0L;
    }

    MemberRepository getMemberRepository() {
        return memberRepository;
    }

    EventRepository getEventRepository() {
        return eventRepository;
    }

    ConversationRepository getConversationRepository() {
        return conversationRepository;
    }

    void updateMembersForConversations(Map<String, List<Member>> conversationMembersMap) {
        for (Map.Entry<String, List<Member>> entry : conversationMembersMap.entrySet()) {
            memberRepository.insertAll(entry.getKey(), entry.getValue());
        }
    }

    void clearDb() {
        SQLiteDatabase db = CacheDB.getCacheDBInstance().openDatabase();
        db.execSQL("delete from conversation");
        db.execSQL("delete from member");
        db.execSQL("delete from message");
    }

    private void dropDB() {
        Log.d(TAG, "dropDB");
        SQLiteDatabase db = CacheDB.getCacheDBInstance().openDatabase();
        db.execSQL(SQL_DELETE_CONVERSATION_ENTRIES);
        db.execSQL(SQL_DELETE_MEMBER_ENTRIES);
        db.execSQL(SQL_DELETE_MESSAGE_ENTRIES);
        CacheDB.getCacheDBInstance().closeDatabase();
    }
}

