/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.nexmo.client.NexmoResponseParseException;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.verify.SearchVerifyResponseDeserializer;
import com.nexmo.client.verify.VerifyDetails;
import com.nexmo.client.verify.VerifyStatus;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchVerifyResponse {
    private VerifyStatus status;
    private List<VerifyDetails> verificationRequests = new ArrayList<VerifyDetails>();
    private String errorText;

    @JsonCreator
    SearchVerifyResponse() {
        this.status = VerifyStatus.OK;
    }

    SearchVerifyResponse(List<VerifyDetails> verificationRequests) {
        this.status = VerifyStatus.OK;
        this.verificationRequests = verificationRequests;
    }

    SearchVerifyResponse(VerifyStatus status, String errorText) {
        this.status = status;
        this.errorText = errorText;
    }

    public VerifyStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="verification_requests")
    public List<VerifyDetails> getVerificationRequests() {
        return this.verificationRequests;
    }

    @JsonProperty(value="error_text")
    public String getErrorText() {
        return this.errorText;
    }

    public static SearchVerifyResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            SimpleModule module = new SimpleModule();
            module.addDeserializer(SearchVerifyResponse.class, (JsonDeserializer)new SearchVerifyResponseDeserializer());
            mapper.registerModule((Module)module);
            return (SearchVerifyResponse)mapper.readValue(json, SearchVerifyResponse.class);
        }
        catch (JsonMappingException jme) {
            throw new NexmoResponseParseException("Failed to produce SearchVerifyResponse from json.", jme);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce SearchVerifyResponse from json.", jpe);
        }
    }
}

