/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.voice.endpoints;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.JWTAuthMethod;
import com.nexmo.client.voice.Call;
import com.nexmo.client.voice.CallEvent;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;

public class CreateCallMethod
extends AbstractMethod<Call, CallEvent> {
    private static final Log LOG = LogFactory.getLog(CreateCallMethod.class);
    private static final String DEFAULT_URI = "https://api.nexmo.com/v1/calls";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{JWTAuthMethod.class};
    private String uri = "https://api.nexmo.com/v1/calls";

    public CreateCallMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(Call request) throws NexmoClientException, UnsupportedEncodingException {
        return RequestBuilder.post((String)this.uri).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(request.toJson()));
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public CallEvent parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return CallEvent.fromJson(json);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

