/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.verify;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.verify.CheckMethod;
import com.nexmo.client.verify.CheckRequest;
import com.nexmo.client.verify.CheckResponse;
import com.nexmo.client.verify.CheckResult;
import java.io.IOException;

class CheckEndpoint {
    private CheckMethod checkMethod;

    CheckEndpoint(HttpWrapper httpWrapper) {
        this.checkMethod = new CheckMethod(httpWrapper);
    }

    CheckResult check(String requestId, String code, String ipAddress) throws IOException, NexmoClientException {
        return this.check(new CheckRequest(requestId, code, ipAddress));
    }

    CheckResult check(String requestId, String code) throws IOException, NexmoClientException {
        return this.check(new CheckRequest(requestId, code));
    }

    private CheckResult check(CheckRequest request) throws IOException, NexmoClientException {
        return this.translateFromCheckResponse((CheckResponse)this.checkMethod.execute(request));
    }

    private CheckResult translateFromCheckResponse(CheckResponse response) {
        return new CheckResult(response.getStatus() != null ? response.getStatus().getVerifyStatus() : Integer.MAX_VALUE, response.getRequestId(), response.getEventId(), response.getPrice() != null ? response.getPrice().floatValue() : 0.0f, response.getCurrency(), response.getErrorText(), response.getStatus() != null && response.getStatus().isTemporaryError());
    }
}

