/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.numbers;

import com.nexmo.client.HttpWrapper;
import com.nexmo.client.NexmoClientException;
import com.nexmo.client.auth.TokenAuthMethod;
import com.nexmo.client.numbers.ListNumbersFilter;
import com.nexmo.client.numbers.ListNumbersResponse;
import com.nexmo.client.voice.endpoints.AbstractMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class ListNumbersEndpoint
extends AbstractMethod<ListNumbersFilter, ListNumbersResponse> {
    private static final String DEFAULT_URI = "https://rest.nexmo.com/account/numbers";
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private String uri = "https://rest.nexmo.com/account/numbers";

    public ListNumbersEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(ListNumbersFilter request) throws NexmoClientException, UnsupportedEncodingException {
        RequestBuilder requestBuilder = RequestBuilder.get().setUri(this.uri);
        request.addParams(requestBuilder);
        return requestBuilder;
    }

    @Override
    public ListNumbersResponse parseResponse(HttpResponse response) throws IOException {
        String json = new BasicResponseHandler().handleResponse(response);
        return ListNumbersResponse.fromJson(json);
    }

    public ListNumbersResponse listNumbers(ListNumbersFilter request) throws IOException, NexmoClientException {
        return (ListNumbersResponse)this.execute(request);
    }
}

