/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight.advanced;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.insight.CallerType;
import com.nexmo.client.insight.RoamingDetails;
import com.nexmo.client.insight.standard.StandardInsightResponse;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AdvancedInsightResponse
extends StandardInsightResponse {
    private Validity validNumber;
    private Reachability reachability;
    private PortedStatus ported;
    private Integer lookupOutcome;
    private String lookupOutcomeMessage;
    private RoamingDetails roaming;
    private String callerName;
    private String firstName;
    private String lastName;
    private CallerType callerType;

    public static AdvancedInsightResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (AdvancedInsightResponse)mapper.readValue(json, AdvancedInsightResponse.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce AdvancedInsightResponse from json.", jpe);
        }
    }

    @JsonProperty(value="valid_number")
    public Validity getValidNumber() {
        return this.validNumber;
    }

    @JsonProperty(value="reachable")
    public Reachability getReachability() {
        return this.reachability;
    }

    public PortedStatus getPorted() {
        return this.ported;
    }

    @JsonProperty(value="lookup_outcome")
    public Integer getLookupOutcome() {
        return this.lookupOutcome;
    }

    @JsonProperty(value="lookup_outcome_message")
    public String getLookupOutcomeMessage() {
        return this.lookupOutcomeMessage;
    }

    public RoamingDetails getRoaming() {
        return this.roaming;
    }

    @Override
    @JsonProperty(value="caller_name")
    public String getCallerName() {
        return this.callerName;
    }

    @Override
    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    @Override
    @JsonProperty(value="caller_type")
    public CallerType getCallerType() {
        return this.callerType;
    }

    public static enum Reachability {
        UNKNOWN,
        REACHABLE,
        UNDELIVERABLE,
        ABSENT,
        BAD_NUMBER,
        BLACKLISTED;


        @JsonCreator
        public static Reachability fromString(String name) {
            return Reachability.valueOf(name.toUpperCase());
        }
    }

    public static enum Validity {
        UNKNOWN,
        VALID,
        NOT_VALID;


        @JsonCreator
        public static Validity fromString(String name) {
            return Validity.valueOf(name.toUpperCase());
        }
    }

    public static enum PortedStatus {
        UNKNOWN,
        PORTED,
        NOT_PORTED,
        ASSUMED_NOT_PORTED,
        ASSUMED_PORTED;


        @JsonCreator
        public static PortedStatus fromString(String name) {
            return PortedStatus.valueOf(name.toUpperCase());
        }
    }
}

