/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.auth;

import com.nexmo.client.auth.AbstractAuthMethod;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.message.BasicHeader;

public class TokenAuthMethod
extends AbstractAuthMethod {
    private final int SORT_KEY = 30;
    private String apiKey;
    private String apiSecret;

    public TokenAuthMethod(String apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        return request.addParameter("api_key", this.apiKey).addParameter("api_secret", this.apiSecret);
    }

    @Override
    public RequestBuilder applyAsBasicAuth(RequestBuilder request) {
        String headerValue = Base64.encodeBase64String((byte[])(this.apiKey + ":" + this.apiSecret).getBytes());
        BasicHeader authHeader = new BasicHeader("Authorization", "Basic " + headerValue);
        return request.addHeader((Header)authHeader);
    }

    @Override
    public int getSortKey() {
        return 30;
    }
}

