/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.auth;

import com.nexmo.client.auth.AuthMethod;
import com.nexmo.client.auth.NexmoAuthException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class NexmoUnacceptableAuthException
extends NexmoAuthException {
    private final Iterable<AuthMethod> availableAuths;
    private final Iterable<Class> acceptableAuthClasses;

    public NexmoUnacceptableAuthException(Collection<AuthMethod> availableAuths, Collection<Class> acceptableAuthClasses) {
        this.availableAuths = new ArrayList<AuthMethod>(availableAuths);
        this.acceptableAuthClasses = new ArrayList<Class>(acceptableAuthClasses);
    }

    @Override
    public String getMessage() {
        return this.generateErrorMessage();
    }

    private String generateErrorMessage() {
        TreeSet<String> availableTypes = new TreeSet<String>();
        for (AuthMethod auth : this.availableAuths) {
            availableTypes.add(auth.getClass().getSimpleName());
        }
        TreeSet<String> acceptableTypes = new TreeSet<String>();
        for (Class klass : this.acceptableAuthClasses) {
            acceptableTypes.add(klass.getSimpleName());
        }
        return String.format("No acceptable authentication type could be found. Acceptable types are: %s. Supplied types were: %s", StringUtils.join(acceptableTypes, (String)", "), StringUtils.join(availableTypes, (String)", "));
    }
}

