/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.applications;

import com.nexmo.client.applications.ApplicationType;
import org.apache.http.client.methods.RequestBuilder;

public class UpdateApplicationRequest {
    private final String applicationId;
    private final String name;
    private final ApplicationType type;
    private final String answerUrl;
    private final String eventUrl;
    private String answerMethod;
    private String eventMethod;

    public UpdateApplicationRequest(String applicationId, String name, String answerUrl, String eventUrl) {
        this(applicationId, name, ApplicationType.VOICE, answerUrl, null, eventUrl, null);
    }

    public UpdateApplicationRequest(String applicationId, String name, ApplicationType type, String answerUrl, String answerMethod, String eventUrl, String eventMethod) {
        this.applicationId = applicationId;
        this.name = name;
        this.type = type;
        this.answerUrl = answerUrl;
        this.eventUrl = eventUrl;
        this.answerMethod = answerMethod;
        this.eventMethod = eventMethod;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public String getAnswerUrl() {
        return this.answerUrl;
    }

    public String getEventUrl() {
        return this.eventUrl;
    }

    public String getAnswerMethod() {
        return this.answerMethod;
    }

    public void setAnswerMethod(String answerMethod) {
        this.answerMethod = answerMethod;
    }

    public String getEventMethod() {
        return this.eventMethod;
    }

    public void setEventMethod(String eventMethod) {
        this.eventMethod = eventMethod;
    }

    public void addParams(RequestBuilder request) {
        request.addParameter("name", this.name).addParameter("type", this.type.toString()).addParameter("answer_url", this.answerUrl).addParameter("event_url", this.eventUrl);
        if (this.eventMethod != null) {
            request.addParameter("event_method", this.eventMethod);
        }
        if (this.answerMethod != null) {
            request.addParameter("answer_method", this.answerMethod);
        }
    }
}

