/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.client.insight.standard;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nexmo.client.NexmoUnexpectedException;
import com.nexmo.client.insight.CallerType;
import com.nexmo.client.insight.CarrierDetails;
import com.nexmo.client.insight.basic.BasicInsightResponse;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StandardInsightResponse
extends BasicInsightResponse {
    private String requestPrice;
    private String remainingBalance;
    private CarrierDetails originalCarrier;
    private CarrierDetails currentCarrier;
    private String callerName;
    private String firstName;
    private String lastName;
    private CallerType callerType;

    public static StandardInsightResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (StandardInsightResponse)mapper.readValue(json, StandardInsightResponse.class);
        }
        catch (IOException jpe) {
            throw new NexmoUnexpectedException("Failed to produce StandardInsightResponse from json.", jpe);
        }
    }

    @JsonProperty(value="request_price")
    public String getRequestPrice() {
        return this.requestPrice;
    }

    @JsonProperty(value="remaining_balance")
    public String getRemainingBalance() {
        return this.remainingBalance;
    }

    @JsonProperty(value="original_carrier")
    public CarrierDetails getOriginalCarrier() {
        return this.originalCarrier;
    }

    @JsonProperty(value="current_carrier")
    public CarrierDetails getCurrentCarrier() {
        return this.currentCarrier;
    }

    @JsonProperty(value="caller_name")
    public String getCallerName() {
        return this.callerName;
    }

    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="caller_type")
    public CallerType getCallerType() {
        return this.callerType;
    }
}

