/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.utils.logger.implementation;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.nexmo.utils.FileUtils;
import com.nexmo.utils.logger.ILogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SimpleLogger
implements ILogger {
    private static final String TAG = SimpleLogger.class.getName();
    private static final String FILE_SIZE_LIMIT = "1024";
    private static final String NUM_OF_FILES_LIMIT = "40";
    private static final String ZIP_EXTENSION = ".zip";
    private static final Object createFileLock = new Object();
    private String appName;
    private String logFilePath;
    private String logFileName;
    private ILogger.eLogLevel logLevel = ILogger.eLogLevel.CRITICAL;
    private long logKey = 0L;

    private boolean isShouldLog(ILogger.eLogLevel level) {
        return level.getValue() <= this.logLevel.getValue();
    }

    @Override
    public void c(String tag, String msg) {
        if (this.isShouldLog(ILogger.eLogLevel.CRITICAL)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey));
        }
    }

    @Override
    public void c(String tag, String msg, Throwable th) {
        if (this.isShouldLog(ILogger.eLogLevel.CRITICAL)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey), (Throwable)th);
        }
    }

    @Override
    public void w(String tag, String msg) {
        if (this.isShouldLog(ILogger.eLogLevel.WARNING)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey));
        }
    }

    @Override
    public void w(String tag, String msg, Throwable th) {
        if (this.isShouldLog(ILogger.eLogLevel.WARNING)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey), (Throwable)th);
        }
    }

    @Override
    public void d(String tag, String msg) {
        if (this.isShouldLog(ILogger.eLogLevel.DEBUG)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey));
        }
    }

    @Override
    public void d(String tag, String msg, Throwable th) {
        if (this.isShouldLog(ILogger.eLogLevel.DEBUG)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey), (Throwable)th);
        }
    }

    @Override
    public void i(String tag, String msg) {
        if (this.isShouldLog(ILogger.eLogLevel.INFO)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey));
        }
    }

    @Override
    public void i(String tag, String msg, Throwable th) {
        if (this.isShouldLog(ILogger.eLogLevel.INFO)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey), (Throwable)th);
        }
    }

    @Override
    public void v(String tag, String msg) {
        if (this.isShouldLog(ILogger.eLogLevel.VERBOSE)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey));
        }
    }

    @Override
    public void v(String tag, String msg, Throwable th) {
        if (this.isShouldLog(ILogger.eLogLevel.VERBOSE)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey), (Throwable)th);
        }
    }

    @Override
    public void s(String tag, String msg) {
        if (this.isShouldLog(ILogger.eLogLevel.SENSITIVE)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey));
        }
    }

    @Override
    public void s(String tag, String msg, Throwable th) {
        if (this.isShouldLog(ILogger.eLogLevel.SENSITIVE)) {
            Log.i((String)this.obfuscate(tag, this.logKey), (String)this.obfuscate(msg, this.logKey), (Throwable)th);
        }
    }

    @Override
    public void setLogLevel(ILogger.eLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void setLogKey(long logKey) {
        this.logKey = logKey;
    }

    @Override
    public void init(String appName) {
        this.init(appName, Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + appName + "/Logs/", appName + "Log.txt");
    }

    @Override
    public void init(String appName, String filePath, String fileName) {
        if (TextUtils.isEmpty((CharSequence)appName)) {
            throw new IllegalArgumentException("SimpleLogger:init() - app name can't be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("SimpleLogger:init() - file name can't be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            filePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + appName + "/Logs/";
        }
        this.appName = appName;
        this.logFilePath = filePath;
        this.logFileName = fileName;
        this.logLevel = ILogger.eLogLevel.CRITICAL;
        this.d(TAG, "SimpleLogger:init()");
    }

    @Override
    public void writeLogcatToFile() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = createFileLock;
                    synchronized (object) {
                        Log.d((String)TAG, (String)"writeLogcatToFile()");
                        File dir = new File(SimpleLogger.this.logFilePath);
                        File f = new File(SimpleLogger.this.logFilePath, SimpleLogger.this.logFileName);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        if (!SimpleLogger.this.isWritingToFile()) {
                            Runtime.getRuntime().exec("logcat -f " + f.getAbsolutePath() + " -r" + SimpleLogger.FILE_SIZE_LIMIT + " -n " + SimpleLogger.NUM_OF_FILES_LIMIT + " -v threadtime");
                            SimpleLogger.this.d(TAG, "Writing logcat to file. Environment.getExternalStorageState()=" + Environment.getExternalStorageState() + ", path=" + f.getAbsolutePath());
                        } else {
                            SimpleLogger.this.d(TAG, "Logcat is already writing to to file");
                        }
                    }
                }
                catch (IOException e) {
                    SimpleLogger.this.d(TAG, "writeLogcatToFile() " + e.getMessage(), e);
                }
            }
        }, "writeLogcatToFile").start();
        this.d(TAG, "SimpleLogger:writeLogcatToFile() - " + this.logFilePath + this.logFileName);
    }

    private boolean isWritingToFile() {
        long diff;
        int retryCount = 20;
        File f = new File(this.logFilePath, this.logFileName);
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            diff = Math.abs(Calendar.getInstance().getTimeInMillis() - f.lastModified());
        } while (retryCount-- > 0 && diff > 5000L);
        return retryCount >= 1;
    }

    @Override
    public File getZippedLogFiles() {
        File result = null;
        result = new File(this.logFilePath, this.logFileName + ZIP_EXTENSION);
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(result);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] buffer = new byte[10240];
            File[] files = new File(this.logFilePath).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.startsWith(SimpleLogger.this.logFileName) && !filename.endsWith(SimpleLogger.ZIP_EXTENSION);
                }
            });
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return Long.valueOf(file1.lastModified()).compareTo(file2.lastModified());
                }
            });
            File mergedFile = FileUtils.getMergedFile(files, this.logFilePath, "merged_" + this.logFileName);
            File anrFile = SimpleLogger.getTracesFile();
            files = anrFile != null ? new File[]{mergedFile, anrFile} : new File[]{mergedFile};
            for (File f : files) {
                try {
                    int count;
                    FileInputStream fi = new FileInputStream(f);
                    origin = new BufferedInputStream(fi, buffer.length);
                    ZipEntry entry = new ZipEntry(f.getName());
                    out.putNextEntry(entry);
                    while ((count = origin.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, count);
                    }
                    out.closeEntry();
                    origin.close();
                }
                catch (FileNotFoundException ex) {
                    this.d(TAG, "SimpleLogger:getZippedLogFiles() -  failed to zip files", ex);
                }
            }
            out.close();
            mergedFile.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static File getTracesFile() {
        File tracesFile = new File("/data/anr/traces.txt");
        if (tracesFile.exists()) {
            return tracesFile;
        }
        return null;
    }

    @Override
    public String getFilePath() {
        return this.logFilePath;
    }

    @Override
    public String getFileName() {
        return this.logFileName;
    }

    private String obfuscate(String src, long key) {
        byte[] bytes = src.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((long)bytes[i] ^ key >> 8 * (i % 8));
        }
        return new String(bytes);
    }

    @Override
    public void log(String message) {
        this.v("HttpLoggingInterceptor", message);
    }
}

