/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.deps.com.google.common.base.CharMatcher;
import com.newrelic.agent.deps.org.apache.http.client.config.RequestConfig;
import com.newrelic.agent.deps.org.apache.http.client.methods.CloseableHttpResponse;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpGet;
import com.newrelic.agent.deps.org.apache.http.config.SocketConfig;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.StrictHostnameVerifier;
import com.newrelic.agent.deps.org.apache.http.impl.client.CloseableHttpClient;
import com.newrelic.agent.deps.org.apache.http.impl.client.HttpClientBuilder;
import com.newrelic.agent.deps.org.apache.http.util.EntityUtils;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import java.io.IOException;

public class CloudUtility {
    private static final int MIN_CHAR_CODEPOINT = "\u007f".codePointAt(0);

    private CloudUtility() {
    }

    public static String makeHttpRequest(String url, int requestTimeoutMillis, String ... headers) throws IOException {
        try (CloseableHttpClient httpclient = CloudUtility.configureHttpClient(requestTimeoutMillis);){
            HttpGet httpGet = new HttpGet(url);
            for (String header : headers) {
                String[] parts = header.split(":");
                httpGet.addHeader(parts[0].trim(), parts[1].trim());
            }
            CloseableHttpResponse response = httpclient.execute(httpGet);
            if (response.getStatusLine().getStatusCode() <= 207) {
                String string = EntityUtils.toString(response.getEntity(), "UTF-8");
                return string;
            }
        }
        return null;
    }

    private static CloseableHttpClient configureHttpClient(int requestTimeoutInMillis) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutInMillis).setSoKeepAlive(true).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis).setSocketTimeout(requestTimeoutInMillis);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setHostnameVerifier(new StrictHostnameVerifier());
        return builder.build();
    }

    public static void recordError(String metricName) {
        ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(metricName, 1));
    }

    static boolean isAscii(String value) {
        return CharMatcher.ascii().matchesAllOf(value);
    }

    static boolean isInvalidValue(String value) {
        if (value == null) {
            return true;
        }
        if (value.getBytes().length > 255) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ' || c == '_' || c == '.' || c == '/' || c == '-' || c > MIN_CHAR_CODEPOINT) continue;
            return true;
        }
        return false;
    }
}

