/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.external.ExternalParameters;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.RetryException;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.OutboundHeaders;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public abstract class AbstractTracer
implements Tracer {
    private final TransactionActivity transactionActivity;
    private Set<String> rollupMetricNames;
    private Set<String> exclusiveRollupMetricNames;
    private String customPrefix = "Custom";
    private Boolean trackChildThreads = null;
    private final long startTimeInMillis;
    AtomicReference<Long> finishTime = new AtomicReference<Object>(null);

    public AbstractTracer(Transaction transaction) {
        this(transaction.getTransactionActivity());
    }

    public AbstractTracer(TransactionActivity txa) {
        this.transactionActivity = txa;
        this.startTimeInMillis = System.currentTimeMillis();
    }

    public final Transaction getTransaction() {
        return this.transactionActivity.getTransaction();
    }

    @Override
    public final TransactionActivity getTransactionActivity() {
        return this.transactionActivity;
    }

    protected Object getInvocationTarget() {
        return null;
    }

    @Override
    public final Object invoke(Object methodName, Method method, Object[] args) {
        block14: {
            try {
                if (args == null) {
                    Agent.LOG.severe("Tracer.finish() was invoked with no arguments");
                } else if ("s" == methodName) {
                    if (args.length == 2) {
                        this.finish((Integer)args[0], args[1]);
                    } else {
                        Agent.LOG.severe(MessageFormat.format("Tracer.finish(int, Object) was invoked with {0} arguments(s)", args.length));
                    }
                } else if ("u" == methodName) {
                    if (args.length == 1) {
                        this.finish((Throwable)args[0]);
                    } else {
                        Agent.LOG.severe(MessageFormat.format("Tracer.finish(Throwable) was invoked with {0} arguments(s)", args.length));
                    }
                } else {
                    Agent.LOG.severe(MessageFormat.format("Tracer.finish was invoked with an unknown method: {0}", methodName));
                }
            }
            catch (RetryException e) {
                return this.invoke(methodName, method, args);
            }
            catch (Throwable t) {
                if (!Agent.LOG.isLoggable(Level.FINE)) break block14;
                String msg = MessageFormat.format("An error occurred finishing method tracer {0} for signature {1} : {2}", this.getClass().getName(), this.getClassMethodSignature(), t.toString());
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, msg, t);
                }
                Agent.LOG.fine(msg);
            }
        }
        return null;
    }

    @Override
    public abstract ClassMethodSignature getClassMethodSignature();

    @Override
    public boolean isChildHasStackTrace() {
        return false;
    }

    public void nameTransaction(TransactionNamePriority priority) {
        try {
            ClassMethodSignature classMethodSignature = this.getClassMethodSignature();
            Object invocationTarget = this.getInvocationTarget();
            String className = invocationTarget == null ? classMethodSignature.getClassName() : invocationTarget.getClass().getName();
            String txName = className + "/" + classMethodSignature.getMethodName();
            Agent.LOG.log(Level.FINER, "Setting transaction name using instrumented class and method: {0}", txName);
            Transaction tx = this.transactionActivity.getTransaction();
            tx.setTransactionName(priority, false, this.customPrefix, txName);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "nameTransaction", t);
        }
    }

    public TracedMethod getParentTracedMethod() {
        return this.getParentTracer();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    protected Set<String> getRollupMetricNames() {
        return this.rollupMetricNames;
    }

    protected Set<String> getExclusiveRollupMetricNames() {
        return this.exclusiveRollupMetricNames;
    }

    public void addRollupMetricName(String ... metricNameParts) {
        if (this.rollupMetricNames == null) {
            this.rollupMetricNames = new HashSet<String>();
        }
        this.rollupMetricNames.add(Strings.join('/', metricNameParts));
    }

    public void setRollupMetricNames(String ... metricNames) {
        this.rollupMetricNames = new HashSet<String>(metricNames.length);
        this.rollupMetricNames.addAll(Arrays.asList(metricNames));
    }

    public void addExclusiveRollupMetricName(String ... metricNameParts) {
        if (this.exclusiveRollupMetricNames == null) {
            this.exclusiveRollupMetricNames = new HashSet<String>();
        }
        this.exclusiveRollupMetricNames.add(Strings.join('/', metricNameParts));
    }

    public void setCustomMetricPrefix(String prefix) {
        this.customPrefix = prefix;
    }

    public void setTrackChildThreads(boolean shouldTrack) {
        this.trackChildThreads = shouldTrack;
    }

    public boolean trackChildThreads() {
        if (null == this.trackChildThreads) {
            TracedMethod parent = this.getParentTracedMethod();
            if (null == parent) {
                return true;
            }
            return parent.trackChildThreads();
        }
        return this.trackChildThreads;
    }

    public void addOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        Agent.LOG.severe("addOutboundRequestHeaders is only supported on subclasses of DefaultTracer: {0}");
    }

    public void readInboundResponseHeaders(InboundHeaders inboundResponseHeaders) {
        Agent.LOG.severe("readInboundResponseHeaders is only supported on subclasses of DefaultTracer: {0}");
    }

    public void reportAsExternal(com.newrelic.api.agent.ExternalParameters externalParameters) {
        Agent.LOG.severe("reportAsExternal is only supported on subclasses of DefaultTracer: {0}");
    }

    public void reportAsExternal(ExternalParameters externalParameters) {
        Agent.LOG.severe("reportAsExternal is only supported on subclasses of DefaultTracer: {0}");
    }

    @Override
    public void markFinishTime() {
        this.finishTime.compareAndSet(null, System.nanoTime());
    }

    @Override
    public long getStartTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Override
    public com.newrelic.api.agent.ExternalParameters getExternalParameters() {
        return null;
    }
}

