/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.MetricData;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.ApdexStats;
import com.newrelic.agent.stats.ApdexStatsImpl;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.ResponseTimeStatsImpl;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.agent.stats.StatsImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleStatsEngine {
    private static final float SCOPED_METRIC_THRESHOLD = 0.02f;
    public static final int DEFAULT_CAPACITY = 32;
    private final Map<String, StatsBase> stats;

    public SimpleStatsEngine() {
        this(32);
    }

    public SimpleStatsEngine(int capacity) {
        this.stats = new ConcurrentHashMap<String, StatsBase>(capacity);
    }

    public Map<String, StatsBase> getStatsMap() {
        return this.stats;
    }

    public Stats getStats(String metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        StatsBase s = this.stats.get(metricName);
        if (s == null) {
            s = new StatsImpl();
            this.stats.put(metricName, s);
        }
        if (s instanceof Stats) {
            return (Stats)s;
        }
        String msg = MessageFormat.format("The stats object for {0} is of type {1}", metricName, s.getClass().getName());
        throw new RuntimeException(msg);
    }

    public ResponseTimeStats getResponseTimeStats(String metric) {
        if (metric == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        StatsBase s = this.stats.get(metric);
        if (s == null) {
            s = new ResponseTimeStatsImpl();
            this.stats.put(metric, s);
        }
        if (s instanceof ResponseTimeStats) {
            return (ResponseTimeStats)s;
        }
        String msg = MessageFormat.format("The stats object for {0} is of type {1}", metric, s.getClass().getName());
        throw new RuntimeException(msg);
    }

    public void recordEmptyStats(String metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot record a stat for a null metric");
        }
        this.stats.put(metricName, AbstractStats.EMPTY_STATS);
    }

    public ApdexStats getApdexStats(String metricName) {
        if (metricName == null) {
            throw new RuntimeException("Cannot get a stat for a null metric");
        }
        StatsBase s = this.stats.get(metricName);
        if (s == null) {
            s = new ApdexStatsImpl();
            this.stats.put(metricName, s);
        }
        if (s instanceof ApdexStats) {
            return (ApdexStats)s;
        }
        String msg = MessageFormat.format("The stats object for {0} is of type {1}", metricName, s.getClass().getName());
        throw new RuntimeException(msg);
    }

    public void mergeStats(SimpleStatsEngine other) {
        for (Map.Entry<String, StatsBase> entry : other.stats.entrySet()) {
            StatsBase ourStats = this.stats.get(entry.getKey());
            StatsBase otherStats = entry.getValue();
            if (ourStats == null) {
                this.stats.put(entry.getKey(), otherStats);
                continue;
            }
            ourStats.merge(otherStats);
        }
    }

    public void clear() {
        this.stats.clear();
    }

    public int getSize() {
        return this.stats.size();
    }

    public List<MetricData> getMetricData(Normalizer metricNormalizer, String scope) {
        ArrayList<MetricData> result = new ArrayList<MetricData>(this.stats.size() + 1);
        boolean isTrimStats = ServiceFactory.getConfigService().getDefaultAgentConfig().isTrimStats();
        if (isTrimStats && !scope.equals("")) {
            this.trimStats();
        }
        for (Map.Entry<String, StatsBase> entry : this.stats.entrySet()) {
            MetricName metricName = MetricName.create(entry.getKey(), scope);
            MetricData metricData = SimpleStatsEngine.createMetricData(metricName, entry.getValue(), metricNormalizer);
            if (metricData == null) continue;
            result.add(metricData);
        }
        return result;
    }

    protected static MetricData createMetricData(MetricName metricName, StatsBase statsBase, Normalizer metricNormalizer) {
        if (!statsBase.hasData()) {
            return null;
        }
        String normalized = metricNormalizer.normalize(metricName.getName());
        if (normalized == null) {
            return null;
        }
        if (normalized.equals(metricName.getName())) {
            return MetricData.create(metricName, statsBase);
        }
        MetricName normalizedMetricName = MetricName.create(normalized, metricName.getScope());
        return MetricData.create(normalizedMetricName, statsBase);
    }

    private void trimStats() {
        float totalTime = 0.0f;
        for (StatsBase statsBase : this.stats.values()) {
            ResponseTimeStats stats = (ResponseTimeStats)statsBase;
            totalTime += stats.getTotalExclusiveTime();
        }
        ResponseTimeStatsImpl other = null;
        float threshold = totalTime * 0.02f;
        HashSet<String> remove = new HashSet<String>();
        for (Map.Entry<String, StatsBase> entry : this.stats.entrySet()) {
            ResponseTimeStatsImpl statsObj = (ResponseTimeStatsImpl)entry.getValue();
            if (!(statsObj.getTotalExclusiveTime() < threshold) || !this.trimmableMetric(entry.getKey())) continue;
            if (other == null) {
                other = statsObj;
            } else {
                other.merge(statsObj);
            }
            remove.add(entry.getKey());
        }
        if (other != null) {
            this.stats.put("Java/other", other);
            for (String name : remove) {
                this.stats.remove(name);
            }
        }
    }

    private boolean trimmableMetric(String key) {
        return !key.startsWith("Datastore") && !key.startsWith("External") && !key.startsWith("RequestDispatcher");
    }

    public String toString() {
        return "SimpleStatsEngine [stats=" + this.stats + "]";
    }
}

