/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.bridge.datastore.RecordSql;
import com.newrelic.agent.config.DatastoreConfig;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.config.SqlTraceConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.CacheValue;
import com.newrelic.agent.sql.SlowQueryTracerInfo;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.sql.SqlTraceImpl;
import com.newrelic.agent.trace.TransactionSegment;
import com.newrelic.agent.tracers.SqlTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.util.StackTraces;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SlowQueryInfo
implements Comparable<SlowQueryInfo>,
CacheValue<String> {
    private final AtomicReference<SlowQueryTracerInfo> slowestQuery = new AtomicReference();
    private final long id;
    private final AtomicInteger callCount = new AtomicInteger();
    private final AtomicLong total = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private final String rawQuery;
    private final String obfuscatedQuery;

    SlowQueryInfo(TransactionData td, Tracer tracer, String rawQuery, String obfuscatedQuery, SqlTraceConfig sqlTraceConfig) {
        this.slowestQuery.set(new SlowQueryTracerInfo(td, tracer));
        this.rawQuery = rawQuery;
        this.obfuscatedQuery = obfuscatedQuery;
        this.id = this.generateId(sqlTraceConfig, obfuscatedQuery);
    }

    private long generateId(SqlTraceConfig sqlTraceConfig, String obfuscatedQuery) {
        long obfuscatedHash = obfuscatedQuery.hashCode();
        if (sqlTraceConfig.isUsingLongerSqlId()) {
            obfuscatedHash = SlowQueryInfo.createLongerHashCode(obfuscatedHash);
        }
        return obfuscatedHash;
    }

    protected static long createLongerHashCode(long hashedQuery) {
        String hashString = String.valueOf(hashedQuery);
        long positiveHash = hashedQuery < 0L ? hashedQuery * -1L : hashedQuery;
        String positiveHashString = String.valueOf(positiveHash);
        if (positiveHashString.length() == 9) {
            hashString = hashString + positiveHashString.charAt(0);
        }
        return Long.parseLong(hashString);
    }

    public TransactionData getTransactionData() {
        return this.slowestQuery.get().getTransactionData();
    }

    public Tracer getTracer() {
        return this.slowestQuery.get().getTracer();
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public String getObfuscatedQuery() {
        return this.obfuscatedQuery;
    }

    @Override
    public int compareTo(SlowQueryInfo other) {
        Long otherMax;
        Long thisMax = this.max.get();
        int compare = thisMax.compareTo(otherMax = Long.valueOf(other.max.get()));
        if (compare == 0) {
            Long thisTotal = this.total.get();
            Long otherTotal = other.total.get();
            return thisTotal.compareTo(otherTotal);
        }
        return compare;
    }

    @Override
    public String getKey() {
        return this.obfuscatedQuery;
    }

    public void aggregate(Tracer tracer) {
        this.aggregate(null, tracer);
    }

    public void aggregate(TransactionData td, Tracer tracer) {
        this.callCount.incrementAndGet();
        long duration = tracer.getDuration();
        this.total.addAndGet(duration);
        this.replaceMin(duration);
        this.replaceMax(duration);
        this.replaceTracer(td, tracer);
    }

    public void aggregate(SlowQueryInfo other) {
        long duration = other.getTracer().getDuration();
        this.total.addAndGet(other.getTotalInNano());
        this.callCount.addAndGet(other.getCallCount());
        this.replaceMin(duration);
        this.replaceMax(duration);
        this.replaceTracer(other.getTransactionData(), other.getTracer());
    }

    public SqlTrace asSqlTrace() {
        Tracer tracer = this.getTracer();
        if (tracer instanceof SqlTracer) {
            DatabaseService dbService = ServiceFactory.getDatabaseService();
            dbService.runExplainPlan((SqlTracer)tracer);
        }
        return new SqlTraceImpl(this);
    }

    public String getBlameMetricName() {
        return this.getTransactionData().getBlameMetricName();
    }

    public String getMetricName() {
        return this.getTracer().getMetricName();
    }

    public long getId() {
        return this.id;
    }

    public String getQuery() {
        String query = this.obfuscatedQuery;
        TransactionTracerConfig ttConfig = this.getTransactionData().getTransactionTracerConfig();
        RecordSql recordSql = RecordSql.get((String)ttConfig.getRecordSql());
        if (recordSql == RecordSql.raw) {
            query = this.rawQuery;
        }
        return TransactionSegment.truncateSql(query, ttConfig.getInsertSqlMaxLength());
    }

    public String getRequestUri() {
        return this.getTransactionData().getRequestUri("attributes");
    }

    public int getCallCount() {
        return this.callCount.get();
    }

    public long getTotalInNano() {
        return this.total.get();
    }

    public long getTotalInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.total.get(), TimeUnit.NANOSECONDS);
    }

    public long getMinInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.min.get(), TimeUnit.NANOSECONDS);
    }

    public long getMaxInMillis() {
        return TimeUnit.MILLISECONDS.convert(this.max.get(), TimeUnit.NANOSECONDS);
    }

    public Map<String, Object> getParameters() {
        return this.createParameters(this.getTracer());
    }

    private Map<String, Object> createParameters(Tracer tracer) {
        Map inputQuery;
        boolean allUnknown;
        List<StackTraceElement> backtrace;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Object explainPlan = tracer.getAttribute("explanation");
        if (explainPlan != null) {
            parameters.put("explain_plan", explainPlan);
        }
        if ((backtrace = (List<StackTraceElement>)tracer.getAttribute("backtrace")) != null) {
            backtrace = StackTraces.scrubAndTruncate(backtrace);
            List<String> backtraceStrings = StackTraces.toStringList(backtrace);
            parameters.put("backtrace", backtraceStrings);
        }
        DatastoreConfig datastoreConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDatastoreConfig();
        String host = (String)tracer.getAttribute("host");
        String port_path_or_id = (String)tracer.getAttribute("port_path_or_id");
        boolean bl = allUnknown = host == null && port_path_or_id == null;
        if (datastoreConfig.isInstanceReportingEnabled() && !allUnknown) {
            parameters.put("host", host);
            parameters.put("port_path_or_id", port_path_or_id);
        }
        String databaseName = (String)tracer.getAttribute("db.instance");
        if (datastoreConfig.isDatabaseNameReportingEnabled() && databaseName != null) {
            parameters.put("db.instance", databaseName);
        }
        if ((inputQuery = (Map)tracer.getAttribute("input_query")) != null) {
            parameters.put("input_query", inputQuery);
        }
        Transaction txn = tracer.getTransactionActivity().getTransaction();
        DistributedTracePayloadImpl inboundPayload = txn.getSpanProxy().getInboundDistributedTracePayload();
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        DistributedTracingConfig distributedTracingConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig();
        if (distributedTracingConfig.isEnabled()) {
            String traceId = txn.getOrCreateTraceId();
            String parentId = inboundPayload == null ? null : inboundPayload.txnId;
            String parentSpanId = inboundPayload == null ? null : inboundPayload.guid;
            Map<String, Object> intrinsics = distributedTraceService.getIntrinsics(inboundPayload, txn.getGuid(), traceId, txn.getTransportType(), txn.getTransportDurationInMillis(), txn.getLargestTransportDurationInMillis(), parentId, parentSpanId, txn.getPriority());
            parameters.putAll(intrinsics);
        }
        parameters.put("priority", Float.valueOf(txn.getPriority()));
        return parameters;
    }

    private void replaceMin(long duration) {
        long currentDuration;
        do {
            if (duration < (currentDuration = this.min.get())) continue;
            return;
        } while (!this.min.compareAndSet(currentDuration, duration));
    }

    private void replaceMax(long duration) {
        long currentDuration;
        do {
            if (duration > (currentDuration = this.max.get())) continue;
            return;
        } while (!this.max.compareAndSet(currentDuration, duration));
    }

    private void replaceTracer(TransactionData td, Tracer tracer) {
        SlowQueryTracerInfo update;
        SlowQueryTracerInfo current;
        do {
            current = this.slowestQuery.get();
            if (tracer.getDuration() > current.getTracer().getDuration()) continue;
            return;
        } while (!this.slowestQuery.compareAndSet(current, update = new SlowQueryTracerInfo(td, tracer)));
    }

    public void setTransactionData(TransactionData td) {
        this.slowestQuery.get().setTransactionData(td);
    }
}

