/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.deps.com.google.common.collect.ComparisonChain;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AdaptiveSampling;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.analytics.SpanEvent;
import com.newrelic.agent.service.analytics.SpanEventHarvestableImpl;
import com.newrelic.agent.service.analytics.SpanEventsService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.SpanProxy;
import com.newrelic.agent.tracing.W3CTraceState;
import com.newrelic.agent.tracing.W3CTraceStateSupport;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.api.agent.DatastoreParameters;
import com.newrelic.api.agent.HttpParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SpanEventsServiceImpl
extends AbstractService
implements AgentConfigListener,
SpanEventsService,
TransactionListener {
    private DistributedSamplingPriorityQueue<SpanEvent> reservoir;
    private List<Harvestable> harvestables = new ArrayList<Harvestable>();
    private volatile SpanEventsConfig spanEventsConfig;
    private volatile int maxSamplesStored;
    private static final Comparator<SpanEvent> SPAN_EVENT_COMPARATOR = new Comparator<SpanEvent>(){

        @Override
        public int compare(SpanEvent left, SpanEvent right) {
            return ComparisonChain.start().compare(right.getPriority(), left.getPriority()).result();
        }
    };

    public SpanEventsServiceImpl() {
        super(SpanEventsServiceImpl.class.getSimpleName());
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.spanEventsConfig = agentConfig.getSpanEventsConfig();
        this.maxSamplesStored = this.spanEventsConfig.getMaxSamplesStored();
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
        ServiceFactory.getTransactionService().addTransactionListener(this);
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        if (transactionData.sampled() && this.isSpanEventsEnabled()) {
            Tracer rootTracer = transactionData.getRootTracer();
            try {
                this.createAndStoreSpanEvent(rootTracer, transactionData, true);
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.FINER, t, "An error occurred creating span event for tracer: {0} in tx: {1}", rootTracer, transactionData);
            }
            Collection<Tracer> tracers = transactionData.getTracers();
            for (Tracer tracer : tracers) {
                if (!tracer.isTransactionSegment()) continue;
                try {
                    this.createAndStoreSpanEvent(tracer, transactionData, false);
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINER, t, "An error occurred creating span event for tracer: {0} in tx: {1}", tracer, transactionData);
                }
            }
        }
    }

    private void createAndStoreSpanEvent(Tracer tracer, TransactionData transactionData, boolean isRoot) {
        boolean crossProcessOnly = this.spanEventsConfig.isCrossProcessOnly();
        if (crossProcessOnly && !this.isCrossProcessTracer(tracer)) {
            return;
        }
        DistributedSamplingPriorityQueue<SpanEvent> reservoir = this.getOrCreateDistributedSamplingReservoir();
        if (reservoir.isFull() && reservoir.getMinPriority() >= transactionData.getPriority()) {
            reservoir.incrementNumberOfTries();
            return;
        }
        SpanProxy spanProxy = transactionData.getSpanProxy();
        DistributedTracePayloadImpl inboundPayload = spanProxy.getInboundDistributedTracePayload();
        W3CTraceState traceState = spanProxy.getInitiatingW3CTraceState();
        SpanEvent.SpanEventBuilder builder = SpanEvent.builder().setAppName(transactionData.getApplicationName()).setGuid(tracer.getGuid()).setTraceId(spanProxy.getOrCreateTraceId()).setSampled(transactionData.sampled()).setParentId(this.getParentId(tracer, transactionData, crossProcessOnly)).setTransactionId(transactionData.getGuid()).setDurationInSeconds((float)tracer.getDuration() / 1.0E9f).setName(tracer.getTransactionSegmentName()).setTimestamp(tracer.getStartTimeInMillis()).setPriority(transactionData.getPriority()).setExternalParameterAttributes(tracer.getExternalParameters()).setIsRootSpanEvent(isRoot).setDecider(inboundPayload == null || inboundPayload.priority == null);
        if (traceState != null) {
            if (isRoot && traceState.getGuid() != null) {
                builder.setTrustedParent(traceState.getGuid());
            }
            Set<String> vendorKeys = W3CTraceStateSupport.buildVendorKeys(traceState);
            builder.setTracingVendors(vendorKeys);
        }
        this.storeEvent(builder.build());
    }

    private boolean isCrossProcessTracer(Tracer tracer) {
        return tracer.getExternalParameters() instanceof HttpParameters || tracer.getExternalParameters() instanceof DatastoreParameters;
    }

    private String getParentId(Tracer tracer, TransactionData transactionData, boolean crossProcessOnly) {
        if (crossProcessOnly) {
            return null;
        }
        Tracer parentSegment = this.getParentTracerWithSpan(tracer.getParentTracer());
        DistributedTracePayloadImpl inboundPayload = transactionData.getInboundDistributedTracePayload();
        if (parentSegment != null) {
            return parentSegment.getGuid();
        }
        if (inboundPayload != null) {
            return inboundPayload.guid;
        }
        if (transactionData.getW3CTraceParent() != null) {
            return transactionData.getW3CTraceParent().getParentId();
        }
        return null;
    }

    @Override
    public Tracer getParentTracerWithSpan(Tracer parentTracer) {
        while (parentTracer != null && !parentTracer.isTransactionSegment()) {
            parentTracer = parentTracer.getParentTracer();
        }
        return parentTracer;
    }

    @Override
    public void harvestEvents(final String appName) {
        if (!this.spanEventsConfig.isEnabled()) {
            this.reservoir = null;
            return;
        }
        if (this.maxSamplesStored <= 0) {
            this.clearReservoir();
            return;
        }
        long startTimeInNanos = System.nanoTime();
        int decidedLast = AdaptiveSampling.decidedLast(this.reservoir, this.spanEventsConfig.getTargetSamplesStored());
        final DistributedSamplingPriorityQueue<SpanEvent> toSend = this.reservoir;
        this.createDistributedSamplingReservoir(decidedLast);
        if (toSend != null && toSend.size() > 0) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendSpanEvents(this.maxSamplesStored, toSend.getNumberOfTries(), Collections.unmodifiableList(toSend.asList()));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        SpanEventsServiceImpl.this.recordSupportabilityMetrics(statsEngine, durationInNanos, toSend);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                });
                if (toSend.size() < toSend.getNumberOfTries()) {
                    int dropped = toSend.getNumberOfTries() - toSend.size();
                    Agent.LOG.log(Level.WARNING, "Dropped {0} span events out of {1}.", dropped, toSend.getNumberOfTries());
                }
            }
            catch (HttpError e) {
                if (!e.discardHarvestData()) {
                    Agent.LOG.log(Level.FINE, "Unable to send span events. Unsent events will be included in the next harvest.", e);
                    this.reservoir.retryAll(toSend);
                } else {
                    toSend.clear();
                    Agent.LOG.log(Level.FINE, "Unable to send span events. Unsent events will be dropped.", e);
                }
            }
            catch (Exception e) {
                toSend.clear();
                Agent.LOG.log(Level.FINE, "Unable to send span events. Unsent events will be dropped.", e);
            }
        }
    }

    @Override
    public String getEventHarvestIntervalMetric() {
        return "Supportability/EventHarvest/SpanEvent/interval";
    }

    @Override
    public String getReportPeriodInSecondsMetric() {
        return "Supportability/EventHarvest/SpanEventData/ReportPeriod";
    }

    @Override
    public String getEventHarvestLimitMetric() {
        return "Supportability/EventHarvest/SpanEventData/HarvestLimit";
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanos, DistributedSamplingPriorityQueue<SpanEvent> reservoir) {
        int sent = reservoir.size();
        int seen = reservoir.getNumberOfTries();
        statsEngine.getStats("Supportability/SpanEvent/TotalEventsSent").incrementCallCount(sent);
        statsEngine.getStats("Supportability/SpanEvent/TotalEventsSeen").incrementCallCount(seen);
        statsEngine.getStats("Supportability/SpanEvent/Discarded").incrementCallCount(seen - sent);
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/SpanEvent/transmit").recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public boolean isEnabled() {
        return this.spanEventsConfig.isEnabled();
    }

    private boolean isSpanEventsEnabled() {
        return this.spanEventsConfig.isEnabled() && this.maxSamplesStored > 0;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isEnabled()) {
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/SpanEvents");
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        this.removeHarvestables();
        this.clearReservoir();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    @Override
    public void storeEvent(SpanEvent event) {
        if (this.isSpanEventsEnabled()) {
            DistributedSamplingPriorityQueue<SpanEvent> reservoir = this.getOrCreateDistributedSamplingReservoir();
            reservoir.add(event);
        }
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public void setMaxSamplesStored(int maxSamplesStored) {
        this.maxSamplesStored = maxSamplesStored;
        this.createDistributedSamplingReservoir(0);
    }

    @Override
    public void clearReservoir() {
        if (this.reservoir != null) {
            this.reservoir.clear();
        }
    }

    @Override
    public void addHarvestableToService(String appName) {
        String primaryApplication = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
        if (primaryApplication.equals(appName)) {
            SpanEventHarvestableImpl harvestable = new SpanEventHarvestableImpl(this, appName);
            ServiceFactory.getHarvestService().addHarvestable(harvestable);
            this.harvestables.add(harvestable);
        }
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        boolean wasEnabled = this.isEnabled();
        this.spanEventsConfig = agentConfig.getSpanEventsConfig();
        if (!wasEnabled && this.isEnabled()) {
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/SpanEvents");
        }
    }

    @Override
    public DistributedSamplingPriorityQueue<SpanEvent> getOrCreateDistributedSamplingReservoir() {
        if (this.reservoir == null) {
            this.createDistributedSamplingReservoir(0);
        }
        return this.reservoir;
    }

    private void createDistributedSamplingReservoir(int decidedLast) {
        String appName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
        int target = this.spanEventsConfig.getTargetSamplesStored();
        this.reservoir = new DistributedSamplingPriorityQueue<SpanEvent>(appName, "Span Event Service", this.maxSamplesStored, decidedLast, target, SPAN_EVENT_COMPARATOR);
    }
}

