/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.JmxApi;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.values.GlassfishJmxValues;
import com.newrelic.agent.jmx.values.Jboss7UpJmxValues;
import com.newrelic.agent.jmx.values.JettyJmxMetrics;
import com.newrelic.agent.jmx.values.KafkaConsumerJmxValues;
import com.newrelic.agent.jmx.values.KafkaProducerJmxValues;
import com.newrelic.agent.jmx.values.ResinJmxValues;
import com.newrelic.agent.jmx.values.Solr7JmxValues;
import com.newrelic.agent.jmx.values.SolrJmxValues;
import com.newrelic.agent.jmx.values.TomcatJmxValues;
import com.newrelic.agent.jmx.values.WebSphere7JmxValues;
import com.newrelic.agent.jmx.values.WebSphereJmxValues;
import com.newrelic.agent.jmx.values.WeblogicJmxValues;
import com.newrelic.agent.jmx.values.WebsphereLibertyJmxValues;
import com.newrelic.agent.service.ServiceFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.management.MBeanServerFactory;

public class JmxApiImpl
implements JmxApi {
    private ConcurrentMap<String, Boolean> addedJmx = new ConcurrentHashMap<String, Boolean>();

    public void addJmxMBeanGroup(String name) {
        if (!this.addedJmx.containsKey(name)) {
            JmxFrameworkValues jmx = this.getJmxFrameworkValues(name);
            if (null != jmx) {
                Boolean alreadyAdded = this.addedJmx.putIfAbsent(name, Boolean.TRUE);
                if (null == alreadyAdded || !alreadyAdded.booleanValue()) {
                    ServiceFactory.getJmxService().addJmxFrameworkValues(jmx);
                    Agent.LOG.log(Level.FINE, "Added JMX for {0}", jmx.getPrefix());
                } else {
                    Agent.LOG.log(Level.FINE, "Skipped JMX. Already added JMX framework: {0}", name);
                }
            } else {
                Agent.LOG.log(Level.FINE, "Skipped JMX. Unknown JMX framework: {0}", name);
            }
        }
    }

    private JmxFrameworkValues getJmxFrameworkValues(String prefixName) {
        if (prefixName != null) {
            switch (prefixName) {
                case "kafka.producer": {
                    return new KafkaProducerJmxValues();
                }
                case "kafka.consumer": {
                    return new KafkaConsumerJmxValues();
                }
                case "WebSphere-7": {
                    return new WebSphere7JmxValues();
                }
                case "WebSphere": {
                    return new WebSphereJmxValues();
                }
                case "solr": {
                    return new SolrJmxValues();
                }
                case "solr7": {
                    return new Solr7JmxValues();
                }
                case "liberty": {
                    return new WebsphereLibertyJmxValues();
                }
                case "Catalina": {
                    return new TomcatJmxValues();
                }
                case "org.eclipse.jetty": {
                    return new JettyJmxMetrics();
                }
                case "jboss.as": {
                    return new Jboss7UpJmxValues();
                }
                case "resin": {
                    return new ResinJmxValues();
                }
                case "amx": {
                    return new GlassfishJmxValues();
                }
                case "com.bea": {
                    return new WeblogicJmxValues();
                }
            }
        }
        return null;
    }

    public void createMBeanServerIfNeeded() {
        if (System.getProperty("com.sun.management.jmxremote") == null && MBeanServerFactory.findMBeanServer(null).isEmpty()) {
            try {
                MBeanServerFactory.createMBeanServer();
                Agent.LOG.log(Level.INFO, "Created a default MBeanServer");
            }
            catch (Exception e) {
                Agent.LOG.severe("The JMX Service was unable to create a default MBeanServer");
            }
        }
    }
}

