/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.NoticeSqlVisitor;
import com.newrelic.agent.instrumentation.tracing.TraceClassVisitor;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.logging.Level;

public class TraceClassTransformer
implements ContextClassTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context, OptimizedClassMatcher.Match match) throws IllegalClassFormatException {
        try {
            if (!PointCutClassTransformer.isValidClassName(className)) {
                return null;
            }
            return this.doTransform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer, context);
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINE, "Unable to transform class " + className, t);
            return null;
        }
    }

    private byte[] doTransform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, InstrumentationContext context) throws IllegalClassFormatException {
        ClassWriter writer;
        if (!context.isTracerMatch()) {
            return null;
        }
        Agent.LOG.debug("Instrumenting class " + className);
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassVisitor cv = writer = new ClassWriter(1);
        NoticeSqlVisitor noticeSqlVisitor = new NoticeSqlVisitor(458752);
        reader.accept(noticeSqlVisitor, 4);
        cv = new TraceClassVisitor(cv, className, context, noticeSqlVisitor.getNoticeSqlMethods());
        reader.accept(cv, 8);
        return writer.toByteArray();
    }
}

