/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.instrumentation.ClassNameFilter;
import com.newrelic.agent.instrumentation.api.ApiImplementationUpdate;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.ContextClassTransformer;
import com.newrelic.agent.instrumentation.context.GeneratedClassDetector;
import com.newrelic.agent.instrumentation.context.InstrumentationClassTransformer;
import com.newrelic.agent.instrumentation.context.NoOpClassTransformer;
import com.newrelic.agent.instrumentation.context.TraceMatchVisitor;
import com.newrelic.agent.instrumentation.ejb3.EJBAnnotationVisitor;
import com.newrelic.agent.instrumentation.tracing.TraceClassTransformer;
import com.newrelic.agent.instrumentation.weaver.ClassLoaderClassTransformer;
import com.newrelic.agent.instrumentation.weaver.ClassWeaverService;
import com.newrelic.agent.instrumentation.webservices.WebServiceVisitor;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.servlet.ServletAnnotationVisitor;
import com.newrelic.weave.utils.WeaveUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class InstrumentationContextManager {
    private static final String LOG4J_DEPENDENCY = "com/newrelic/agent/deps/org/apache/logging/log4j/";
    static final NoOpClassTransformer NO_OP_TRANSFORMER = new NoOpClassTransformer();
    private final Map<ClassMatchVisitorFactory, ContextClassTransformer> matchVisitors = new ConcurrentHashMap<ClassMatchVisitorFactory, ContextClassTransformer>();
    private final Map<ClassMatchVisitorFactory, ContextClassTransformer> interfaceMatchVisitors = new ConcurrentHashMap<ClassMatchVisitorFactory, ContextClassTransformer>();
    private final Set<String> classloaderExclusions;
    private final Instrumentation instrumentation;
    private final ClassWeaverService classWeaverService;
    private ClassFileTransformer jvmTransformer;
    private final ClassNameFilter classNameFilter;

    public InstrumentationContextManager(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.classWeaverService = new ClassWeaverService(this);
        this.matchVisitors.put(new TraceMatchVisitor(), NO_OP_TRANSFORMER);
        this.matchVisitors.put(new GeneratedClassDetector(), NO_OP_TRANSFORMER);
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        ClassTransformerConfig classTransformerConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig();
        if (((Boolean)agentConfig.getValue("instrumentation.web_services.enabled", false)).booleanValue()) {
            Agent.LOG.log(Level.FINEST, "web_services instrumentation is enabled");
            this.matchVisitors.put(new WebServiceVisitor(), NO_OP_TRANSFORMER);
        } else if (!classTransformerConfig.isDefaultInstrumentationEnabled()) {
            Agent.LOG.log(Level.FINEST, "web_services instrumentation is disabled because it is not explicitly enabled");
        } else {
            this.matchVisitors.put(new WebServiceVisitor(), NO_OP_TRANSFORMER);
        }
        this.classNameFilter = new ClassNameFilter(Agent.LOG);
        this.classNameFilter.addConfigClassFilters(agentConfig);
        this.classNameFilter.addExcludeFileClassFilters();
        if (((Boolean)agentConfig.getValue("instrumentation.servlet_annotations.enabled", false)).booleanValue()) {
            Agent.LOG.log(Level.FINEST, "servlet_annotations instrumentation is enabled");
            this.matchVisitors.put(new ServletAnnotationVisitor(), NO_OP_TRANSFORMER);
        } else if (!classTransformerConfig.isDefaultInstrumentationEnabled()) {
            Agent.LOG.log(Level.FINEST, "servlet_annotations instrumentation is disabled because it is not explicitly enabled");
        } else {
            this.matchVisitors.put(new ServletAnnotationVisitor(), NO_OP_TRANSFORMER);
        }
        Config instrumentationConfig = agentConfig.getClassTransformerConfig().getInstrumentationConfig("com.newrelic.instrumentation.ejb-3.0");
        if (instrumentationConfig.getProperty("enabled", false).booleanValue()) {
            Agent.LOG.log(Level.FINEST, "ejb-3.0 instrumentation is enabled");
            this.matchVisitors.put(new EJBAnnotationVisitor(), NO_OP_TRANSFORMER);
        } else if (!classTransformerConfig.isDefaultInstrumentationEnabled()) {
            Agent.LOG.log(Level.FINEST, "ejb-3.0 instrumentation is disabled because it is not explicitly enabled");
        } else {
            this.matchVisitors.put(new EJBAnnotationVisitor(), NO_OP_TRANSFORMER);
        }
        this.classloaderExclusions = agentConfig.getClassTransformerConfig().getClassloaderExclusions();
        this.matchVisitors.put(ServiceFactory.getJarCollectorService().getSourceVisitor(), NO_OP_TRANSFORMER);
        this.matchVisitors.put(ServiceFactory.getSourceLanguageService().getSourceVisitor(), NO_OP_TRANSFORMER);
        try {
            ApiImplementationUpdate.setup(this);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, e.toString());
        }
    }

    public Map<ClassMatchVisitorFactory, ContextClassTransformer> getMatchVisitors() {
        return this.matchVisitors;
    }

    public ClassWeaverService getClassWeaverService() {
        return this.classWeaverService;
    }

    public static InstrumentationContextManager create(ClassLoaderClassTransformer classLoaderClassTransformer, InstrumentationProxy instrumentation, boolean bootstrapClassloaderEnabled) throws Exception {
        InstrumentationContextManager manager = new InstrumentationContextManager(instrumentation);
        TraceClassTransformer traceTransformer = new TraceClassTransformer();
        manager.classWeaverService.registerInstrumentation();
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        boolean defaultMethodTracingEnabled = agentConfig.getClassTransformerConfig().isDefaultMethodTracingEnabled();
        InstrumentationClassTransformer transformer = new InstrumentationClassTransformer(manager, traceTransformer, bootstrapClassloaderEnabled, defaultMethodTracingEnabled);
        instrumentation.addTransformer(transformer, true);
        manager.jvmTransformer = transformer;
        manager.addContextClassTransformer(classLoaderClassTransformer, classLoaderClassTransformer);
        instrumentation.removeTransformer(classLoaderClassTransformer);
        manager.classWeaverService.createRetransformRunnable(instrumentation.getAllLoadedClasses()).run();
        transformer.setInitialized(true);
        return manager;
    }

    protected void applyInterfaceVisitors(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader) {
        ClassVisitor cv = null;
        for (ClassMatchVisitorFactory factory : this.interfaceMatchVisitors.keySet()) {
            cv = factory.newClassMatchVisitor(loader, classBeingRedefined, reader, cv, null);
        }
        if (cv != null) {
            reader.accept(cv, 1);
        }
    }

    public boolean shouldTransform(String internalClassName, ClassLoader classloader) {
        if (null == internalClassName) {
            return false;
        }
        if (internalClassName.startsWith(LOG4J_DEPENDENCY)) {
            return false;
        }
        if (this.isClassloaderExcluded(classloader)) {
            Agent.LOG.log(Level.FINEST, "Skipping transform of {0}. Classloader {1} is excluded.", internalClassName, classloader);
            return false;
        }
        if (internalClassName.startsWith("javax/crypto/")) {
            Agent.LOG.finest(MessageFormat.format("Instrumentation skipped by ''javax crypto'' rule: {0}", internalClassName));
            return false;
        }
        if (this.classNameFilter.isIncluded(internalClassName)) {
            Agent.LOG.log(Level.FINEST, "Class {0} is explicitly included", internalClassName);
            return true;
        }
        if (this.classNameFilter.isExcluded(internalClassName)) {
            Agent.LOG.log(Level.FINEST, "Skipping class {0} because it is excluded", internalClassName);
            return false;
        }
        return true;
    }

    public boolean isClassloaderExcluded(ClassLoader classloader) {
        String clName = null == classloader ? WeaveUtils.BOOTSTRAP_PLACEHOLDER.getClass().getName() : classloader.getClass().getName();
        for (String excludedEntry : this.classloaderExclusions) {
            if (!clName.startsWith(excludedEntry)) continue;
            return true;
        }
        return false;
    }

    public void addContextClassTransformer(ClassMatchVisitorFactory matchVisitor, ContextClassTransformer transformer) {
        if (transformer == null) {
            transformer = NO_OP_TRANSFORMER;
        }
        this.matchVisitors.put(matchVisitor, transformer);
    }

    public void removeMatchVisitor(ClassMatchVisitorFactory visitor) {
        this.matchVisitors.remove(visitor);
    }

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public ClassFileTransformer getJvmClassTransformer() {
        return this.jvmTransformer;
    }
}

