/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.mom.kafka;

import com.newrelic.agent.deps.org.apache.kafka.clients.producer.Callback;
import com.newrelic.agent.deps.org.apache.kafka.clients.producer.Producer;
import com.newrelic.agent.deps.org.apache.kafka.clients.producer.ProducerRecord;
import com.newrelic.agent.deps.org.apache.kafka.clients.producer.RecordMetadata;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.LoggerContext;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.AbstractManager;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.mom.kafka.DefaultKafkaProducerFactory;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.appender.mom.kafka.KafkaProducerFactory;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.Property;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.util.Log4jThread;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class KafkaManager
extends AbstractManager {
    public static final String DEFAULT_TIMEOUT_MILLIS = "30000";
    static KafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory();
    private final Properties config = new Properties();
    private Producer<byte[], byte[]> producer;
    private final int timeoutMillis;
    private final String topic;
    private final String key;
    private final boolean syncSend;

    public KafkaManager(LoggerContext loggerContext, String name, String topic, boolean syncSend, Property[] properties, String key) {
        super(loggerContext, name);
        this.topic = Objects.requireNonNull(topic, "topic");
        this.syncSend = syncSend;
        this.config.setProperty("key.serializer", "com.newrelic.agent.deps.org.apache.kafka.common.serialization.ByteArraySerializer");
        this.config.setProperty("value.serializer", "com.newrelic.agent.deps.org.apache.kafka.common.serialization.ByteArraySerializer");
        this.config.setProperty("batch.size", "0");
        for (Property property : properties) {
            this.config.setProperty(property.getName(), property.getValue());
        }
        this.key = key;
        this.timeoutMillis = Integer.parseInt(this.config.getProperty("timeout.ms", DEFAULT_TIMEOUT_MILLIS));
    }

    @Override
    public boolean releaseSub(long timeout, TimeUnit timeUnit) {
        if (timeout > 0L) {
            this.closeProducer(timeout, timeUnit);
        } else {
            this.closeProducer(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    private void closeProducer(long timeout, TimeUnit timeUnit) {
        if (this.producer != null) {
            Log4jThread closeThread = new Log4jThread(new Runnable(){

                @Override
                public void run() {
                    if (KafkaManager.this.producer != null) {
                        KafkaManager.this.producer.close();
                    }
                }
            }, "KafkaManager-CloseThread");
            closeThread.setDaemon(true);
            closeThread.start();
            try {
                closeThread.join(timeUnit.toMillis(timeout));
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void send(byte[] msg) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.producer != null) {
            byte[] newKey = null;
            if (this.key != null && this.key.contains("${")) {
                newKey = this.getLoggerContext().getConfiguration().getStrSubstitutor().replace(this.key).getBytes(StandardCharsets.UTF_8);
            } else if (this.key != null) {
                newKey = this.key.getBytes(StandardCharsets.UTF_8);
            }
            ProducerRecord newRecord = new ProducerRecord(this.topic, (Object)newKey, (Object)msg);
            if (this.syncSend) {
                Future response = this.producer.send(newRecord);
                response.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                this.producer.send(newRecord, new Callback(){

                    public void onCompletion(RecordMetadata metadata, Exception e) {
                        if (e != null) {
                            LOGGER.error("Unable to write to Kafka in appender [" + KafkaManager.this.getName() + "]", (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    public void startup() {
        this.producer = producerFactory.newKafkaProducer(this.config);
    }

    public String getTopic() {
        return this.topic;
    }
}

