/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.datastore.RecordSql;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.config.TransactionTracerConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class TransactionTracerConfigImpl
extends BaseConfig
implements TransactionTracerConfig {
    public static final String BACKGROUND_CATEGORY_NAME = "background";
    public static final String REQUEST_CATEGORY_NAME = "request";
    public static final String APDEX_F = "apdex_f";
    public static final String CATEGORY = "category";
    public static final String CATEGORY_NAME = "name";
    public static final String COLLECT_TRACES = "collect_traces";
    public static final String ENABLED = "enabled";
    public static final String EXPLAIN_ENABLED = "explain_enabled";
    public static final String EXPLAIN_THRESHOLD = "explain_threshold";
    public static final String GC_TIME_ENABLED = "gc_time_enabled";
    public static final String INSERT_SQL_MAX_LENGTH = "insert_sql_max_length";
    public static final String LOG_SQL = "log_sql";
    public static final String MAX_EXPLAIN_PLANS = "max_explain_plans";
    public static final String MAX_STACK_TRACE = "max_stack_trace";
    public static final String OBFUSCATED_SQL_FIELDS = "obfuscated_sql_fields";
    public static final String RECORD_SQL = "record_sql";
    @Deprecated
    public static final String SLOW_QUERY_WHITELIST = "slow_query_whitelist";
    public static final String COLLECT_SLOW_QUERIES_FROM = "collect_slow_queries_from";
    public static final String SEGMENT_LIMIT = "segment_limit";
    public static final String STACK_TRACE_THRESHOLD = "stack_trace_threshold";
    public static final String TOKEN_LIMIT = "token_limit";
    public static final String TOP_N = "top_n";
    public static final String TRANSACTION_THRESHOLD = "transaction_threshold";
    public static final String TAKE_LAST_STATUS = "take_last_status";
    public static final String STACK_BASED_NAMING = "stack_based_naming";
    public static final boolean DEFAULT_STACK_BASED_NAMING = false;
    public static final boolean DEFAULT_COLLECT_TRACES = false;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_EXPLAIN_ENABLED = true;
    public static final boolean DEFAULT_TAKE_LAST_STATUS = false;
    public static final double DEFAULT_EXPLAIN_THRESHOLD = 0.5;
    public static final boolean DEFAULT_GC_TIME_ENABLED = false;
    public static final int DEFAULT_INSERT_SQL_MAX_LENGTH = 2000;
    public static final boolean DEFAULT_LOG_SQL = false;
    public static final int DEFAULT_MAX_EXPLAIN_PLANS = 20;
    public static final int DEFAULT_MAX_STACK_TRACE = 20;
    public static final String DEFAULT_RECORD_SQL = "obfuscated";
    public static final int DEFAULT_SEGMENT_LIMIT = 3000;
    public static final double DEFAULT_STACK_TRACE_THRESHOLD = 0.5;
    public static final String DEFAULT_TRANSACTION_THRESHOLD = "apdex_f";
    public static final int DEFAULT_TOKEN_LIMIT = 3000;
    public static final int DEFAULT_TOP_N = 20;
    public static final int APDEX_F_MULTIPLE = 4;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.transaction_tracer.";
    public static final String CATEGORY_REQUEST_SYSTEM_PROPERTY_ROOT = "newrelic.config.transaction_tracer.category.request.";
    public static final String CATEGORY_BACKGROUND_SYSTEM_PROPERTY_ROOT = "newrelic.config.transaction_tracer.category.background.";
    private final boolean isEnabled;
    private final boolean isExplainEnabled;
    private final boolean isLogSql;
    private String recordSql;
    private final Set<String> collectSlowQueriesFromModules;
    private final double explainThreshold;
    private final double explainThresholdInNanos;
    private final double stackTraceThreshold;
    private final double stackTraceThresholdInNanos;
    private final long transactionThreshold;
    private final long transactionThresholdInNanos;
    private final int insertSqlMaxLength;
    private final boolean gcTimeEnabled;
    private final int maxStackTraces;
    private final int maxSegments;
    private final int maxExplainPlans;
    private final int maxTokens;
    private final int topN;
    protected final String inheritedFromSystemPropertyRoot;
    private final boolean stackBasedNamingEnabled;

    private TransactionTracerConfigImpl(String systemPropertyRoot, String inheritedFromSystemPropertyRoot, Map<String, Object> props, long apdexTInMillis, boolean highSecurity) {
        super(props, systemPropertyRoot);
        this.inheritedFromSystemPropertyRoot = inheritedFromSystemPropertyRoot;
        this.isEnabled = this.initEnabled();
        this.isLogSql = this.getProperty(LOG_SQL, false);
        this.recordSql = this.initRecordSql(highSecurity, props).intern();
        this.isExplainEnabled = this.initExplainEnabled(RecordSql.get((String)this.recordSql));
        this.collectSlowQueriesFromModules = this.initCollectSlowQueriesFrom(highSecurity);
        this.explainThreshold = this.getDoubleProperty(EXPLAIN_THRESHOLD, 0.5) * 1000.0;
        this.explainThresholdInNanos = TimeUnit.NANOSECONDS.convert((long)this.explainThreshold, TimeUnit.MILLISECONDS);
        this.stackTraceThreshold = this.getDoubleProperty(STACK_TRACE_THRESHOLD, 0.5) * 1000.0;
        this.stackTraceThresholdInNanos = TimeUnit.NANOSECONDS.convert((long)this.stackTraceThreshold, TimeUnit.MILLISECONDS);
        this.transactionThreshold = this.initTransactionThreshold(apdexTInMillis);
        this.transactionThresholdInNanos = TimeUnit.NANOSECONDS.convert(this.transactionThreshold, TimeUnit.MILLISECONDS);
        this.insertSqlMaxLength = this.getIntProperty(INSERT_SQL_MAX_LENGTH, 2000);
        this.gcTimeEnabled = this.getProperty(GC_TIME_ENABLED, false);
        this.maxStackTraces = this.getIntProperty(MAX_STACK_TRACE, 20);
        this.maxSegments = this.getIntProperty(SEGMENT_LIMIT, 3000);
        this.maxExplainPlans = this.getIntProperty(MAX_EXPLAIN_PLANS, 20);
        this.maxTokens = this.getIntProperty(TOKEN_LIMIT, 3000);
        this.topN = this.getIntProperty(TOP_N, 20);
        this.stackBasedNamingEnabled = this.getProperty(STACK_BASED_NAMING, false);
    }

    private boolean initEnabled() {
        boolean isEnabled = this.getProperty(ENABLED, true);
        boolean canCollectTraces = this.getProperty(COLLECT_TRACES, false);
        return isEnabled && canCollectTraces;
    }

    private boolean initExplainEnabled(RecordSql recordSql) {
        boolean isEnabled = this.getProperty(EXPLAIN_ENABLED, true);
        return isEnabled && !recordSql.equals((Object)RecordSql.off);
    }

    protected String initRecordSql(boolean highSecurity, Map<String, Object> props) {
        String output;
        String val = this.getProperty(RECORD_SQL, DEFAULT_RECORD_SQL);
        if (val instanceof Boolean) {
            output = "off";
        } else {
            output = this.getProperty(RECORD_SQL, DEFAULT_RECORD_SQL).toLowerCase();
            if (!this.getUniqueStrings(OBFUSCATED_SQL_FIELDS).isEmpty()) {
                Agent.LOG.log(Level.WARNING, "The {0} setting is no longer supported.  Full SQL obfuscation is enabled.", OBFUSCATED_SQL_FIELDS);
                output = DEFAULT_RECORD_SQL;
            }
        }
        if (highSecurity && !"off".equals(output)) {
            output = DEFAULT_RECORD_SQL;
        }
        return output;
    }

    protected Set<String> initCollectSlowQueriesFrom(boolean highSecurity) {
        if (highSecurity) {
            Collection<String> collectFromStrings = this.getUniqueStrings(COLLECT_SLOW_QUERIES_FROM);
            TransactionTracerConfigImpl.addDeprecatedProperty(new String[]{"transaction_tracer", SLOW_QUERY_WHITELIST}, new String[]{"transaction_tracer", COLLECT_SLOW_QUERIES_FROM});
            if (collectFromStrings.isEmpty()) {
                collectFromStrings = this.getUniqueStrings(SLOW_QUERY_WHITELIST);
            }
            return Collections.unmodifiableSet(new HashSet<String>(collectFromStrings));
        }
        return Collections.emptySet();
    }

    private long initTransactionThreshold(long apdexTInMillis) {
        String threshold = this.getProperty(TRANSACTION_THRESHOLD, "apdex_f");
        if ("apdex_f".equals(threshold)) {
            return apdexTInMillis * 4L;
        }
        Number transactionThreshold = (Number)this.getProperty(TRANSACTION_THRESHOLD);
        return (long)(transactionThreshold.doubleValue() * 1000.0);
    }

    private Map<String, Object> initCategorySettings(String category) {
        Set<Map<String, Object>> categories = this.getMapSet(CATEGORY);
        for (Map<String, Object> categoryProps : categories) {
            if (!category.equals(categoryProps.get(CATEGORY_NAME))) continue;
            return this.mergeSettings(this.getProperties(), categoryProps);
        }
        return this.getProperties();
    }

    private Map<String, Object> mergeSettings(Map<String, Object> localSettings, Map<String, Object> serverSettings) {
        Map<String, Object> mergedSettings = this.createMap();
        if (localSettings != null) {
            mergedSettings.putAll(localSettings);
        }
        if (serverSettings != null) {
            mergedSettings.putAll(serverSettings);
        }
        return mergedSettings;
    }

    protected String getInheritedSystemPropertyKey(String key) {
        return this.inheritedFromSystemPropertyRoot == null ? null : this.inheritedFromSystemPropertyRoot + key;
    }

    @Override
    protected Object getPropertyFromSystemProperties(String name, Object defaultVal) {
        String key = this.getSystemPropertyKey(name);
        Object value = TransactionTracerConfigImpl.parseValue(SystemPropertyFactory.getSystemPropertyProvider().getSystemProperty(key));
        if (value != null) {
            return value;
        }
        String inheritedKey = this.getInheritedSystemPropertyKey(name);
        return inheritedKey == null ? null : TransactionTracerConfigImpl.parseValue(SystemPropertyFactory.getSystemPropertyProvider().getSystemProperty(inheritedKey));
    }

    @Override
    protected Object getPropertyFromSystemEnvironment(String name, Object defaultVal) {
        String key = this.getSystemPropertyKey(name);
        Object value = TransactionTracerConfigImpl.parseValue(SystemPropertyFactory.getSystemPropertyProvider().getEnvironmentVariable(key));
        if (value != null) {
            return value;
        }
        String inheritedKey = this.getInheritedSystemPropertyKey(name);
        return inheritedKey == null ? null : TransactionTracerConfigImpl.parseValue(SystemPropertyFactory.getSystemPropertyProvider().getEnvironmentVariable(inheritedKey));
    }

    @Override
    public double getExplainThresholdInMillis() {
        return this.explainThreshold;
    }

    @Override
    public double getExplainThresholdInNanos() {
        return this.explainThresholdInNanos;
    }

    @Override
    public String getRecordSql() {
        return this.recordSql;
    }

    @Override
    public void setRecordSql(String recordSql) {
        this.recordSql = recordSql;
    }

    @Override
    public Set<String> getCollectSlowQueriesFromModules() {
        return this.collectSlowQueriesFromModules;
    }

    @Override
    public double getStackTraceThresholdInMillis() {
        return this.stackTraceThreshold;
    }

    @Override
    public double getStackTraceThresholdInNanos() {
        return this.stackTraceThresholdInNanos;
    }

    @Override
    public long getTransactionThresholdInMillis() {
        return this.transactionThreshold;
    }

    @Override
    public long getTransactionThresholdInNanos() {
        return this.transactionThresholdInNanos;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isExplainEnabled() {
        return this.isExplainEnabled;
    }

    @Override
    public int getMaxExplainPlans() {
        return this.maxExplainPlans;
    }

    @Override
    public int getTopN() {
        return this.topN;
    }

    @Override
    public boolean isLogSql() {
        return this.isLogSql;
    }

    @Override
    public boolean isGCTimeEnabled() {
        return this.gcTimeEnabled;
    }

    @Override
    public int getInsertSqlMaxLength() {
        return this.insertSqlMaxLength;
    }

    @Override
    public int getMaxStackTraces() {
        return this.maxStackTraces;
    }

    @Override
    public int getMaxSegments() {
        return this.maxSegments;
    }

    @Override
    public int getMaxTokens() {
        return this.maxTokens;
    }

    TransactionTracerConfigImpl createRequestTransactionTracerConfig(long apdexTInMillis, boolean highSecurity) {
        Map<String, Object> settings = this.initCategorySettings(REQUEST_CATEGORY_NAME);
        return new TransactionTracerConfigImpl(CATEGORY_REQUEST_SYSTEM_PROPERTY_ROOT, SYSTEM_PROPERTY_ROOT, settings, apdexTInMillis, highSecurity);
    }

    TransactionTracerConfigImpl createBackgroundTransactionTracerConfig(long apdexTInMillis, boolean highSecurity) {
        Map<String, Object> settings = this.initCategorySettings(BACKGROUND_CATEGORY_NAME);
        return new TransactionTracerConfigImpl(CATEGORY_BACKGROUND_SYSTEM_PROPERTY_ROOT, SYSTEM_PROPERTY_ROOT, settings, apdexTInMillis, highSecurity);
    }

    static TransactionTracerConfigImpl createTransactionTracerConfig(Map<String, Object> settings, long apdexTInMillis, boolean highSecurity) {
        return TransactionTracerConfigImpl.createTransactionTracerConfigImpl(settings, apdexTInMillis, highSecurity);
    }

    private static TransactionTracerConfigImpl createTransactionTracerConfigImpl(Map<String, Object> settings, long apdexTInMillis, boolean highSecurity) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new TransactionTracerConfigImpl(SYSTEM_PROPERTY_ROOT, null, settings, apdexTInMillis, highSecurity);
    }
}

