/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IBMUtils {
    private static final Pattern srNumberPattern = Pattern.compile("\\(SR([0-9]+)[^()]*\\)\\s*$");

    public static boolean getIbmWorkaroundDefault() {
        try {
            String jvmVendor = System.getProperty("java.vendor");
            if ("IBM Corporation".equals(jvmVendor)) {
                String jvmVersion = System.getProperty("java.specification.version", "");
                int srNum = IBMUtils.getIbmSRNumber();
                return !"1.7".equals(jvmVersion) || srNum < 4;
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static int getIbmSRNumber() {
        String runtimeVersion;
        Matcher matcher;
        if ("IBM Corporation".equals(System.getProperty("java.vendor")) && (matcher = srNumberPattern.matcher(runtimeVersion = System.getProperty("java.runtime.version", ""))).find()) {
            return Integer.valueOf(matcher.group(1));
        }
        return -1;
    }
}

