/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionConfigListener;
import com.newrelic.agent.DebugFlag;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigFactory;
import com.newrelic.agent.config.AgentConfigHelper;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.AuditModeConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.DatastoreConfig;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.JarCollectorConfig;
import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class ConfigServiceImpl
extends AbstractService
implements ConfigService,
ConnectionConfigListener,
HarvestListener {
    private static final String SANITIZED_SETTING = "****";
    private final List<AgentConfigListener> listeners = new CopyOnWriteArrayList<AgentConfigListener>();
    private final File configFile;
    private final Map<String, Object> localSettings;
    private long lastModified;
    private final ConcurrentMap<String, AgentConfig> agentConfigs = new ConcurrentHashMap<String, AgentConfig>();
    private volatile AgentConfig defaultAgentConfig;
    private volatile AgentConfig localAgentConfig;
    private volatile Map<String, Object> savedServerData;
    private volatile Map<String, Boolean> laspPolicies;
    private final String defaultAppName;
    private static Map<String, String> policiesToConfigs = ImmutableMap.builder().put("record_sql", "transaction_tracer.record_sql").put("attributes_include", "attributes.include").put("allow_raw_exception_messages", "strip_exception_messages.enabled").put("custom_events", "custom_insights_events.enabled").put("custom_parameters", "custom_parameters").put("custom_instrumentation_editor", "custom_instrumentation_editor").put("message_parameters", "message_parameters").build();

    protected ConfigServiceImpl(AgentConfig agentConfig, File configFile, Map<String, Object> localSettings) {
        super(ConfigService.class.getSimpleName());
        this.configFile = configFile;
        this.localSettings = localSettings == null ? Collections.emptyMap() : Collections.unmodifiableMap(localSettings);
        this.defaultAgentConfig = this.localAgentConfig = agentConfig;
        this.defaultAppName = this.defaultAgentConfig.getApplicationName();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        Object wait_for_customer_ssl;
        Object apdex_t;
        ServiceFactory.getRPMServiceManager().setConnectionConfigListener(this);
        if (this.configFile != null) {
            this.lastModified = this.configFile.lastModified();
            String msg = MessageFormat.format("Configuration file is {0}", this.configFile.getAbsolutePath());
            this.getLogger().info(msg);
        }
        if ((apdex_t = this.localAgentConfig.getProperty("apdex_t", null)) != null) {
            String msg = "The apdex_t setting is obsolete and is ignored! Set the apdex_t value for an application in New Relic UI";
            this.getLogger().warning(msg);
        }
        if ((wait_for_customer_ssl = this.localAgentConfig.getProperty("wait_for_customer_ssl", null)) != null) {
            String msg = "The wait_for_customer_ssl setting is obsolete and is ignored!";
            this.getLogger().warning(msg);
        }
        this.localAgentConfig.logDeprecatedProperties(this.localSettings);
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void addIAgentConfigListener(AgentConfigListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeIAgentConfigListener(AgentConfigListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Map<String, Object> getLocalSettings() {
        return this.localSettings;
    }

    @Override
    public Map<String, Object> getSanitizedLocalSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>(this.localSettings);
        if (settings.containsKey("proxy_host")) {
            settings.put("proxy_host", SANITIZED_SETTING);
        }
        if (settings.containsKey("proxy_user")) {
            settings.put("proxy_user", SANITIZED_SETTING);
        }
        if (settings.containsKey("proxy_password")) {
            settings.put("proxy_password", SANITIZED_SETTING);
        }
        return settings;
    }

    @Override
    public AgentConfig getDefaultAgentConfig() {
        return this.defaultAgentConfig;
    }

    @Override
    public AgentConfig getLocalAgentConfig() {
        return this.localAgentConfig;
    }

    @Override
    public AgentConfig getAgentConfig(String appName) {
        return this.getOrCreateAgentConfig(appName);
    }

    @Override
    public TransactionTracerConfig getTransactionTracerConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getTransactionTracerConfig();
    }

    @Override
    public ErrorCollectorConfig getErrorCollectorConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getErrorCollectorConfig();
    }

    @Override
    public JarCollectorConfig getJarCollectorConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getJarCollectorConfig();
    }

    @Override
    public StripExceptionConfig getStripExceptionConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getStripExceptionConfig();
    }

    @Override
    public DatastoreConfig getDatastoreConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getDatastoreConfig();
    }

    @Override
    public void setLaspPolicies(Map<String, Boolean> policiesJson) {
        this.laspPolicies = ConfigServiceImpl.convertToAgentConfig(policiesJson);
    }

    @Override
    public DistributedTracingConfig getDistributedTracingConfig(String appName) {
        return this.getOrCreateAgentConfig(appName).getDistributedTracingConfig();
    }

    private void checkConfigFile() throws Exception {
        if (this.configFile == null || this.configFile.lastModified() == this.lastModified) {
            return;
        }
        Agent.LOG.info("Re-reading New Relic configuration file");
        this.lastModified = this.configFile.lastModified();
        HashMap<String, Object> settings = new HashMap<String, Object>(AgentConfigHelper.getConfigurationFileSettings(this.configFile));
        this.localAgentConfig = AgentConfigFactory.createAgentConfig(settings, this.savedServerData, this.laspPolicies);
        this.updateDynamicAuditAndLogConfig(this.localAgentConfig, settings);
        this.replaceServerConfig(this.defaultAppName, settings, this.savedServerData, this.laspPolicies);
    }

    private void updateDynamicAuditAndLogConfig(AgentConfig localAgentConfig, Map<String, Object> settings) {
        AuditModeConfig auditModeConfig = localAgentConfig.getAuditModeConfig();
        if (auditModeConfig != null) {
            Set<String> auditModeEndpoints = auditModeConfig.getEndpoints();
            if (auditModeEndpoints == null) {
                settings.put("audit_mode", localAgentConfig.isAuditMode());
            } else {
                HashMap<String, Object> auditModeData = new HashMap<String, Object>();
                auditModeData.put("enabled", localAgentConfig.getAuditModeConfig().isEnabled());
                auditModeData.put("endpoints", localAgentConfig.getAuditModeConfig().getEndpoints());
                settings.put("audit_mode", auditModeData);
            }
        }
        settings.put("log_level", localAgentConfig.getLogLevel());
        DebugFlag.updateEnabledStates(localAgentConfig);
        AgentLogManager.setLogLevel(localAgentConfig.getLogLevel());
    }

    private void notifyListeners(String appName, AgentConfig agentConfig) {
        for (AgentConfigListener listener : this.listeners) {
            listener.configChanged(appName, agentConfig);
        }
    }

    private AgentConfig getOrCreateAgentConfig(String appName) {
        AgentConfig agentConfig = this.findAgentConfig(appName);
        if (agentConfig != null) {
            return agentConfig;
        }
        agentConfig = AgentConfigFactory.createAgentConfig(this.localSettings, null, this.laspPolicies);
        AgentConfig oldAgentConfig = this.agentConfigs.putIfAbsent(appName, agentConfig);
        return oldAgentConfig == null ? agentConfig : oldAgentConfig;
    }

    private AgentConfig findAgentConfig(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultAgentConfig;
        }
        return (AgentConfig)this.agentConfigs.get(appName);
    }

    private AgentConfig createAgentConfig(String appName, Map<String, Object> localSettings, Map<String, Object> serverData, Map<String, Boolean> laspData) {
        try {
            return AgentConfigFactory.createAgentConfig(localSettings, serverData, laspData);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Error configuring application \"{0}\" with server data \"{1}\": {2}", appName, serverData, e);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            } else {
                Agent.LOG.warning(msg);
            }
            return null;
        }
    }

    private AgentConfig replaceServerConfig(String appName, Map<String, Object> localSettings, Map<String, Object> serverData, Map<String, Boolean> laspData) {
        AgentConfig agentConfig;
        if (Agent.LOG.isLoggable(Level.FINER)) {
            if (laspData == null || laspData.isEmpty()) {
                Agent.LOG.finer(MessageFormat.format("Received New Relic data for {0}:  server data {1}, lasp data {2}", appName, serverData, laspData));
            } else {
                Agent.LOG.finer(MessageFormat.format("Received New Relic data for {0}:  server data {1}", appName, serverData));
            }
        }
        if ((agentConfig = this.createAgentConfig(appName, localSettings, serverData, laspData)) == null) {
            return null;
        }
        if (appName == null || appName.equals(this.defaultAppName)) {
            this.defaultAgentConfig = agentConfig;
        } else {
            this.agentConfigs.put(appName, agentConfig);
        }
        this.logIfHighSecurityServerAndLocal(appName, agentConfig, serverData);
        this.notifyListeners(appName, agentConfig);
        return agentConfig;
    }

    private void logIfHighSecurityServerAndLocal(String appName, AgentConfig agentConfig, Map<String, Object> serverData) {
        if (agentConfig.isHighSecurity() && serverData.containsKey("high_security")) {
            String msg = MessageFormat.format("The agent is in high security mode for {0}: {1} setting is \"{2}\". {3} setting is \"{4}\". Disabling the collection of request parameters, message queue parameters, and user attributes.", appName, "transaction_tracer.record_sql", agentConfig.getTransactionTracerConfig().getRecordSql(), "ssl", agentConfig.isSSL());
            Agent.LOG.info(msg);
        }
    }

    @Override
    public AgentConfig connected(IRPMService rpmService, Map<String, Object> serverData) {
        String appName = rpmService.getApplicationName();
        this.savedServerData = new HashMap<String, Object>(serverData);
        return this.replaceServerConfig(appName, this.localSettings, serverData, this.laspPolicies);
    }

    public static Map<String, Boolean> convertToAgentConfig(Map<String, Boolean> laspPolicies) {
        if (laspPolicies == null) {
            return null;
        }
        HashMap<String, Boolean> agentFormat = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> entry : laspPolicies.entrySet()) {
            String configName = policiesToConfigs.get(entry.getKey());
            if (configName == null) continue;
            if (entry.getKey().equals("allow_raw_exception_messages")) {
                agentFormat.put(configName, entry.getValue() == false);
                continue;
            }
            agentFormat.put(configName, entry.getValue());
        }
        return agentFormat;
    }

    @Override
    public void afterHarvest(String appName) {
        if (!appName.equals(this.defaultAppName)) {
            return;
        }
        try {
            this.checkConfigFile();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Unexpected exception checking for config file changes: {0}", t.toString());
            this.getLogger().warning(msg);
        }
        ServiceFactory.getClassTransformerService().checkShutdown();
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
    }
}

