/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.HeadersUtil;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.api.agent.ExtendedInboundHeaders;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class DeobfuscatedInboundHeaders
extends ExtendedInboundHeaders {
    private InboundHeaders delegate;
    private String encodingKey;

    public DeobfuscatedInboundHeaders(InboundHeaders headers, String encodingKey) {
        this.delegate = headers;
        this.encodingKey = encodingKey;
    }

    public HeaderType getHeaderType() {
        return this.delegate.getHeaderType();
    }

    public String getHeader(String name) {
        if (this.encodingKey == null && !this.isDistributedTraceHeader(name)) {
            return null;
        }
        if (HeadersUtil.NEWRELIC_HEADERS.contains(name)) {
            String obfuscatedValue = this.getObfuscatedValue(name);
            if (obfuscatedValue == null) {
                return null;
            }
            try {
                return Obfuscator.deobfuscateNameUsingKey(obfuscatedValue, this.encodingKey);
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return this.getObfuscatedValue(name);
    }

    private String getObfuscatedValue(String name) {
        String obfuscatedValue = this.delegate.getHeader(name);
        if (obfuscatedValue == null) {
            obfuscatedValue = this.delegate.getHeader(name.toUpperCase());
        }
        if (obfuscatedValue == null) {
            obfuscatedValue = this.delegate.getHeader(name.toLowerCase());
        }
        return obfuscatedValue;
    }

    public List<String> getHeaders(String name) {
        if (!(this.delegate instanceof ExtendedInboundHeaders)) {
            return null;
        }
        ExtendedInboundHeaders extendedDelegate = (ExtendedInboundHeaders)this.delegate;
        if (this.encodingKey == null && !this.isDistributedTraceHeader(name)) {
            return null;
        }
        if (HeadersUtil.NEWRELIC_HEADERS.contains(name)) {
            List<String> values = this.getObfuscatedValues(name, extendedDelegate);
            if (values == null) {
                return null;
            }
            ArrayList<String> obfuscatedValues = new ArrayList<String>(values.size());
            for (String value : values) {
                try {
                    obfuscatedValues.add(Obfuscator.deobfuscateNameUsingKey(value, this.encodingKey));
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
            return obfuscatedValues;
        }
        return this.getObfuscatedValues(name, extendedDelegate);
    }

    private List<String> getObfuscatedValues(String name, ExtendedInboundHeaders extendedDelegate) {
        List values = extendedDelegate.getHeaders(name);
        if (values == null) {
            values = extendedDelegate.getHeaders(name.toUpperCase());
        }
        if (values == null) {
            values = extendedDelegate.getHeaders(name.toLowerCase());
        }
        return values;
    }

    private boolean isDistributedTraceHeader(String name) {
        return name.equalsIgnoreCase("newrelic") || name.equalsIgnoreCase("newrelic") || name.equalsIgnoreCase("traceparent") || name.equalsIgnoreCase("tracestate");
    }
}

