/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.GeneratorAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.RemappingMethodAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.SimpleRemapper;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.weave.MethodCallInlinerAdapter;
import com.newrelic.weave.PreparedExtension;
import com.newrelic.weave.PreparedMatch;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.weavepackage.AnnotationProxyTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class MethodProcessors {
    private static final AtomicLong uniqueIdGenerator = new AtomicLong(0L);

    private MethodProcessors() {
    }

    public static MethodNode inlineMethods(String inlineOwnerClassName, Iterable<MethodNode> inlineMethods, String subjectOwnerClassName, MethodNode subjectMethod) {
        MethodNode result = WeaveUtils.newMethodNode(subjectMethod);
        subjectMethod.accept(MethodProcessors.getInlineMethodsVisitor(subjectOwnerClassName, subjectMethod.access, subjectMethod.name, subjectMethod.desc, result, inlineOwnerClassName, inlineMethods));
        return result;
    }

    public static MethodVisitor getInlineMethodsVisitor(String owner, int access, String name, String desc, MethodVisitor delegate, final String inlineOwnerClassName, final Iterable<MethodNode> inlineMethods) {
        return new MethodCallInlinerAdapter(owner, access, name, desc, delegate, false){

            @Override
            protected MethodCallInlinerAdapter.InlinedMethod mustInline(String owner, String name, String desc) {
                if (owner.equals(inlineOwnerClassName)) {
                    for (MethodNode methodToInline : inlineMethods) {
                        if (!methodToInline.name.equals(name) || !desc.equals(methodToInline.desc)) continue;
                        return new MethodCallInlinerAdapter.InlinedMethod(methodToInline, WeaveUtils.NO_OP_REMAPPER);
                    }
                }
                return null;
            }
        };
    }

    public static MethodNode updateOwner(MethodNode subjectMethod, final String newOwnerClassName, final String oldOwnerClassName, final Collection<Method> methodsToUpdate, final Collection<String> fieldsToUpdate) {
        if (newOwnerClassName.equals(oldOwnerClassName)) {
            return subjectMethod;
        }
        MethodNode result = WeaveUtils.newMethodNode(subjectMethod);
        subjectMethod.accept(new MethodVisitor(458752, result){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (owner.equals(oldOwnerClassName) && fieldsToUpdate.contains(name)) {
                    super.visitFieldInsn(opcode, newOwnerClassName, name, desc);
                } else {
                    super.visitFieldInsn(opcode, owner, name, desc);
                }
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (owner.equals(oldOwnerClassName) && methodsToUpdate.contains(new Method(name, desc))) {
                    super.visitMethodInsn(opcode, newOwnerClassName, name, desc, itf);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }

            @Override
            public void visitLdcInsn(Object cst) {
                if (cst instanceof Type && oldOwnerClassName.equals(((Type)cst).getInternalName())) {
                    super.visitLdcInsn(Type.getType("L" + newOwnerClassName + ";"));
                    return;
                }
                super.visitLdcInsn(cst);
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (oldOwnerClassName.equals(type)) {
                    super.visitTypeInsn(opcode, newOwnerClassName);
                    return;
                }
                super.visitTypeInsn(opcode, type);
            }
        });
        return result;
    }

    public static MethodNode updateTypes(MethodNode subjectMethod, Map<String, String> typeMap) {
        MethodNode result = WeaveUtils.newMethodNode(subjectMethod);
        RemappingMethodAdapter typeRemapper = new RemappingMethodAdapter(subjectMethod.access, subjectMethod.desc, result, new SimpleRemapper(typeMap));
        subjectMethod.accept(typeRemapper);
        return result;
    }

    public static MethodNode updateConstructorArgsForInnerClass(MethodNode weaveMethod, final String weaveClassName, String originalClassName, final Set<String> innerClassNames) {
        MethodNode result = WeaveUtils.newMethodNode(weaveMethod);
        final Type originalType = Type.getObjectType(originalClassName);
        MethodVisitor anonInitArgRemapper = new MethodVisitor(458752, result){

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (name.equals("<init>") && innerClassNames.contains(owner)) {
                    Type[] args = Type.getArgumentTypes(desc);
                    for (int i = 0; i < args.length; ++i) {
                        int sort = args[i].getSort();
                        if (sort != 10 || !args[i].getInternalName().equals(weaveClassName)) continue;
                        args[i] = originalType;
                    }
                    desc = Type.getMethodDescriptor(Type.VOID_TYPE, args);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        };
        weaveMethod.accept(anonInitArgRemapper);
        return result;
    }

    public static MethodNode removeJSRInstructions(MethodNode subjectMethod) {
        MethodNode result = WeaveUtils.newMethodNode(subjectMethod);
        subjectMethod.accept(new JSRInlinerAdapter(result, subjectMethod.access, subjectMethod.name, subjectMethod.desc, subjectMethod.signature, subjectMethod.exceptions.toArray(new String[subjectMethod.exceptions.size()])));
        return result;
    }

    public static MethodNode removeLineNumbers(MethodNode subjectMethod) {
        MethodNode result = WeaveUtils.newMethodNode(subjectMethod);
        subjectMethod.accept(new MethodVisitor(458752, result){

            @Override
            public void visitLineNumber(int line, Label start) {
            }
        });
        return result;
    }

    public static MethodNode extractConstructorInstructionsAfterInit(MethodNode ctor) {
        MethodNode result = WeaveUtils.copy(ctor);
        while (result.instructions.size() > 0) {
            boolean nextInsnIsConstructor;
            AbstractInsnNode insn = result.instructions.getFirst();
            result.instructions.remove(insn);
            if (insn.getType() != 5) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            AbstractInsnNode nextInsn = result.instructions.getFirst();
            boolean isConstructor = "<init>".equals(methodInsn.name);
            boolean bl = nextInsnIsConstructor = nextInsn != null && nextInsn.getType() == 5 && "<init>".equals(((MethodInsnNode)nextInsn).name);
            if (!isConstructor || nextInsnIsConstructor) continue;
            break;
        }
        return result;
    }

    public static MethodNode addWeaveConstructorInvocationsAtEveryReturn(final MethodNode weaveCtor, final String weaveClassName, String originalClassName, MethodNode targetCtor, final boolean isNonstaticInnerTarget) {
        MethodNode composite = WeaveUtils.newMethodNode(targetCtor);
        targetCtor.accept(new MethodVisitor(458752, composite){

            @Override
            public void visitInsn(int opcode) {
                if (opcode == 177) {
                    this.visitVarInsn(25, 0);
                    int index = isNonstaticInnerTarget ? 2 : 1;
                    for (Type argType : Type.getArgumentTypes(weaveCtor.desc)) {
                        this.visitVarInsn(argType.getOpcode(21), index);
                        index += argType.getSize();
                    }
                    this.visitMethodInsn(182, weaveClassName, weaveCtor.name, weaveCtor.desc, false);
                }
                super.visitInsn(opcode);
            }
        });
        return composite;
    }

    public static ClassVisitor fixInvocationInstructions(ClassVisitor cv, final Map<String, MatchType> weaveMatches) {
        return new ClassVisitor(458752, cv){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(458752, mv){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        MatchType matchType;
                        if (opcode == 182 && (matchType = (MatchType)((Object)weaveMatches.get(owner))) == MatchType.Interface) {
                            itf = true;
                            opcode = 185;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                };
            }
        };
    }

    public static ClassVisitor replaceGetImplementationTitle(ClassVisitor cv, final String implementationTitle) {
        final Method getTitleMethod = new Method("getImplementationTitle", Type.getType(String.class), new Type[0]);
        return new ClassVisitor(458752, cv){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(458752, mv){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (owner.equals(WeaveUtils.WEAVER_TYPE.getInternalName()) && name.equals(getTitleMethod.getName()) && desc.equals(getTitleMethod.getDescriptor())) {
                            super.visitLdcInsn(implementationTitle);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                        }
                    }
                };
            }
        };
    }

    public static void rewriteNewFieldCalls(String weaveClassName, Map<Method, MethodNode> methodsToRewrite, Set<String> newFieldNames, Set<String> matchedFieldNames, List<PreparedExtension> preparedExtensions, List<PreparedMatch> superPreparedMatches) {
        MethodProcessors.rewriteSuperNewFieldOwners(weaveClassName, methodsToRewrite.values(), newFieldNames, matchedFieldNames, superPreparedMatches);
        for (MethodNode weaveMethod : methodsToRewrite.values()) {
            for (PreparedExtension extension : preparedExtensions) {
                extension.rewriteNewFieldCalls(weaveMethod);
            }
        }
    }

    private static void rewriteSuperNewFieldOwners(String weaveClassName, Collection<MethodNode> methodsToRewrite, Set<String> newFieldNames, Set<String> matchedFieldNames, List<PreparedMatch> superPreparedMatches) {
        for (MethodNode methodNode : methodsToRewrite) {
            block1: for (AbstractInsnNode current = methodNode.instructions.getFirst(); null != current; current = current.getNext()) {
                if (current.getType() != 4) continue;
                FieldInsnNode fieldInsn = (FieldInsnNode)current;
                if (!weaveClassName.equals(fieldInsn.owner) || newFieldNames.contains(fieldInsn.name) || matchedFieldNames.contains(fieldInsn.name)) continue;
                for (PreparedMatch superMatch : superPreparedMatches) {
                    if (!superMatch.getNewFields().contains(fieldInsn.name)) continue;
                    fieldInsn.owner = superMatch.getWeaveName();
                    continue block1;
                }
            }
        }
    }

    public static MethodNode removeReturnInstructions(MethodNode subjectMethod) {
        MethodNode result = WeaveUtils.newMethodNode(subjectMethod);
        subjectMethod.accept(new MethodVisitor(458752, result){

            @Override
            public void visitInsn(int opcode) {
                if (opcode == 177) {
                    return;
                }
                super.visitInsn(opcode);
            }
        });
        return result;
    }

    static MethodNode renameGetAnnotationCalls(MethodNode preparedMethod, final ClassNode originalClass, final Collection<AnnotationNode> classAnnotations, final Collection<AnnotationNode> methodAnnotations, final Map<String, ClassNode> annotationProxyClasses) {
        MethodNode originalMethod = WeaveUtils.findMatch(originalClass.methods, preparedMethod.name, preparedMethod.desc);
        if (originalMethod != null) {
            MethodNode result = WeaveUtils.newMethodNode(preparedMethod);
            preparedMethod.accept(new GeneratorAdapter(458752, result, result.access, result.name, result.desc){
                private Object previousLdc;

                @Override
                public void visitLdcInsn(Object cst) {
                    this.previousLdc = cst;
                    super.visitLdcInsn(cst);
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (WeaveUtils.isClassAnnotationGetter(owner, name, desc)) {
                        for (AnnotationNode node : classAnnotations) {
                            if (this.previousLdc == null || !node.desc.equals(this.previousLdc.toString())) continue;
                            this.pop();
                            MethodProcessors.generateAndLoadAnnotationProxyOnStack(this, node, originalClass.name, annotationProxyClasses);
                            this.previousLdc = null;
                            return;
                        }
                        this.pop();
                        this.visitInsn(1);
                    } else if (WeaveUtils.isMethodAnnotationGetter(owner, name, desc)) {
                        for (AnnotationNode node : methodAnnotations) {
                            if (this.previousLdc == null || !node.desc.equals(this.previousLdc.toString())) continue;
                            this.pop();
                            MethodProcessors.generateAndLoadAnnotationProxyOnStack(this, node, originalClass.name, annotationProxyClasses);
                            this.previousLdc = null;
                            return;
                        }
                        this.pop();
                        this.visitInsn(1);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                    this.previousLdc = null;
                }
            });
            return result;
        }
        return preparedMethod;
    }

    private static void loadOnStack(Object value, GeneratorAdapter adapter, String className, Map<String, ClassNode> annotationProxyClasses) {
        block34: {
            block44: {
                ArrayList values;
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                block50: {
                                    block49: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block45: {
                                                        block43: {
                                                            block42: {
                                                                block41: {
                                                                    block40: {
                                                                        block39: {
                                                                            block38: {
                                                                                block37: {
                                                                                    block36: {
                                                                                        block35: {
                                                                                            block33: {
                                                                                                if (value == null) {
                                                                                                    adapter.visitInsn(1);
                                                                                                }
                                                                                                if (value instanceof String) {
                                                                                                    adapter.push((String)value);
                                                                                                }
                                                                                                if (!(value instanceof Boolean)) break block33;
                                                                                                adapter.push((Boolean)value);
                                                                                                adapter.box(Type.BOOLEAN_TYPE);
                                                                                                break block34;
                                                                                            }
                                                                                            if (!(value instanceof Integer)) break block35;
                                                                                            adapter.push((Integer)value);
                                                                                            adapter.box(Type.INT_TYPE);
                                                                                            break block34;
                                                                                        }
                                                                                        if (!(value instanceof Long)) break block36;
                                                                                        adapter.push((Long)value);
                                                                                        adapter.box(Type.LONG_TYPE);
                                                                                        break block34;
                                                                                    }
                                                                                    if (!(value instanceof Float)) break block37;
                                                                                    adapter.push(((Float)value).floatValue());
                                                                                    adapter.box(Type.FLOAT_TYPE);
                                                                                    break block34;
                                                                                }
                                                                                if (!(value instanceof Double)) break block38;
                                                                                adapter.push((Double)value);
                                                                                adapter.box(Type.DOUBLE_TYPE);
                                                                                break block34;
                                                                            }
                                                                            if (!(value instanceof Byte)) break block39;
                                                                            adapter.push(((Byte)value).intValue());
                                                                            adapter.box(Type.BYTE_TYPE);
                                                                            break block34;
                                                                        }
                                                                        if (!(value instanceof Character)) break block40;
                                                                        adapter.push(((Character)value).charValue());
                                                                        adapter.box(Type.CHAR_TYPE);
                                                                        break block34;
                                                                    }
                                                                    if (!(value instanceof Short)) break block41;
                                                                    adapter.push(((Short)value).shortValue());
                                                                    adapter.box(Type.SHORT_TYPE);
                                                                    break block34;
                                                                }
                                                                if (!(value instanceof String[])) break block42;
                                                                String[] casted = (String[])value;
                                                                Type castType = Type.getType(casted[0]);
                                                                adapter.getStatic(castType, casted[1], castType);
                                                                break block34;
                                                            }
                                                            if (!(value instanceof AnnotationNode)) break block43;
                                                            MethodProcessors.generateAndLoadAnnotationProxyOnStack(adapter, (AnnotationNode)value, className, annotationProxyClasses);
                                                            break block34;
                                                        }
                                                        if (!(value instanceof ArrayList)) break block44;
                                                        values = (ArrayList)value;
                                                        if (!(values.get(0) instanceof String)) break block45;
                                                        adapter.push(values.size());
                                                        adapter.visitTypeInsn(189, Type.getType(String.class).getInternalName());
                                                        for (int i = 0; i < values.size(); ++i) {
                                                            adapter.visitInsn(89);
                                                            adapter.push(i);
                                                            adapter.visitLdcInsn(values.get(i));
                                                            adapter.visitInsn(83);
                                                        }
                                                        break block34;
                                                    }
                                                    if (!(values.get(0) instanceof Integer)) break block46;
                                                    adapter.push(values.size());
                                                    adapter.newArray(Type.INT_TYPE);
                                                    for (int i = 0; i < values.size(); ++i) {
                                                        adapter.dup();
                                                        adapter.push(i);
                                                        adapter.push((Integer)values.get(i));
                                                        adapter.arrayStore(Type.INT_TYPE);
                                                    }
                                                    break block34;
                                                }
                                                if (!(values.get(0) instanceof Double)) break block47;
                                                adapter.push(values.size());
                                                adapter.newArray(Type.DOUBLE_TYPE);
                                                for (int i = 0; i < values.size(); ++i) {
                                                    adapter.dup();
                                                    adapter.push(i);
                                                    adapter.push((Double)values.get(i));
                                                    adapter.arrayStore(Type.DOUBLE_TYPE);
                                                }
                                                break block34;
                                            }
                                            if (!(values.get(0) instanceof Short)) break block48;
                                            adapter.push(values.size());
                                            adapter.newArray(Type.SHORT_TYPE);
                                            for (int i = 0; i < values.size(); ++i) {
                                                adapter.dup();
                                                adapter.push(i);
                                                adapter.push(((Short)values.get(i)).shortValue());
                                                adapter.arrayStore(Type.SHORT_TYPE);
                                            }
                                            break block34;
                                        }
                                        if (!(values.get(0) instanceof Float)) break block49;
                                        adapter.push(values.size());
                                        adapter.newArray(Type.FLOAT_TYPE);
                                        for (int i = 0; i < values.size(); ++i) {
                                            adapter.dup();
                                            adapter.push(i);
                                            adapter.push(((Float)values.get(i)).floatValue());
                                            adapter.arrayStore(Type.FLOAT_TYPE);
                                        }
                                        break block34;
                                    }
                                    if (!(values.get(0) instanceof Byte)) break block50;
                                    adapter.push(values.size());
                                    adapter.newArray(Type.BYTE_TYPE);
                                    for (int i = 0; i < values.size(); ++i) {
                                        adapter.dup();
                                        adapter.push(i);
                                        adapter.push(((Byte)values.get(i)).byteValue());
                                        adapter.arrayStore(Type.BYTE_TYPE);
                                    }
                                    break block34;
                                }
                                if (!(values.get(0) instanceof Character)) break block51;
                                adapter.push(values.size());
                                adapter.newArray(Type.CHAR_TYPE);
                                for (int i = 0; i < values.size(); ++i) {
                                    adapter.dup();
                                    adapter.push(i);
                                    adapter.push(((Character)values.get(i)).charValue());
                                    adapter.arrayStore(Type.CHAR_TYPE);
                                }
                                break block34;
                            }
                            if (!(values.get(0) instanceof Boolean)) break block52;
                            adapter.push(values.size());
                            adapter.newArray(Type.BOOLEAN_TYPE);
                            for (int i = 0; i < values.size(); ++i) {
                                adapter.dup();
                                adapter.push(i);
                                adapter.push((Boolean)values.get(i));
                                adapter.arrayStore(Type.BOOLEAN_TYPE);
                            }
                            break block34;
                        }
                        if (!(values.get(0) instanceof Long)) break block53;
                        adapter.push(values.size());
                        adapter.newArray(Type.LONG_TYPE);
                        for (int i = 0; i < values.size(); ++i) {
                            adapter.dup();
                            adapter.push(i);
                            adapter.push((Long)values.get(i));
                            adapter.arrayStore(Type.LONG_TYPE);
                        }
                        break block34;
                    }
                    if (!(values.get(0) instanceof AnnotationNode)) break block54;
                    adapter.push(values.size());
                    adapter.visitTypeInsn(189, Type.getType(((AnnotationNode)values.get((int)0)).desc).getInternalName());
                    for (int i = 0; i < values.size(); ++i) {
                        adapter.visitInsn(89);
                        adapter.push(i);
                        MethodProcessors.generateAndLoadAnnotationProxyOnStack(adapter, (AnnotationNode)values.get(i), className, annotationProxyClasses);
                        adapter.visitInsn(83);
                    }
                    break block34;
                }
                if (!(values.get(0) instanceof String[])) break block34;
                adapter.push(values.size());
                adapter.visitTypeInsn(189, Type.getType(((String[])values.get(0))[0]).getInternalName());
                for (int i = 0; i < values.size(); ++i) {
                    adapter.visitInsn(89);
                    adapter.push(i);
                    String[] valueArray = (String[])values.get(i);
                    adapter.getStatic(Type.getObjectType(Type.getType(valueArray[0]).getInternalName()), valueArray[1], Type.getType(valueArray[0]));
                    adapter.visitInsn(83);
                }
                break block34;
            }
            if (value instanceof int[]) {
                int[] nums = (int[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.INT_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.INT_TYPE);
                }
            } else if (value instanceof double[]) {
                double[] nums = (double[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.DOUBLE_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.DOUBLE_TYPE);
                }
            } else if (value instanceof float[]) {
                float[] nums = (float[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.FLOAT_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.FLOAT_TYPE);
                }
            } else if (value instanceof short[]) {
                short[] nums = (short[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.SHORT_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.SHORT_TYPE);
                }
            } else if (value instanceof char[]) {
                char[] nums = (char[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.CHAR_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.CHAR_TYPE);
                }
            } else if (value instanceof byte[]) {
                byte[] nums = (byte[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.BYTE_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.BYTE_TYPE);
                }
            } else if (value instanceof long[]) {
                long[] nums = (long[])value;
                adapter.push(nums.length);
                adapter.newArray(Type.LONG_TYPE);
                for (int i = 0; i < nums.length; ++i) {
                    adapter.dup();
                    adapter.push(i);
                    adapter.push(nums[i]);
                    adapter.arrayStore(Type.LONG_TYPE);
                }
            }
        }
    }

    private static void generateAndLoadAnnotationProxyOnStack(GeneratorAdapter generatorAdapter, AnnotationNode node, String className, Map<String, ClassNode> annotationProxyClasses) {
        String annotationProxyClassName = className + "$AnnotationHolder_" + uniqueIdGenerator.incrementAndGet();
        ClassNode annotationProxyTemplate = MethodProcessors.getAnnotationProxyTemplate();
        if (annotationProxyTemplate == null) {
            return;
        }
        annotationProxyTemplate = WeaveUtils.copyAndRename(annotationProxyTemplate, "com/newrelic/weave/weavepackage/AnnotationProxyTemplate", annotationProxyClassName);
        annotationProxyClasses.put(annotationProxyClassName, annotationProxyTemplate);
        generatorAdapter.visitLdcInsn(Type.getType("L" + className + ";"));
        generatorAdapter.visitLdcInsn(Type.getType(node.desc));
        int annotationValuesSize = 0;
        if (node.values != null) {
            annotationValuesSize = node.values.size();
        }
        generatorAdapter.push(annotationValuesSize);
        generatorAdapter.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < annotationValuesSize; ++i) {
            generatorAdapter.visitInsn(89);
            generatorAdapter.push(i);
            MethodProcessors.loadOnStack(node.values.get(i), generatorAdapter, className, annotationProxyClasses);
            generatorAdapter.visitInsn(83);
        }
        generatorAdapter.visitMethodInsn(184, annotationProxyClassName, "getOrCreateAnnotationHolder", "(Ljava/lang/Class;Ljava/lang/Class;[Ljava/lang/Object;)Ljava/lang/annotation/Annotation;", false);
    }

    private static ClassNode getAnnotationProxyTemplate() {
        try {
            return WeaveUtils.convertToClassNode(WeaveUtils.getClassBytesFromClassLoaderResource(AnnotationProxyTemplate.class.getName(), AnnotationProxyTemplate.class.getClassLoader()));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

