/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.StatsBase;
import java.util.concurrent.TimeUnit;

public class ResponseTimeStatsImpl
extends AbstractStats
implements ResponseTimeStats {
    private static final long NANOSECONDS_PER_SECOND_SQUARED = 1000000000000000000L;
    private long total;
    private long totalExclusive;
    private long minValue;
    private long maxValue;
    private double sumOfSquares;

    protected ResponseTimeStatsImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ResponseTimeStatsImpl newStats = new ResponseTimeStatsImpl();
        newStats.count = this.count;
        newStats.total = this.total;
        newStats.totalExclusive = this.totalExclusive;
        newStats.minValue = this.minValue;
        newStats.maxValue = this.maxValue;
        newStats.sumOfSquares = this.sumOfSquares;
        return newStats;
    }

    @Override
    public void recordResponseTime(long responseTime, TimeUnit timeUnit) {
        long responseTimeInNanos = TimeUnit.NANOSECONDS.convert(responseTime, timeUnit);
        this.recordResponseTimeInNanos(responseTimeInNanos, responseTimeInNanos);
    }

    @Override
    public void recordResponseTime(long responseTime, long exclusiveTime, TimeUnit timeUnit) {
        long responseTimeInNanos = TimeUnit.NANOSECONDS.convert(responseTime, timeUnit);
        long exclusiveTimeInNanos = TimeUnit.NANOSECONDS.convert(exclusiveTime, timeUnit);
        this.recordResponseTimeInNanos(responseTimeInNanos, exclusiveTimeInNanos);
    }

    @Override
    public void recordResponseTimeInNanos(long responseTime) {
        this.recordResponseTimeInNanos(responseTime, responseTime);
    }

    @Override
    public void recordResponseTimeInNanos(long responseTime, long exclusiveTime) {
        double responseTimeAsDouble = responseTime;
        responseTimeAsDouble *= responseTimeAsDouble;
        this.sumOfSquares += responseTimeAsDouble;
        this.minValue = this.count > 0 ? Math.min(responseTime, this.minValue) : responseTime;
        ++this.count;
        this.total += responseTime;
        this.maxValue = Math.max(responseTime, this.maxValue);
        this.totalExclusive += exclusiveTime;
    }

    @Override
    public boolean hasData() {
        return this.count > 0 || this.total > 0L || this.totalExclusive > 0L;
    }

    @Override
    public void reset() {
        this.count = 0;
        this.maxValue = 0L;
        this.minValue = 0L;
        this.totalExclusive = 0L;
        this.total = 0L;
        this.sumOfSquares = 0.0;
    }

    @Override
    public float getTotal() {
        return (float)this.total / 1.0E9f;
    }

    @Override
    public float getTotalExclusiveTime() {
        return (float)this.totalExclusive / 1.0E9f;
    }

    @Override
    public float getMaxCallTime() {
        return (float)this.maxValue / 1.0E9f;
    }

    @Override
    public float getMinCallTime() {
        return (float)this.minValue / 1.0E9f;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares / 1.0E18;
    }

    @Override
    public final void merge(StatsBase statsObj) {
        if (statsObj instanceof ResponseTimeStatsImpl) {
            ResponseTimeStatsImpl stats = (ResponseTimeStatsImpl)statsObj;
            if (stats.count > 0) {
                this.minValue = this.count > 0 ? Math.min(this.minValue, stats.minValue) : stats.minValue;
            }
            this.count += stats.count;
            this.total += stats.total;
            this.totalExclusive += stats.totalExclusive;
            this.maxValue = Math.max(this.maxValue, stats.maxValue);
            this.sumOfSquares += stats.sumOfSquares;
        }
    }

    @Override
    public void recordResponseTime(int count, long totalTime, long minTime, long maxTime, TimeUnit unit) {
        long totalTimeInNanos = TimeUnit.NANOSECONDS.convert(totalTime, unit);
        this.count = count;
        this.total = totalTimeInNanos;
        this.totalExclusive = totalTimeInNanos;
        this.minValue = TimeUnit.NANOSECONDS.convert(minTime, unit);
        this.maxValue = TimeUnit.NANOSECONDS.convert(maxTime, unit);
        double totalTimeInNanosAsDouble = totalTimeInNanos;
        totalTimeInNanosAsDouble *= totalTimeInNanosAsDouble;
        this.sumOfSquares += totalTimeInNanosAsDouble;
    }

    public String toString() {
        return "ResponseTimeStatsImpl [total=" + this.total + ", totalExclusive=" + this.totalExclusive + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", sumOfSquares=" + this.sumOfSquares + "]";
    }
}

