/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfig;
import com.newrelic.agent.config.BaseConfig;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class AttributesConfigImpl
extends BaseConfig
implements AttributesConfig {
    public static final String[] DEFAULT_BROWSER_EXCLUDES = new String[]{"request.parameters.*", "message.parameters.*", "library.solr.*", "jvm.*", "httpResponseMessage", "request.headers.referer", "httpResponseCode", "host.displayName", "process.instanceName", "request.headers.accept", "request.headers.host", "request.headers.userAgent", "request.method", "response.headers.contentType", "request.headers.contentLength"};
    public static final String[] DEFAULT_EVENTS_EXCLUDES = new String[]{"request.parameters.*", "message.parameters.*", "library.solr.*", "jvm.*", "httpResponseMessage"};
    public static final String[] DEFAULT_ERRORS_EXCLUDES = new String[0];
    public static final String[] DEFAULT_TRACES_EXCLUDES = new String[0];
    private static final boolean DEFAULT_ENABLED = true;
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.attributes.";
    public static final String ENABLED = "enabled";
    public static final String INCLUDE = "include";
    public static final String EXCLUDE = "exclude";
    public static final String ATTS_ENABLED = "attributes.enabled";
    public static final String ATTS_EXCLUDE = "attributes.exclude";
    public static final String ATTS_INCLUDE = "attributes.include";
    private final boolean enabledRoot = this.initEnabled();
    private final List<String> attributesInclude = this.initAttributesInclude();
    private final List<String> attributeExclude = this.initAttributesExclude();

    public AttributesConfigImpl(Map<String, Object> pProps) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
    }

    private boolean initEnabled() {
        return this.getProperty(ENABLED, true);
    }

    private List<String> initAttributesInclude() {
        return new ArrayList<String>(this.getUniqueStrings(INCLUDE, ","));
    }

    private List<String> initAttributesExclude() {
        return new ArrayList<String>(this.getUniqueStrings(EXCLUDE, ","));
    }

    @Override
    public boolean isEnabledRoot() {
        return this.enabledRoot;
    }

    @Override
    public List<String> attributesRootInclude() {
        return this.attributesInclude;
    }

    @Override
    public List<String> attributesRootExclude() {
        return this.attributeExclude;
    }

    @Override
    public boolean isAttsEnabled(AgentConfig config, boolean defaultProp, String ... dest) {
        if (!this.enabledRoot) {
            return false;
        }
        if (dest.equals("attributes")) {
            return this.enabledRoot;
        }
        boolean toEnable = false;
        for (String current : dest) {
            Boolean destEnabled = AttributesConfigImpl.getBooleanValue(config, current + "." + ATTS_ENABLED);
            if (destEnabled == null) continue;
            if (!destEnabled.booleanValue()) {
                return destEnabled;
            }
            toEnable = true;
        }
        return toEnable || defaultProp;
    }

    private static Boolean getBooleanValue(AgentConfig config, String value) {
        try {
            Object inputObj = config.getValue(value);
            if (inputObj != null) {
                if (inputObj instanceof Boolean) {
                    return (Boolean)inputObj;
                }
                if (inputObj instanceof String) {
                    return Boolean.parseBoolean((String)inputObj);
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, MessageFormat.format("The configuration property {0} should be a boolean but is not.", value));
        }
        return null;
    }

    static AttributesConfigImpl createAttributesConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new AttributesConfigImpl(settings);
    }
}

