package com.newrelic.agent.xray;

import java.util.List;
import java.util.Map;

import com.newrelic.agent.IRPMService;
import com.newrelic.agent.service.Service;

public interface IXRaySessionService extends Service {

    /**
     * This method accepts a list of Longs which are assumed to be X-Ray session IDs. It does the necessary adds and
     * deletes to make our local store match that new list of active X-Ray session IDs. For new sessions being added,
     * the metadata is fetched from RPM in order to populate details about the session. *
     * 
     * @param xrayIds
     * @param rpmService
     * @return result value to be returned from startXrayCommand.processRunning()
     * 
     */
    public abstract Map<?, ?> processSessionsList(List<Long> xrayIds, IRPMService rpmService);

    public abstract boolean isEnabled();

    public abstract void addListener(XRaySessionListener listener);

    public abstract void removeListener(XRaySessionListener listener);

}