package com.newrelic.agent.transport;

import com.newrelic.agent.config.AgentConfig;

public class DataSenderFactory {

    private static volatile IDataSenderFactory DATA_SENDER_FACTORY = new DefaultDataSenderFactory();

    private DataSenderFactory() {
    }

    public static void setDataSenderFactory(IDataSenderFactory dataSenderFactory) {
        if (dataSenderFactory == null) {
            return;
        }
        DATA_SENDER_FACTORY = dataSenderFactory;
    }

    /**
     * For testing.
     */
    public static IDataSenderFactory getDataSenderFactory() {
        return DATA_SENDER_FACTORY;
    }

    public static DataSender create(AgentConfig config) {
        return DATA_SENDER_FACTORY.create(config);
    }

    public static DataSender create(AgentConfig config, DataSenderListener dataSenderListener) {
        return DATA_SENDER_FACTORY.create(config, dataSenderListener);
    }

    private static class DefaultDataSenderFactory implements IDataSenderFactory {

        @Override
        public DataSender create(AgentConfig config) {
            return create(config, null);
        }

        @Override
        public DataSender create(AgentConfig config, DataSenderListener dataSenderListener) {
            return new DataSenderImpl(config, dataSenderListener);
        }
    }

}
