package com.newrelic.agent.tracing;

import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.bridge.TransportType;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.DistributedTracePayload;

import java.util.Map;

public interface DistributedTraceService {

    boolean isEnabled();

    int getMajorSupportedCatVersion();

    int getMinorSupportedCatVersion();

    String getAccountId();

    String getApplicationId();

    float calculatePriority(Float priority, DistributedSamplingPriorityQueue reservoir);

    Map<String, Object> getIntrinsics(DistributedTracePayloadImpl inboundPayload, String guid, String traceId, TransportType transportType,
            long parentTransportDuration, long largestTransportDuration, String parentId, String parentSpanId, float priority);

    String getTrustKey();

    DistributedTracePayload createDistributedTracePayload(Tracer tracer);

}
