package com.newrelic.agent.tracers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.instrumentation.PointCut;

/**
 * Tracer factories create {@link Tracer}s. They are strongly associated with {@link PointCut}s (point cuts usually
 * implement the factory).
 * 
 * TracerFactory implementations should have a default constructor. They are usually singletons.
 * 
 * @author sdaubin
 * 
 */
public interface TracerFactory extends PointCutInvocationHandler {
    /**
     * Returns a tracer to trace an individual method invocation.
     * 
     * @param transaction TODO
     * @param sig
     * @param object
     * @param args
     * @return
     */
    Tracer getTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args);

}
