package com.newrelic.agent.trace;

import java.util.Random;

public class TransactionGuidFactory {

    /**
     * A thread local which holds a {@link Random} whose seed is the thread id.
     */
    private static final ThreadLocal<Random> randomHolder = new ThreadLocal<Random>() {

        @Override
        protected Random initialValue() {
            return new Random();
        }

    };

    private TransactionGuidFactory() {
    }

    public static String generateGuid() {
        // Tests with JMH showed that this implementation is 11x faster than the previous implementation:
        // return new BigInteger(64, randomHolder.get()).toString(16)
        // and about 1.2x faster than the obvious alternative implementation:
        // return Long.toHexString(Math.abs(randomHolder.get().nextLong()))
        // In addition, this one returns 16 useful digits, while the obvious one returns slightly fewer.
        // Note that the digits are generated in "reverse order", which is perfectly fine here.
        final char[] hexchars = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
        long random = randomHolder.get().nextLong();
        char[] result = new char[16];
        for (int i = 0; i < 16; ++i) {
            result[i] = hexchars[(int) (random & 0xF)];
            random >>= 4;
        }
        return new String(result);
    }

}
