/**
 * 
 */
package com.newrelic.agent.stats;


final class IncrementCounter implements StatsWork {
    private final String name;
    private final int count;

    public IncrementCounter(String name, int count) {
        this.name = name;
        this.count = count;
    }

    @Override
    public void doWork(StatsEngine statsEngine) {
        statsEngine.getStats(name).incrementCallCount(count);
    }

    @Override
    public String getAppName() {
        return null;
    }

}