package com.newrelic.agent.service.module;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;

import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONStreamAware;

import com.newrelic.weave.utils.Streams;

/**
 * A module represents a jar file. We report the original jar file checksum and the bytes of the jar with all method
 * bodies removed from classes.
 * 
 * 
 * @author sdaubin
 *
 */
public class Module implements JSONStreamAware {
    final String checksum;
    final File moduleFile;

    public Module(String checksum, File moduleFile) {
        super();
        this.checksum = checksum;
        this.moduleFile = moduleFile;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {

        JSONStreamAware data = new JSONStreamAware() {

            @Override
            public void writeJSONString(Writer out) throws IOException {
                out.write('"');
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                InputStream in = new FileInputStream(moduleFile);
                try {
                    Streams.copy(in, bytesOut, false);
                } finally {
                    in.close();
                    bytesOut.close();
                }
                out.write(Base64.encodeBase64String(bytesOut.toByteArray()));
                out.write('"');
            }
        };

        JSONArray.writeJSONString(Arrays.asList(checksum, data), writer);
    }

}
