package com.newrelic.agent.service.analytics;

import com.google.common.collect.Maps;

public class ClassHistogramRowEvent extends BaseInternalCustomEvent {

    private static final String TYPE = "ClassHistogramRowEvent";

    private final long classInstances;
    private final long classBytes;
    private final long classInstancesDelta;
    private final long classBytesDelta;
    private final String className;
    private final String classType;

    public ClassHistogramRowEvent(String appName, long classInstances, long classBytes, long classInstancesDelta,
            long classBytesDelta, String className, String classType) {
        super(appName, TYPE, Maps.<String, Object>newHashMap());

        this.classInstances = classInstances;
        this.classBytes = classBytes;
        this.classInstancesDelta = classInstancesDelta;
        this.classBytesDelta = classBytesDelta;
        this.className = className;
        this.classType = classType;

        this.userAttributes.put("classInstances", classInstances);
        this.userAttributes.put("classBytes", classBytes);
        this.userAttributes.put("classInstancesDelta", classInstancesDelta);
        this.userAttributes.put("classBytesDelta", classBytesDelta);
        this.userAttributes.put("className", className);
        this.userAttributes.put("classType", classType);
    }

    public long getClassInstances() {
        return classInstances;
    }

    public long getClassBytes() {
        return classBytes;
    }

    public long getClassInstancesDelta() {
        return classInstancesDelta;
    }

    public long getClassBytesDelta() {
        return classBytesDelta;
    }

    public String getClassName() {
        return className;
    }

    public String getClassType() {
        return classType;
    }

    @Override
    public String toString() {
        return "ClassHistogramRowEvent{" +
                "classInstances=" + classInstances +
                ", classBytes=" + classBytes +
                ", classInstancesDelta=" + classInstancesDelta +
                ", classBytesDelta=" + classBytesDelta +
                ", className='" + className + '\'' +
                ", classType='" + classType + '\'' +
                '}';
    }

}
