package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;

import java.util.logging.Level;

class AdaptiveSampling {

    static int decidedLast(DistributedSamplingPriorityQueue<?> reservoir, int target) {
        if (reservoir == null) {
            return 0;
        }

        Agent.LOG.log(Level.FINER, "Application \"{0}\" decided {1} event(s) for {2}, sampled {3} of them with a target of {4}, decided {5} last time",
                reservoir.getAppName(), reservoir.getDecided(), reservoir.getServiceName(), reservoir.getSampled(), target, reservoir.getDecidedLast());

        return reservoir.getDecided();
    }

}
